/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.network;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.LoginPacketSerializer;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public abstract class NetworkX {
    private static final Object LOCK = new Object();
    public final SimpleChannel channel;
    private final Protocol protocol = this.getProtocol();
    private int discriminator = 0;

    protected NetworkX(ModX mod) {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)mod.resource("netchannel"), this.protocol::version, remote -> this.protocol.client().predicate.test(this.protocol.version(), (String)remote), remote -> this.protocol.server().predicate.test(this.protocol.version(), (String)remote));
        ModInternal.get(mod).addSetupTask(this::registerPackets, false);
    }

    protected abstract Protocol getProtocol();

    protected abstract void registerPackets();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> void registerGame(NetworkDirection direction, PacketSerializer<T> serializer, Supplier<Supplier<PacketHandler<T>>> handler) {
        NetworkX.validateMessage(direction, serializer, false);
        BiConsumer<T, Supplier<NetworkEvent.Context>> action = NetworkX.resolveHandler(direction, serializer, handler);
        Object object = LOCK;
        synchronized (object) {
            this.channel.registerMessage(this.discriminator++, serializer.messageClass(), serializer::encode, serializer::decode, action, Optional.of(direction));
            this.channel.messageBuilder(serializer.messageClass(), this.discriminator++, direction).encoder(serializer::encode).decoder(serializer::decode).consumerNetworkThread(action).noResponse().add();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T extends IntSupplier> void registerLogin(NetworkDirection direction, LoginPacketSerializer<T> serializer, Supplier<Supplier<PacketHandler<T>>> handler) {
        NetworkX.validateMessage(direction, serializer, true);
        BiConsumer<T, Supplier<NetworkEvent.Context>> action = NetworkX.resolveHandler(direction, serializer, handler);
        Object object = LOCK;
        synchronized (object) {
            SimpleChannel.MessageBuilder builder = this.channel.messageBuilder(serializer.messageClass(), this.discriminator++, direction).encoder(serializer::encode).decoder(serializer::decode).consumerNetworkThread(action).markAsLoginPacket().loginIndex(serializer::getLoginIndex, serializer::setLoginIndex).buildLoginPacketList(isLocal -> {
                List packets = serializer.buildLoginPackets((boolean)isLocal);
                return packets.stream().map(p -> Pair.of((Object)p.context(), p.message())).toList();
            });
            if (!serializer.needsResponse()) {
                builder.noResponse();
            }
            builder.add();
        }
    }

    private static <T> void validateMessage(NetworkDirection direction, PacketSerializer<T> serializer, boolean login) {
        Objects.requireNonNull(direction, "No network direction");
        if (login) {
            if (direction == NetworkDirection.PLAY_TO_CLIENT || direction == NetworkDirection.PLAY_TO_SERVER) {
                throw new IllegalArgumentException("Use registerGame to register game packets.");
            }
        } else if (direction == NetworkDirection.LOGIN_TO_CLIENT || direction == NetworkDirection.LOGIN_TO_SERVER) {
            throw new IllegalArgumentException("Use registerLogin to register login packets.");
        }
        if (!Modifier.isFinal(serializer.messageClass().getModifiers())) {
            throw new IllegalArgumentException("Non-final message class");
        }
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> resolveHandler(NetworkDirection direction, PacketSerializer<T> serializer, Supplier<Supplier<PacketHandler<T>>> supplier) {
        PacketHandler handler = direction.getReceptionSide() == LogicalSide.CLIENT ? (PacketHandler)DistExecutor.unsafeRunForDist(supplier, () -> () -> null) : supplier.get().get();
        if (handler == null) {
            return (msg, ctx) -> {};
        }
        if (handler.getClass() == serializer.getClass()) {
            throw new IllegalStateException("The packet handler must be a different class than the packet serializer.");
        }
        return switch (handler.target()) {
            default -> throw new IncompatibleClassChangeError();
            case PacketHandler.Target.MAIN_THREAD -> (msg, ctx) -> {
                ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> NetworkX.lambda$resolveHandler$7(handler, msg, (Supplier)ctx));
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            };
            case PacketHandler.Target.NETWORK_THREAD -> (msg, ctx) -> {
                boolean handled = handler.handle((Object)msg, (Supplier<NetworkEvent.Context>)ctx);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(handled);
            };
        };
    }

    private static /* synthetic */ void lambda$resolveHandler$7(PacketHandler handler, Object msg, Supplier ctx) {
        handler.handle(msg, ctx);
    }

    public record Protocol(String version, ProtocolSide client, ProtocolSide server) {
        public static Protocol of(String version) {
            return new Protocol(version, ProtocolSide.REQUIRED, ProtocolSide.REQUIRED);
        }
    }

    public static enum ProtocolSide {
        REQUIRED(String::equals),
        OPTIONAL(ProtocolSide.REQUIRED.predicate.or((version, remote) -> NetworkRegistry.ABSENT.version().equals(remote))),
        VANILLA(ProtocolSide.OPTIONAL.predicate.or((version, remote) -> NetworkRegistry.ACCEPTVANILLA.equals(remote))),
        REJECTED((version, remote) -> false);

        private final BiPredicate<String, String> predicate;

        private ProtocolSide(BiPredicate<String, String> predicate) {
            this.predicate = predicate;
        }
    }
}

