/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.lazy;

import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class CachedValue<T> {
    private final Supplier<? extends T> supplier;
    private T value;
    private boolean valid;

    public CachedValue(@Nonnull Supplier<? extends T> supplier) {
        this.supplier = supplier;
        this.value = null;
        this.valid = false;
    }

    public T get() {
        if (!this.valid) {
            this.value = this.supplier.get();
            this.valid = true;
        }
        return this.value;
    }

    public CachedValue<T> copy() {
        CachedValue<? extends T> copy = new CachedValue<T>(this.supplier);
        if (this.valid) {
            copy.value = this.value;
            copy.valid = true;
        }
        return copy;
    }

    public void invalidate() {
        this.valid = false;
    }
}

