/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.CompoundSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_SLAB})
public final class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SLAB -> SlabSkipPredicate.testAgainstSlab(top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> SlabSkipPredicate.testAgainstEdge(top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SlabSkipPredicate.testAgainstStairs(top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> SlabSkipPredicate.testAgainstElevatedSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> SlabSkipPredicate.testAgainstCompoundSlopeSlab(top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> SlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE -> SlabSkipPredicate.testAgainstVerticalHalfStairs(top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> SlabSkipPredicate.testAgainstSlopedStairs(top, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> SlabSkipPredicate.testAgainstSlopeEdge(top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> SlabSkipPredicate.testAgainstElevatedSlopeEdge(top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstEdge(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(CompoundSlopeSlabSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfStairs(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.m_61143_((Property)PropertyHolder.ALT_TYPE);
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(SlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, adjAlt, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        return SlabSkipPredicate.getHalfDir(top, side).isEqualTo(ElevatedSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()));
    }

    public static HalfDir getHalfDir(boolean top, Direction side) {
        if (!Utils.isY(side)) {
            return HalfDir.fromDirections(side, top ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }
}

