/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IDelayVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.blockentity.BlockEntityProxy;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.evaluate.DelayVariableFacadeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.DelayVariableFacade;
import org.cyclops.integrateddynamics.inventory.container.ContainerDelay;
import org.cyclops.integrateddynamics.network.DelayNetworkElement;

public class BlockEntityDelay
extends BlockEntityProxy
implements MenuProvider {
    public static final int INVENTORY_SIZE = 3;
    protected Queue<IValue> values = null;
    @NBTPersist
    private int capacity = 5;
    @NBTPersist
    private int updateInterval = 1;
    private ValueTypeList.ValueList list = ValueTypes.LIST.getDefault();
    private final IVariable<?> variable = new VariableAdapter<ValueTypeList.ValueList>(){

        public ValueTypeList getType() {
            return ValueTypes.LIST;
        }

        @Override
        public ValueTypeList.ValueList getValue() throws EvaluationException {
            if (BlockEntityDelay.this.lastError != null) {
                throw BlockEntityDelay.this.lastError;
            }
            return BlockEntityDelay.this.list;
        }
    };
    private Player lastPlayer = null;
    private EvaluationException lastError = null;

    public BlockEntityDelay(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_DELAY, blockPos, blockState, 3);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new DelayNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
    }

    @Override
    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, DelayVariableFacadeHandler.getInstance(), new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IDelayVariableFacade>(){

            @Override
            public IDelayVariableFacade create(boolean generateId) {
                return new DelayVariableFacade(generateId, proxyId);
            }

            @Override
            public IDelayVariableFacade create(int id) {
                return new DelayVariableFacade(id, proxyId);
            }
        }, this.m_58904_(), this.lastPlayer, this.m_58900_());
    }

    @Override
    public IVariable<?> getVariable(IPartNetwork network) {
        return this.variable;
    }

    public IVariable<?> getVariableSuper(IPartNetwork network) {
        return super.getVariable(network);
    }

    public void setCapacity(int capacity) {
        this.capacity = Math.max(1, capacity);
        this.values = Queues.newArrayBlockingQueue((int)this.capacity);
    }

    public Queue<IValue> getValues() {
        if (this.values == null) {
            this.values = Queues.newArrayBlockingQueue((int)this.capacity);
        }
        return this.values;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag valueList = new ListTag();
        for (IValue value : this.getValues()) {
            valueList.add((Object)ValueHelpers.serialize(value));
        }
        tag.m_128365_("values", (Tag)valueList);
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        if (this.capacity <= 0) {
            this.capacity = 1;
        }
        this.values = Queues.newArrayBlockingQueue((int)this.capacity);
        ListTag valueList = tag.m_128437_("values", 10);
        for (int i = 0; i < valueList.size(); ++i) {
            IValue value = ValueHelpers.deserialize(ValueDeseralizationContext.of(this.m_58904_()), valueList.m_128728_(i));
            if (value == null) continue;
            this.values.add(value);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerDelay(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"block.integrateddynamics.delay");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public void setLastPlayer(Player lastPlayer) {
        this.lastPlayer = lastPlayer;
    }

    public static class Ticker
    extends BlockEntityProxy.Ticker<BlockEntityDelay> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityDelay blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (!level.f_46443_ && blockEntity.updateInterval > 0 && level.m_46467_() % (long)blockEntity.updateInterval == 0L) {
                while (blockEntity.getValues().size() >= blockEntity.capacity) {
                    blockEntity.getValues().poll();
                }
                IPartNetwork partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork(blockEntity.getNetwork()).orElse(null);
                if (partNetwork == null) {
                    return;
                }
                IVariable<?> variable = blockEntity.getVariableSuper(partNetwork);
                IValue value = null;
                if (variable != null) {
                    try {
                        value = (IValue)variable.getValue();
                        blockEntity.lastError = null;
                    }
                    catch (EvaluationException e) {
                        blockEntity.getEvaluator().addError(e.getErrorMessage());
                        blockEntity.lastError = e;
                    }
                    if (value != null) {
                        try {
                            if (blockEntity.list.getRawValue().getLength() > 0 && blockEntity.list.getRawValue().getValueType() != value.getType()) {
                                blockEntity.getValues().clear();
                            }
                        }
                        catch (EvaluationException evaluationException) {
                            // empty catch block
                        }
                        blockEntity.getValues().add(value);
                        blockEntity.list = ValueTypeList.ValueList.ofList(value.getType(), Lists.newArrayList(blockEntity.values));
                    }
                } else {
                    blockEntity.getValues().clear();
                    blockEntity.list = ValueTypes.LIST.getDefault();
                }
                blockEntity.variable.invalidate();
            }
        }
    }
}

