/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.joml.Matrix4f;

public class RenderBlockEntityEnergyBattery
implements BlockEntityRenderer<BlockEntityEnergyBattery> {
    private static final float OFFSET = 0.001f;
    private static final float MINY = 0.0f;
    private static final float MAXY = 1.0f;
    private static final float MIN = -0.001f;
    private static final float MAX = 1.001f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{-0.001f, 0.0f, -0.001f}, {-0.001f, 0.0f, 1.001f}, {1.001f, 0.0f, 1.001f}, {1.001f, 0.0f, -0.001f}}, new float[][]{{-0.001f, 1.0f, -0.001f}, {-0.001f, 1.0f, 1.001f}, {1.001f, 1.0f, 1.001f}, {1.001f, 1.0f, -0.001f}}, new float[][]{{-0.001f, 0.0f, -0.001f}, {-0.001f, 1.0f, -0.001f}, {1.001f, 1.0f, -0.001f}, {1.001f, 0.0f, -0.001f}}, new float[][]{{1.001f, 0.0f, 1.001f}, {1.001f, 1.0f, 1.001f}, {-0.001f, 1.0f, 1.001f}, {-0.001f, 0.0f, 1.001f}}, new float[][]{{-0.001f, 0.0f, 1.001f}, {-0.001f, 1.0f, 1.001f}, {-0.001f, 1.0f, -0.001f}, {-0.001f, 0.0f, -0.001f}}, new float[][]{{1.001f, 0.0f, -0.001f}, {1.001f, 1.0f, -0.001f}, {1.001f, 1.0f, 1.001f}, {1.001f, 0.0f, 1.001f}}};

    public RenderBlockEntityEnergyBattery(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityEnergyBattery tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null && tile.getEnergyStored() > 0) {
            float height = (float)tile.getEnergyStored() / (float)tile.getMaxEnergyStored();
            height = height * 12.0f / 16.0f + 0.125f;
            matrixStack.m_85836_();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_121955_(side.m_122436_()));
                TextureAtlasSprite icon = RegistryEntries.BLOCK_ENERGY_BATTERY.iconOverlay;
                float[][] c = coordinates[side.ordinal()];
                float replacedMaxV = icon.m_118412_();
                float replacedMinV = (icon.m_118411_() - icon.m_118412_()) * height + icon.m_118412_();
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (tile.isCreative()) {
                    float tickFactor = (float)tile.m_58904_().m_46467_() % 20.0f / 10.0f;
                    if (tickFactor > 1.0f) {
                        tickFactor = -tickFactor + 1.0f;
                    }
                    r = 0.8f + 0.2f * tickFactor;
                    g = 0.42f;
                    b = 0.6f + 0.4f * tickFactor;
                }
                VertexConsumer vb = renderTypeBuffer.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_247685_()));
                Matrix4f matrix = matrixStack.m_85850_().m_252922_();
                vb.m_252986_(matrix, c[0][0], c[0][1] * height, c[0][2]).m_85950_(r, g, b, 1.0f).m_7421_(icon.m_118409_(), replacedMaxV).m_85969_(combinedLight).m_5752_();
                vb.m_252986_(matrix, c[1][0], c[1][1] * height, c[1][2]).m_85950_(r, g, b, 1.0f).m_7421_(icon.m_118409_(), replacedMinV).m_85969_(combinedLight).m_5752_();
                vb.m_252986_(matrix, c[2][0], c[2][1] * height, c[2][2]).m_85950_(r, g, b, 1.0f).m_7421_(icon.m_118410_(), replacedMinV).m_85969_(combinedLight).m_5752_();
                vb.m_252986_(matrix, c[3][0], c[3][1] * height, c[3][2]).m_85950_(r, g, b, 1.0f).m_7421_(icon.m_118410_(), replacedMaxV).m_85969_(combinedLight).m_5752_();
            }
            matrixStack.m_85849_();
        }
    }
}

