/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.ItemInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockstateProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public BlockstateProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.m_6968_();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        ModelGenerator generator = new ModelGenerator();
        generator.registerStatesAndModels(blockStateOutput, modelOutput);
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            this.createBedItem((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("bed").get(), (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get(), modelOutput);
            this.createBannerItem((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("banner").get(), modelOutput);
            this.createShulkerBox((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("shulker_box").get(), modelOutput);
            this.createSimpleFlatItemModel(((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("candle").get()).m_5456_(), modelOutput);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get(), itemModels);
            this.addOtherBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("rockwool").get(), (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("carpet").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("terracotta").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("glazed_terracotta").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("concrete").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("concrete_powder").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass").get(), itemModels);
            this.createSimpleFlatItemModel((Item)ItemInit.DYE_ITEMS.get(color.m_7912_() + "_dye").get(), modelOutput);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.m_245731_(ForgeRegistries.BLOCKS.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.m_245731_(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.m_125571_((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemParentModel(Block block, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.f_41373_.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ForgeRegistries.BLOCKS.getKey((Object)block).m_247266_(p -> "block/" + p)), itemModels);
        }
    }

    private void addOtherBlockItemParentModel(Block block, Block otherBlock, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.f_41373_.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ForgeRegistries.BLOCKS.getKey((Object)otherBlock).m_247266_(p -> "block/" + p)), itemModels);
        }
    }

    private void createSimpleFlatItemModel(Item pFlatItem, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)pFlatItem), TextureMapping.m_125766_((Item)pFlatItem), itemModels);
    }

    private void createBedItem(Block pBedBlock, Block pWoolBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.f_125662_.m_125612_(ModelLocationUtils.m_125571_((Item)pBedBlock.m_5456_()), TextureMapping.m_125834_((Block)pWoolBlock), itemModels);
    }

    private void createBannerItem(Block pBedBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.f_125663_.m_125612_(ModelLocationUtils.m_125571_((Item)pBedBlock.m_5456_()), TextureMapping.m_125834_((Block)Blocks.f_50705_), itemModels);
    }

    private void createShulkerBox(Block pShulkerBoxBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.f_125661_.m_125612_(ModelLocationUtils.m_125571_((Item)pShulkerBoxBlock.m_5456_()), TextureMapping.m_125834_((Block)pShulkerBoxBlock), itemModels);
    }

    public String m_6055_() {
        return "Dyenamics Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
                this.blockStateOutput.accept((BlockStateGenerator)this.createEntityBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("bed").get(), ModelLocationUtils.m_125581_((String)"bed")));
                this.blockStateOutput.accept((BlockStateGenerator)this.createEntityBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("banner").get(), ModelLocationUtils.m_125581_((String)"banner")));
                this.blockStateOutput.accept((BlockStateGenerator)this.createEntityBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wall_banner").get(), ModelLocationUtils.m_125581_((String)"banner")));
                this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("shulker_box").get(), TexturedModel.f_125916_.m_125956_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("shulker_box").get(), this.modelOutput)));
                this.createCandleAndCandleCake((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("candle").get(), (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("candle_cake").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get());
                this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("rockwool").get(), ModelLocationUtils.m_125576_((Block)((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get()))));
                this.createCarpetBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get(), (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("carpet").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("terracotta").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("glazed_terracotta").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("concrete").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("concrete_powder").get());
                this.createGlassBlocks((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass").get(), (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass_pane").get());
            }
        }

        private void createCubeBlock(Block pBlock) {
            this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock(pBlock, ModelTemplates.f_125692_.m_125592_(pBlock, TextureMapping.m_125768_((Block)pBlock).m_125758_(TextureSlot.f_125867_, ModelLocationUtils.m_125576_((Block)pBlock)), this.modelOutput)));
        }

        private void createGlassBlock(Block pBlock) {
            ModelTemplate template = new ModelTemplate(Optional.of(new ResourceLocation("dyenamics", "block/stained_glass")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
            this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock(pBlock, template.m_125592_(pBlock, TextureMapping.m_125768_((Block)pBlock).m_125758_(TextureSlot.f_125867_, ModelLocationUtils.m_125576_((Block)pBlock)), this.modelOutput)));
        }

        private MultiVariantGenerator createEntityBlock(Block pBlock, ResourceLocation pBaseModel) {
            return MultiVariantGenerator.m_125256_((Block)pBlock, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pBaseModel));
        }

        private MultiVariantGenerator createSimpleBlock(Block pBlock, ResourceLocation pModelLocation) {
            return MultiVariantGenerator.m_125256_((Block)pBlock, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pModelLocation));
        }

        private void createCarpetBlock(Block wool, Block carpet) {
            ResourceLocation resourcelocation = TexturedModel.f_125913_.m_125964_(wool).m_125937_(carpet, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock(carpet, resourcelocation));
        }

        private void createCandleAndCandleCake(Block pCandleBlock, Block pCandleCakeBlock) {
            TextureMapping candleTextureMapping = TextureMapping.m_125776_((ResourceLocation)TextureMapping.m_125740_((Block)pCandleBlock));
            TextureMapping litCandleTextureMapping = TextureMapping.m_125776_((ResourceLocation)TextureMapping.m_125753_((Block)pCandleBlock, (String)"_lit"));
            ResourceLocation oneCandle = ModelTemplates.f_176468_.m_125596_(pCandleBlock, "_one_candle", candleTextureMapping, this.modelOutput);
            ResourceLocation twoCandles = ModelTemplates.f_176469_.m_125596_(pCandleBlock, "_two_candles", candleTextureMapping, this.modelOutput);
            ResourceLocation threeCandles = ModelTemplates.f_176470_.m_125596_(pCandleBlock, "_three_candles", candleTextureMapping, this.modelOutput);
            ResourceLocation fourCandles = ModelTemplates.f_176471_.m_125596_(pCandleBlock, "_four_candles", candleTextureMapping, this.modelOutput);
            ResourceLocation oneCandleLit = ModelTemplates.f_176468_.m_125596_(pCandleBlock, "_one_candle_lit", litCandleTextureMapping, this.modelOutput);
            ResourceLocation twoCandlesLit = ModelTemplates.f_176469_.m_125596_(pCandleBlock, "_two_candles_lit", litCandleTextureMapping, this.modelOutput);
            ResourceLocation threeCandlesLit = ModelTemplates.f_176470_.m_125596_(pCandleBlock, "_three_candles_lit", litCandleTextureMapping, this.modelOutput);
            ResourceLocation fourCandlesLit = ModelTemplates.f_176471_.m_125596_(pCandleBlock, "_four_candles_lit", litCandleTextureMapping, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)pCandleBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125296_((Property)BlockStateProperties.f_155994_, (Property)BlockStateProperties.f_61443_).m_125350_((Comparable)Integer.valueOf(1), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)oneCandle)).m_125350_((Comparable)Integer.valueOf(2), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)twoCandles)).m_125350_((Comparable)Integer.valueOf(3), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)threeCandles)).m_125350_((Comparable)Integer.valueOf(4), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fourCandles)).m_125350_((Comparable)Integer.valueOf(1), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)oneCandleLit)).m_125350_((Comparable)Integer.valueOf(2), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)twoCandlesLit)).m_125350_((Comparable)Integer.valueOf(3), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)threeCandlesLit)).m_125350_((Comparable)Integer.valueOf(4), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fourCandlesLit))));
            ResourceLocation candleCake = ModelTemplates.f_176472_.m_125592_(pCandleCakeBlock, TextureMapping.m_181476_((Block)pCandleBlock, (boolean)false), this.modelOutput);
            ResourceLocation candleCakeLit = ModelTemplates.f_176472_.m_125596_(pCandleCakeBlock, "_lit", TextureMapping.m_181476_((Block)pCandleBlock, (boolean)true), this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)pCandleCakeBlock).m_125271_(ModelGenerator.createBooleanModelDispatch(BlockStateProperties.f_61443_, candleCakeLit, candleCake)));
        }

        private void createGlassBlocks(Block pGlassBlock, Block pPaneBlock) {
            this.createGlassBlock(pGlassBlock);
            TextureMapping texturemapping = TextureMapping.m_125770_((Block)pGlassBlock, (Block)pPaneBlock);
            ResourceLocation panePost = ModelTemplates.f_125673_.m_125592_(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation paneSide = ModelTemplates.f_125674_.m_125592_(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation paneSideAlt = ModelTemplates.f_125675_.m_125592_(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation pandNoside = ModelTemplates.f_125671_.m_125592_(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation paneNosideAlt = ModelTemplates.f_125672_.m_125592_(pPaneBlock, texturemapping, this.modelOutput);
            Item item = pPaneBlock.m_5456_();
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125738_((Block)pGlassBlock), this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)pPaneBlock).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)panePost)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)paneSide)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)paneSide).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)paneSideAlt)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)paneSideAlt).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pandNoside)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)paneNosideAlt)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)paneNosideAlt).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pandNoside).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)));
        }

        private static PropertyDispatch createBooleanModelDispatch(BooleanProperty pProperty, ResourceLocation pTrueModelLocation, ResourceLocation pFalseModelLocation) {
            return PropertyDispatch.m_125294_((Property)pProperty).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pTrueModelLocation)).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pFalseModelLocation));
        }
    }
}

