/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ThermalCentrifugeRecipeBuilder
implements RecipeBuilder {
    public final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private final Ingredient ingredient;
    private final List<ItemStack> results;
    private final int energy;

    public ThermalCentrifugeRecipeBuilder(Ingredient ingredient, List<ItemStack> results, int energy) {
        this.ingredient = ingredient;
        this.results = results;
        this.energy = energy;
    }

    public static ThermalCentrifugeRecipeBuilder direct(Ingredient ingredient, List<ItemStack> results, int energy) {
        return new ThermalCentrifugeRecipeBuilder(ingredient, results, energy);
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.results.get(0).m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.ingredient, this.results, this.energy, this.advancement));
    }

    public static JsonObject itemToJson(ItemStack item) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).toString());
        if (item.m_41613_() > 1) {
            json.addProperty("count", (Number)item.m_41613_());
        }
        if (item.m_41783_() != null) {
            json.addProperty("type", "forge:nbt");
            json.addProperty("nbt", ((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)item.m_41783_())).toString());
        }
        return json;
    }

    record Result(ResourceLocation id, Ingredient ingredient, List<ItemStack> results, int energy, Advancement.Builder advancement) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonArray resultArray = new JsonArray();
            this.results.forEach(itemStack -> resultArray.add((JsonElement)ThermalCentrifugeRecipeBuilder.itemToJson(itemStack)));
            json.add("result", (JsonElement)resultArray);
            json.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("thermal:centrifuge"));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.id.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/");
        }
    }
}

