/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget.directional.handlers;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.gui.widget.directional.IDirectionalConfigHandler;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AutoOutputFluidConfigHandler
implements IDirectionalConfigHandler {
    private static final IGuiTexture TEXTURE_OFF = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, GuiTextures.IO_CONFIG_FLUID_MODES_BUTTON.getSubTexture(0.0f, 0.0f, 1.0f, 0.33333334f)});
    private static final IGuiTexture TEXTURE_OUTPUT = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, GuiTextures.IO_CONFIG_FLUID_MODES_BUTTON.getSubTexture(0.0f, 0.33333334f, 1.0f, 0.33333334f)});
    private static final IGuiTexture TEXTURE_AUTO = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, GuiTextures.IO_CONFIG_FLUID_MODES_BUTTON.getSubTexture(0.0f, 0.6666667f, 1.0f, 0.33333334f)});
    private final IAutoOutputFluid machine;
    private Direction side;
    private ButtonWidget ioModeButton;

    public AutoOutputFluidConfigHandler(IAutoOutputFluid machine) {
        this.machine = machine;
    }

    @Override
    public Widget getSideSelectorWidget(SceneWidget scene, FancyMachineUIWidget machineUI) {
        WidgetGroup group = new WidgetGroup(0, 0, 37, 18);
        this.ioModeButton = new ButtonWidget(0, 0, 18, 18, this::onIOModePressed){

            public void updateScreen() {
                super.updateScreen();
                if (AutoOutputFluidConfigHandler.this.machine.getOutputFacingFluids() == AutoOutputFluidConfigHandler.this.side) {
                    if (AutoOutputFluidConfigHandler.this.machine.isAutoOutputFluids()) {
                        this.setButtonTexture(new IGuiTexture[]{TEXTURE_AUTO});
                    } else {
                        this.setButtonTexture(new IGuiTexture[]{TEXTURE_OUTPUT});
                    }
                } else {
                    this.setButtonTexture(new IGuiTexture[]{TEXTURE_OFF});
                }
            }
        };
        group.addWidget((Widget)this.ioModeButton);
        group.addWidget((Widget)new ToggleButtonWidget(19, 0, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this.machine::isAllowInputFromOutputSideFluids, this.machine::setAllowInputFromOutputSideFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.allow_input"));
        return group;
    }

    private void onIOModePressed(ClickData cd) {
        if (this.side == null) {
            return;
        }
        if (this.machine.getOutputFacingFluids() == this.side) {
            this.machine.setAutoOutputFluids(!this.machine.isAutoOutputFluids());
        } else {
            this.machine.setAutoOutputFluids(false);
            this.machine.setOutputFacingFluids(this.side);
        }
    }

    @Override
    public void onSideSelected(BlockPos pos, Direction side) {
        this.side = side;
    }

    @Override
    public IDirectionalConfigHandler.ScreenSide getScreenSide() {
        return IDirectionalConfigHandler.ScreenSide.LEFT;
    }

    @Override
    public void handleClick(ClickData cd, Direction direction) {
        if (!this.canHandleClick(cd) || !this.machine.hasAutoOutputFluid()) {
            return;
        }
        if (this.machine.getOutputFacingFluids() != this.side) {
            this.machine.setOutputFacingFluids(this.side);
            this.machine.setAutoOutputFluids(false);
        } else {
            this.machine.setAutoOutputFluids(!this.machine.isAutoOutputFluids());
        }
    }

    private boolean canHandleClick(ClickData cd) {
        if (cd.button == 1) {
            return true;
        }
        return !(this.machine instanceof IAutoOutputItem) && cd.button == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(SceneWidget sceneWidget, BlockPosFace blockPosFace) {
        if (this.machine.getOutputFacingFluids() != blockPosFace.facing) {
            return;
        }
        sceneWidget.drawFacingBorder(new PoseStack(), blockPosFace, this.machine.isAutoOutputFluids() ? -16730881 : -1895779073, 2);
    }

    @Override
    public void addAdditionalUIElements(WidgetGroup parent) {
        LabelWidget text = new LabelWidget(4, 4, "gtceu.gui.auto_output.name"){

            public boolean isVisible() {
                return AutoOutputFluidConfigHandler.this.machine.isAutoOutputFluids() && AutoOutputFluidConfigHandler.this.machine.getOutputFacingFluids() != null;
            }
        };
        text.setSelfPosition(new Position(parent.getSize().width - 4 - text.getSize().width, 4));
        text.setTextColor(-16730881).setDropShadow(false);
        parent.addWidget((Widget)text);
    }
}

