/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTAxeItem;
import com.gregtechceu.gtceu.api.item.tool.GTHoeItem;
import com.gregtechceu.gtceu.api.item.tool.GTShovelItem;
import com.gregtechceu.gtceu.api.item.tool.GTSwordItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.item.tool.ToolDefinitionBuilder;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.item.tool.behavior.AOEConfigUIBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.BlockRotatingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.DisableShieldBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.EntityDamageBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.GrassPathBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestCropsBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestIceBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HoeGroundBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.LogStripBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.PlungerBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.RotateRailBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ScrapeBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ToolModeSwitchBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.TorchPlaceBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.TreeFellingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.WaxOffBehavior;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTToolType {
    private static final Map<String, GTToolType> types = new HashMap<String, GTToolType>();
    public static final GTToolType SWORD = GTToolType.builder("sword").toolTag(ItemTags.f_271388_).harvestTag(BlockTags.f_278398_).toolStats(b -> b.attacking().attackDamage(3.0f).attackSpeed(-2.4f)).constructor(GTSwordItem::create).toolClassNames("sword").materialAmount(7257600L).build();
    public static final GTToolType PICKAXE = GTToolType.builder("pickaxe").toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).toolStats(b -> b.blockBreaking().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(TorchPlaceBehavior.INSTANCE)).toolClassNames("pickaxe").materialAmount(10886400L).build();
    public static final GTToolType SHOVEL = GTToolType.builder("shovel").toolTag(ItemTags.f_271138_).harvestTag(BlockTags.f_144283_).toolStats(b -> b.blockBreaking().attackDamage(1.5f).attackSpeed(-3.0f).behaviors(GrassPathBehavior.INSTANCE)).constructor(GTShovelItem::create).toolClassNames("shovel").materialAmount(3628800L).build();
    public static final GTToolType AXE = GTToolType.builder("axe").toolTag(ItemTags.f_271207_).harvestTag(BlockTags.f_144280_).toolStats(b -> b.blockBreaking().attackDamage(5.0f).attackSpeed(-3.2f).baseEfficiency(2.0f).behaviors(DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE, LogStripBehavior.INSTANCE, ScrapeBehavior.INSTANCE, WaxOffBehavior.INSTANCE)).constructor(GTAxeItem::create).toolClassNames("axe").materialAmount(10886400L).build();
    public static final GTToolType HOE = GTToolType.builder("hoe").toolTag(ItemTags.f_271298_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.cannotAttack().attackSpeed(-1.0f).behaviors(HoeGroundBehavior.INSTANCE)).constructor(GTHoeItem::create).toolClassNames("hoe").materialAmount(7257600L).build();
    public static final GTToolType MINING_HAMMER = GTToolType.builder("mining_hammer").toolTag(CustomTags.MINING_HAMMERS).harvestTag(BlockTags.f_144282_).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).toolClasses(PICKAXE).materialAmount(21772800L).build();
    public static final GTToolType SPADE = GTToolType.builder("spade").toolTag(CustomTags.SPADES).harvestTag(BlockTags.f_144283_).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(AOEConfigUIBehavior.INSTANCE, GrassPathBehavior.INSTANCE)).toolClasses(SHOVEL).materialAmount(10886400L).build();
    public static final GTToolType SCYTHE = GTToolType.builder("scythe").toolTag(CustomTags.SCYTHES).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().attacking().attackDamage(5.0f).attackSpeed(-3.0f).durabilityMultiplier(3.0f).aoe(2, 2, 2).behaviors(AOEConfigUIBehavior.INSTANCE, HoeGroundBehavior.INSTANCE, HarvestCropsBehavior.INSTANCE).canApplyEnchantment(EnchantmentCategory.DIGGER)).constructor(GTHoeItem::create).toolClassNames("scythe").toolClasses(HOE).materialAmount(10886400L).build();
    public static final GTToolType SAW = GTToolType.builder("saw").toolTag(CustomTags.CRAFTING_SAWS).toolTag(CustomTags.SAWS).harvestTag(CustomTags.MINEABLE_WITH_SAW).toolStats(b -> b.crafting().damagePerCraftingAction(2).attackDamage(-1.0f).attackSpeed(-2.6f).behaviors(HarvestIceBehavior.INSTANCE)).sound(GTSoundEntries.SAW_TOOL).symbol('s').materialAmount(7257600L).build();
    public static final GTToolType HARD_HAMMER = GTToolType.builder("hammer").toolTag(CustomTags.CRAFTING_HAMMERS).toolTag(CustomTags.HAMMERS).harvestTag(CustomTags.MINEABLE_WITH_HAMMER).harvestTag(BlockTags.f_144282_).toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(2).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(new EntityDamageBehavior(2.0f, IronGolem.class))).sound(GTSoundEntries.FORGE_HAMMER).symbol('h').toolClasses(PICKAXE).materialAmount(21772800L).build();
    public static final GTToolType SOFT_MALLET = GTToolType.builder("mallet").toolTag(CustomTags.CRAFTING_MALLETS).toolTag(CustomTags.MALLETS).toolStats(b -> b.crafting().cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(ToolModeSwitchBehavior.INSTANCE)).sound(GTSoundEntries.SOFT_MALLET_TOOL).symbol('r').materialAmount(21772800L).build();
    public static final GTToolType WRENCH = GTToolType.builder("wrench").toolTag(CustomTags.CRAFTING_WRENCHES).toolTag(CustomTags.WRENCHES).toolTag(CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE)).sound(GTSoundEntries.WRENCH_TOOL, true).symbol('w').materialAmount(14515200L).build();
    public static final GTToolType FILE = GTToolType.builder("file").toolTag(CustomTags.CRAFTING_FILES).toolTag(CustomTags.FILES).toolStats(b -> b.crafting().damagePerCraftingAction(4).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.FILE_TOOL).symbol('f').materialAmount(7257600L).build();
    public static final GTToolType CROWBAR = GTToolType.builder("crowbar").toolTag(CustomTags.CRAFTING_CROWBARS).toolTag(CustomTags.CROWBARS).harvestTag(CustomTags.MINEABLE_WITH_CROWBAR).toolStats(b -> b.blockBreaking().crafting().attackDamage(2.0f).attackSpeed(-2.4f).sneakBypassUse().behaviors(RotateRailBehavior.INSTANCE)).sound(new ExistingSoundEntry(SoundEvents.f_12018_, SoundSource.BLOCKS), true).symbol('c').materialAmount(5443200L).build();
    public static final GTToolType SCREWDRIVER = GTToolType.builder("screwdriver").toolTag(CustomTags.CRAFTING_SCREWDRIVERS).toolTag(CustomTags.SCREWDRIVERS).toolStats(b -> b.crafting().damagePerCraftingAction(4).sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, Spider.class))).sound(GTSoundEntries.SCREWDRIVER_TOOL).symbol('d').materialAmount(3628800L).build();
    public static final GTToolType MORTAR = GTToolType.builder("mortar").toolTag(CustomTags.CRAFTING_MORTARS).toolTag(CustomTags.MORTARS).toolStats(b -> b.crafting().damagePerCraftingAction(2).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.MORTAR_TOOL).symbol('m').materialAmount(7257600L).build();
    public static final GTToolType WIRE_CUTTER = GTToolType.builder("wire_cutter").toolTag(CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).symbol('x').materialAmount(14515200L).build();
    public static final GTToolType KNIFE = GTToolType.builder("knife").toolTag(CustomTags.CRAFTING_KNIVES).toolTag(CustomTags.KNIVES).harvestTag(CustomTags.MINEABLE_WITH_KNIFE).toolStats(b -> b.crafting().attacking().attackSpeed(3.0f)).constructor(GTSwordItem::create).symbol('k').toolClasses(SWORD).materialAmount(3628800L).build();
    public static final GTToolType BUTCHERY_KNIFE = GTToolType.builder("butchery_knife").toolTag(CustomTags.BUTCHERY_KNIVES).toolStats(b -> b.attacking().attackDamage(1.5f).attackSpeed(-1.3f).defaultEnchantment(Enchantments.f_44982_, 3)).constructor(GTSwordItem::create).materialAmount(14515200L).build();
    public static final GTToolType PLUNGER = GTToolType.builder("plunger").toolTag(CustomTags.PLUNGERS).toolStats(b -> b.cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(PlungerBehavior.INSTANCE)).sound(GTSoundEntries.PLUNGER_TOOL).build();
    public static final GTToolType SHEARS = GTToolType.builder("shears").toolTag(CustomTags.SHEARS).harvestTag(CustomTags.MINEABLE_WITH_SHEARS).toolStats(b -> b).build();
    public static final GTToolType DRILL_LV = GTToolType.builder("lv_drill").idFormat("lv_%s_drill").toolTag(CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(1).toolClassNames("drill").build();
    public static final GTToolType DRILL_MV = GTToolType.builder("mv_drill").idFormat("mv_%s_drill").toolTag(CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(1, 1, 2).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(4.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_MV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(2).toolClassNames("drill").build();
    public static final GTToolType DRILL_HV = GTToolType.builder("hv_drill").idFormat("hv_%s_drill").toolTag(CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(2, 2, 4).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(5.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(3).toolClassNames("drill").build();
    public static final GTToolType DRILL_EV = GTToolType.builder("ev_drill").idFormat("ev_%s_drill").toolTag(CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(3, 3, 6).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(6.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_EV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(4).toolClassNames("drill").build();
    public static final GTToolType DRILL_IV = GTToolType.builder("iv_drill").idFormat("iv_%s_drill").toolTag(CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(4, 4, 8).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(7.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(5).toolClassNames("drill").build();
    public static final GTToolType CHAINSAW_LV = GTToolType.builder("lv_chainsaw").idFormat("lv_%s_chainsaw").toolTag(ItemTags.f_271207_).toolTag(CustomTags.CHAINSAWS).harvestTag(BlockTags.f_144280_).harvestTag(BlockTags.f_278398_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().efficiencyMultiplier(2.0f).attackDamage(5.0f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(HarvestIceBehavior.INSTANCE, DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE)).sound(GTSoundEntries.CHAINSAW_TOOL, true).electric(1).toolClasses(AXE).build();
    public static final GTToolType WRENCH_LV = GTToolType.builder("lv_wrench").idFormat("lv_%s_wrench").toolTag(CustomTags.CRAFTING_WRENCHES).toolTag(CustomTags.WRENCHES).toolTag(CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(2.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(1).toolClasses(WRENCH).build();
    public static final GTToolType WRENCH_HV = GTToolType.builder("hv_wrench").idFormat("hv_%s_wrench").toolTag(CustomTags.CRAFTING_WRENCHES).toolTag(CustomTags.WRENCHES).toolTag(CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(3.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(3).toolClasses(WRENCH).build();
    public static final GTToolType WRENCH_IV = GTToolType.builder("iv_wrench").idFormat("iv_%s_wrench").toolTag(CustomTags.CRAFTING_WRENCHES).toolTag(CustomTags.WRENCHES).toolTag(CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(4.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(5).toolClasses(WRENCH).build();
    public static final GTToolType WIRE_CUTTER_LV = GTToolType.builder("lv_wirecutter").idFormat("lv_%s_wire_cutter").toolTag(CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(1).toolClasses(WIRE_CUTTER).build();
    public static final GTToolType WIRE_CUTTER_HV = GTToolType.builder("hv_wirecutter").idFormat("hv_%s_wire_cutter").toolTag(CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(3).toolClasses(WIRE_CUTTER).build();
    public static final GTToolType WIRE_CUTTER_IV = GTToolType.builder("iv_wirecutter").idFormat("iv_%s_wire_cutter").toolTag(CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(5).toolClasses(WIRE_CUTTER).build();
    public static final GTToolType BUZZSAW = GTToolType.builder("buzzsaw").toolTag(CustomTags.CRAFTING_SAWS).toolTag(CustomTags.SAWS).toolTag(CustomTags.BUZZSAWS).toolStats(b -> b.crafting().attackDamage(1.5f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.CHAINSAW_TOOL, true).electric(1).toolClasses(SAW).build();
    public static final GTToolType SCREWDRIVER_LV = GTToolType.builder("lv_screwdriver").idFormat("lv_%s_screwdriver").toolTag(CustomTags.CRAFTING_SCREWDRIVERS).toolTag(CustomTags.SCREWDRIVERS).toolStats(b -> b.crafting().sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, Spider.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.SCREWDRIVER_TOOL).electric(1).toolClasses(SCREWDRIVER).build();
    public final String name;
    public final String idFormat;
    public final List<TagKey<Item>> itemTags;
    public final List<TagKey<Block>> harvestTags;
    public final ResourceLocation modelLocation;
    public final Set<String> toolClassNames;
    public final Set<GTToolType> toolClasses;
    @Nullable
    public final SoundEntry soundEntry;
    public final boolean playSoundOnBlockDestroy;
    public final char symbol;
    public final long materialAmount;
    public final IGTToolDefinition toolDefinition;
    public final ToolConstructor constructor;
    public final int electricTier;

    public GTToolType(String name, String idFormat, char symbol, Set<GTToolType> toolClasses, IGTToolDefinition toolDefinition, ToolConstructor constructor, List<TagKey<Block>> harvestTags, List<TagKey<Item>> itemTags, ResourceLocation modelLocation, Set<String> toolClassNames, @Nullable SoundEntry soundEntry, boolean playSoundOnBlockDestroy, int electricTier, long materialAmount) {
        this.name = name;
        this.idFormat = idFormat;
        this.symbol = symbol;
        toolClasses.add(this);
        this.toolClasses = toolClasses;
        this.toolDefinition = toolDefinition;
        this.constructor = constructor;
        this.itemTags = itemTags;
        this.harvestTags = harvestTags;
        this.modelLocation = modelLocation;
        this.toolClassNames = toolClassNames;
        this.soundEntry = soundEntry;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        this.electricTier = electricTier;
        this.materialAmount = materialAmount;
        types.put(name, this);
    }

    public boolean is(ItemStack itemStack) {
        return ToolHelper.is(itemStack, this);
    }

    public String getUnlocalizedName() {
        return "item.gtceu.tool." + this.name;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Generated
    public static Map<String, GTToolType> getTypes() {
        return types;
    }

    @FunctionalInterface
    public static interface ToolConstructor {
        public IGTTool apply(GTToolType var1, MaterialToolTier var2, Material var3, IGTToolDefinition var4, Item.Properties var5);
    }

    public static class Builder {
        private final String name;
        private String idFormat;
        private final List<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        private final List<TagKey<Block>> harvestTags = new ArrayList<TagKey<Block>>();
        private Set<String> toolClassNames = new HashSet<String>();
        private Set<GTToolType> toolClasses = new HashSet<GTToolType>();
        private IGTToolDefinition toolStats;
        private long materialAmount;
        private int tier = -1;
        private char symbol = (char)32;
        private ToolConstructor constructor = GTToolItem::create;
        private ResourceLocation modelLocation;
        private SoundEntry sound;
        private boolean playSoundOnBlockDestroy;

        public Builder(String name) {
            this.name = name;
            this.idFormat = "%s_" + name;
            this.modelLocation = GTCEu.id("item/tools/" + name);
        }

        @SafeVarargs
        public final Builder toolTag(TagKey<Item> ... tags) {
            this.itemTags.addAll(Arrays.stream(tags).toList());
            return this;
        }

        @SafeVarargs
        public final Builder harvestTag(TagKey<Block> ... tags) {
            this.harvestTags.addAll(Arrays.stream(tags).toList());
            return this;
        }

        public Builder toolClasses(GTToolType ... classes) {
            this.toolClasses.addAll(Arrays.stream(classes).toList());
            this.toolClassNames.addAll(Arrays.stream(classes).map(type -> type.name).toList());
            return this;
        }

        public Builder toolClassNames(String ... classes) {
            this.toolClassNames.addAll(Arrays.stream(classes).toList());
            return this;
        }

        public Builder toolStats(UnaryOperator<ToolDefinitionBuilder> builder) {
            this.toolStats = ((ToolDefinitionBuilder)builder.apply(new ToolDefinitionBuilder())).build();
            return this;
        }

        public Builder sound(SoundEntry sound) {
            return this.sound(sound, false);
        }

        public Builder sound(SoundEntry sound, boolean playSoundOnBlockDestroy) {
            this.sound = sound;
            this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
            return this;
        }

        public Builder electric(int tier) {
            return this.tier(tier);
        }

        private GTToolType get() {
            return new GTToolType(this.name, this.idFormat, this.symbol, this.toolClasses, this.toolStats, this.constructor, this.harvestTags, this.itemTags, this.modelLocation, this.toolClassNames, this.sound, this.playSoundOnBlockDestroy, this.tier, this.materialAmount);
        }

        public GTToolType build() {
            if (this.toolClassNames.isEmpty()) {
                this.toolClassNames.add(this.name);
            }
            if (this.symbol == ' ') {
                return this.get();
            }
            GTToolType existing = ToolHelper.getToolFromSymbol(this.symbol);
            if (existing != null) {
                throw new IllegalArgumentException(String.format("Symbol %s has been taken by %s already!", Character.valueOf(this.symbol), existing));
            }
            GTToolType supplied = this.get();
            ToolHelper.registerToolSymbol(this.symbol, supplied);
            return supplied;
        }

        @NotNull
        @Generated
        public Builder idFormat(String idFormat) {
            this.idFormat = idFormat;
            return this;
        }

        @NotNull
        @Generated
        public Builder toolClassNames(Set<String> toolClassNames) {
            this.toolClassNames = toolClassNames;
            return this;
        }

        @NotNull
        @Generated
        public Builder toolStats(IGTToolDefinition toolStats) {
            this.toolStats = toolStats;
            return this;
        }

        @NotNull
        @Generated
        public Builder materialAmount(long materialAmount) {
            this.materialAmount = materialAmount;
            return this;
        }

        @NotNull
        @Generated
        public Builder tier(int tier) {
            this.tier = tier;
            return this;
        }

        @NotNull
        @Generated
        public Builder symbol(char symbol) {
            this.symbol = symbol;
            return this;
        }

        @NotNull
        @Generated
        public Builder constructor(ToolConstructor constructor) {
            this.constructor = constructor;
            return this;
        }

        @NotNull
        @Generated
        public Builder modelLocation(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }
    }
}

