/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.DummyMachineBlockEntity;
import com.gregtechceu.gtceu.utils.InfiniteEnergyContainer;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import it.unimi.dsi.fastutil.chars.Char2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.chars.CharSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ToolHelper {
    public static final String TOOL_TAG_KEY = "GT.Tool";
    public static final String BEHAVIOURS_TAG_KEY = "GT.Behaviours";
    public static final String MAX_CHARGE_KEY = "MaxCharge";
    public static final String CHARGE_KEY = "Charge";
    public static final String UNBREAKABLE_KEY = "Unbreakable";
    public static final String HIDE_FLAGS = "HideFlags";
    public static final String DISALLOW_CONTAINER_ITEM_KEY = "DisallowContainerItem";
    public static final String TINT_COLOR_KEY = "TintColor";
    public static final String DURABILITY_KEY = "Damage";
    public static final String MAX_DURABILITY_KEY = "MaxDamage";
    public static final String TOOL_SPEED_KEY = "ToolSpeed";
    public static final String ATTACK_DAMAGE_KEY = "AttackDamage";
    public static final String ATTACK_SPEED_KEY = "AttackSpeed";
    public static final String ENCHANTABILITY_KEY = "Enchantability";
    public static final String HARVEST_LEVEL_KEY = "HarvestLevel";
    public static final String LAST_CRAFTING_USE_KEY = "LastCraftingUse";
    public static final String MAX_AOE_COLUMN_KEY = "MaxAoEColumn";
    public static final String MAX_AOE_ROW_KEY = "MaxAoERow";
    public static final String MAX_AOE_LAYER_KEY = "MaxAoELayer";
    public static final String AOE_COLUMN_KEY = "AoEColumn";
    public static final String AOE_ROW_KEY = "AoERow";
    public static final String AOE_LAYER_KEY = "AoELayer";
    public static final String HARVEST_ICE_KEY = "HarvestIce";
    public static final String TORCH_PLACING_KEY = "TorchPlacing";
    public static final String TORCH_PLACING_CACHE_SLOT_KEY = "TorchPlacing$Slot";
    public static final String TREE_FELLING_KEY = "TreeFelling";
    public static final String DISABLE_TREE_FELLING_KEY = "DisableTreeFelling";
    public static final String DISABLE_SHIELDS_KEY = "DisableShields";
    public static final String RELOCATE_MINED_BLOCKS_KEY = "RelocateMinedBlocks";
    public static final String RELOCATE_MOB_DROPS_KEY = "RelocateMobDrops";
    private static final Char2ReferenceMap<GTToolType> symbols = new Char2ReferenceOpenHashMap();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_LV = () -> ((ComponentItem)GTItems.POWER_UNIT_LV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_MV = () -> ((ComponentItem)GTItems.POWER_UNIT_MV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_HV = () -> ((ComponentItem)GTItems.POWER_UNIT_HV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_EV = () -> ((ComponentItem)GTItems.POWER_UNIT_EV.get()).m_7968_();
    public static final Supplier<ItemStack> SUPPLY_POWER_UNIT_IV = () -> ((ComponentItem)GTItems.POWER_UNIT_IV.get()).m_7968_();

    private ToolHelper() {
    }

    public static GTToolType getToolFromSymbol(char symbol) {
        return (GTToolType)symbols.get(symbol);
    }

    public static @UnmodifiableView CharSet getToolSymbols() {
        return CharSets.unmodifiable((CharSet)symbols.keySet());
    }

    public static void registerToolSymbol(char symbol, GTToolType tool) {
        symbols.put(symbol, (Object)tool);
    }

    public static CompoundTag getToolTag(ItemStack stack) {
        return stack.m_41698_(TOOL_TAG_KEY);
    }

    public static CompoundTag getBehaviorsTag(ItemStack stack) {
        return stack.m_41698_(BEHAVIOURS_TAG_KEY);
    }

    public static boolean hasBehaviorsTag(ItemStack stack) {
        return stack.m_41737_(BEHAVIOURS_TAG_KEY) != null;
    }

    public static ItemStack get(GTToolType toolType, Material material) {
        ItemProviderEntry entry;
        if (material.hasProperty(PropertyKey.TOOL) && (entry = (ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType)) != null) {
            return ((IGTTool)entry.get()).get();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getArmor(ArmorItem.Type armorType, Material material) {
        ItemEntry entry;
        if (material.hasProperty(PropertyKey.ARMOR) && (entry = (ItemEntry)GTMaterialItems.ARMOR_ITEMS.get((Object)material, (Object)armorType)) != null) {
            return ((ArmorItem)entry.get()).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public static boolean is(ItemStack stack, GTToolType toolType) {
        return ToolHelper.getToolTypes(stack).contains(toolType);
    }

    public static boolean canUse(ItemStack stack) {
        return stack.m_41773_() <= stack.m_41776_();
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable LivingEntity user, int damage) {
        Item item = stack.m_41720_();
        if (!(item instanceof IGTTool)) {
            if (user != null) {
                stack.m_41622_(damage, user, p -> {});
            }
        } else {
            Player player;
            IGTTool tool = (IGTTool)item;
            if (stack.m_41783_() != null && stack.m_41783_().m_128471_(UNBREAKABLE_KEY)) {
                return;
            }
            if (!(user instanceof Player) || !(player = (Player)user).m_7500_()) {
                RandomSource random;
                RandomSource randomSource = random = user == null ? GTValues.RNG : user.m_217043_();
                if (tool.isElectric()) {
                    int electricDamage = damage * ConfigHolder.INSTANCE.machines.energyUsageMultiplier;
                    IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
                    if (electricItem != null) {
                        electricItem.discharge(electricDamage, tool.getElectricTier(), true, false, false);
                        if (electricItem.getCharge() > 0L && random.m_188503_(100) >= ConfigHolder.INSTANCE.tools.rngDamageElectricTools) {
                            return;
                        }
                    } else {
                        throw new IllegalStateException("Electric tool does not have an attached electric item capability.");
                    }
                }
                int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
                int negated = 0;
                for (int k = 0; unbreakingLevel > 0 && k < damage; ++k) {
                    if (!DigDurabilityEnchantment.m_220282_((ItemStack)stack, (int)unbreakingLevel, (RandomSource)random)) continue;
                    ++negated;
                }
                if ((damage -= negated) <= 0) {
                    return;
                }
                int newDurability = stack.m_41773_() + damage;
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    CriteriaTriggers.f_10586_.m_43669_(serverPlayer, stack, newDurability);
                }
                stack.m_41721_(newDurability);
                if (newDurability > stack.m_41776_()) {
                    if (user instanceof Player) {
                        Player player2 = (Player)user;
                        Stat stat = Stats.f_12983_.m_12902_((Object)stack.m_41720_());
                        player2.m_36246_(stat);
                    }
                    if (user != null) {
                        user.m_21278_(stack);
                    }
                    stack.m_41774_(1);
                }
            }
        }
    }

    public static void playToolSound(GTToolType toolType, ServerPlayer player) {
        if (toolType != null && toolType.soundEntry != null) {
            toolType.soundEntry.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_());
        }
    }

    public static ItemStack getAndSetToolData(GTToolType toolType, Material material, int maxDurability, int harvestLevel, float toolSpeed, float attackDamage) {
        ItemProviderEntry tool = (ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)material, (Object)toolType);
        if (tool == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((IGTTool)tool.get()).getRaw();
        stack.m_41784_().m_128405_(HIDE_FLAGS, 2);
        CompoundTag toolTag = ToolHelper.getToolTag(stack);
        toolTag.m_128405_(MAX_DURABILITY_KEY, maxDurability);
        toolTag.m_128405_(HARVEST_LEVEL_KEY, harvestLevel);
        toolTag.m_128350_(TOOL_SPEED_KEY, toolSpeed);
        toolTag.m_128350_(ATTACK_DAMAGE_KEY, attackDamage);
        ToolProperty toolProperty = material.getProperty(PropertyKey.TOOL);
        if (toolProperty != null) {
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(toolProperty.getEnchantments())) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (!((IGTTool)tool.get()).definition$canApplyAtEnchantingTable(stack, enchantment)) continue;
                stack.m_41663_(enchantment, entry.getIntValue());
            }
        }
        return stack;
    }

    public static boolean areaOfEffectBlockBreakRoutine(ItemStack stack, ServerPlayer player, BlockPos targeted) {
        int currentDurability = stack.m_41773_();
        int maximumDurability = stack.m_41776_();
        int remainingUses = maximumDurability - currentDurability;
        List<BlockPos> harvestableBlocks = ToolHelper.getHarvestableBlocks(stack, (Player)player);
        if (!harvestableBlocks.isEmpty()) {
            for (BlockPos pos : harvestableBlocks) {
                IGTTool gtTool;
                if (!ToolHelper.breakBlockRoutine(player, stack, pos, pos == targeted)) {
                    return true;
                }
                Item item = stack.m_41720_();
                if (item instanceof IGTTool && !(gtTool = (IGTTool)item).isElectric() && --remainingUses == 0) {
                    return true;
                }
                if (ItemStack.m_41656_((ItemStack)player.m_21205_(), (ItemStack)stack)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static AoESymmetrical getMaxAoEDefinition(ItemStack stack) {
        return AoESymmetrical.readMax(ToolHelper.getBehaviorsTag(stack));
    }

    public static AoESymmetrical getAoEDefinition(ItemStack stack) {
        return AoESymmetrical.read(ToolHelper.getBehaviorsTag(stack), ToolHelper.getMaxAoEDefinition(stack));
    }

    public static List<BlockPos> iterateAoE(AoESymmetrical aoeDefinition, Predicate<UseOnContext> predicate, UseOnContext context) {
        int aoeRowEnd;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        Direction hitFace = context.m_43719_();
        ItemStack stack = context.m_43722_();
        Direction playerFacing = player != null ? player.m_6350_() : Direction.NORTH;
        Direction depthDirection = hitFace.m_122424_();
        Direction topDirection = Direction.UP;
        Direction sideDirection = hitFace;
        int aoeRowStart = aoeDefinition.row == 0 ? 0 : -1;
        int n = aoeRowEnd = aoeDefinition.row == 0 ? 0 : aoeDefinition.row * 2 - 1;
        if (hitFace.m_122434_().m_122478_()) {
            topDirection = playerFacing;
            sideDirection = playerFacing;
            aoeRowStart = -aoeDefinition.row;
            aoeRowEnd = aoeDefinition.row;
        }
        sideDirection = sideDirection.m_122427_();
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int depth = 0; depth <= aoeDefinition.layer; ++depth) {
            for (int top = aoeRowEnd; top >= aoeRowStart; --top) {
                for (int side = -aoeDefinition.column; side <= aoeDefinition.column; ++side) {
                    UseOnContext posContext;
                    BlockPos pos = context.m_8083_().m_5484_(depthDirection, depth).m_5484_(topDirection, top).m_5484_(sideDirection, side);
                    if (player != null && !player.m_36204_(pos.m_121945_(hitFace), hitFace, stack) || !predicate.test(posContext = new UseOnContext(level, player, context.m_43724_(), stack, context.m_43718_().m_82430_(pos)))) continue;
                    validPositions.add(pos);
                }
            }
        }
        return validPositions;
    }

    public static List<BlockPos> getHarvestableBlocks(AoESymmetrical aoeDefinition, UseOnContext context) {
        return ToolHelper.iterateAoE(aoeDefinition, ToolHelper::isBlockAoEHarvestable, context);
    }

    private static boolean isBlockAoEHarvestable(UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        if (level.m_8055_(pos).m_60795_()) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof LiquidBlock) {
            return false;
        }
        BlockPos hitBlockPos = context.m_8083_();
        BlockState hitBlockState = level.m_8055_(hitBlockPos);
        if (state.m_60800_((BlockGetter)level, pos) < 0.0f || state.m_60800_((BlockGetter)level, pos) - hitBlockState.m_60800_((BlockGetter)level, hitBlockPos) > 8.0f) {
            return false;
        }
        return stack.m_41720_().isCorrectToolForDrops(stack, state);
    }

    public static void applyHammerDropConversion(ServerLevel world, BlockPos pos, ItemStack tool, BlockState state, List<ItemStack> drops, int fortune, float dropChance, RandomSource random) {
        if (ToolHelper.is(tool, GTToolType.HARD_HAMMER)) {
            List<ItemStack> silktouchDrops = ToolHelper.getSilkTouchDrop(world, pos, state);
            for (ItemStack silktouchDrop : silktouchDrops) {
                if (silktouchDrop.m_41619_()) continue;
                DummyMachineBlockEntity be = new DummyMachineBlockEntity(1, GTRecipeTypes.FORGE_HAMMER_RECIPES, GTMachineUtils.defaultTankSizeFunction, Collections.emptyList(), new Object[0]);
                RecipeHandlerList dummyInputs = RecipeHandlerList.of(IO.IN, new InfiniteEnergyContainer(be.getMetaMachine(), GTValues.V[1], GTValues.V[1], 1L, GTValues.V[1], 1L), new NotifiableItemStackHandler(be.getMetaMachine(), 1, IO.IN, IO.IN, slots -> new CustomItemStackHandler(silktouchDrop)));
                RecipeHandlerList dummyOutputs = RecipeHandlerList.of(IO.OUT, new NotifiableItemStackHandler(be.getMetaMachine(), 2, IO.OUT));
                be.getMetaMachine().reinitializeHandlers(List.of(dummyInputs, dummyOutputs));
                Iterator<GTRecipe> hammerRecipes = GTRecipeTypes.FORGE_HAMMER_RECIPES.searchRecipe(be.metaMachine, r -> RecipeHelper.matchContents(be.metaMachine, r).isSuccess());
                GTRecipe hammerRecipe = !hammerRecipes.hasNext() ? null : hammerRecipes.next();
                if (hammerRecipe == null || !RecipeHelper.handleRecipeIO(be.metaMachine, hammerRecipe, IO.IN, be.getMetaMachine().recipeLogic.getChanceCaches()).isSuccess()) continue;
                drops.clear();
                TagPrefix prefix = ChemicalHelper.getPrefix((ItemLike)silktouchDrop.m_41720_());
                if (prefix.isEmpty()) {
                    for (Content output : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                        if (!(dropChance >= 1.0f) && !(random.m_188501_() <= dropChance)) continue;
                        drops.add(SizedIngredient.copy((Ingredient)ItemRecipeCapability.CAP.of(output.content)).m_43908_()[0]);
                    }
                    continue;
                }
                if (!TagPrefix.ORES.containsKey(prefix)) continue;
                for (Content content : hammerRecipe.getOutputContents(ItemRecipeCapability.CAP)) {
                    ItemStack output;
                    if (!(dropChance >= 1.0f) && !(random.m_188501_() <= dropChance) || ChemicalHelper.getPrefix((ItemLike)(output = ((Ingredient)ItemRecipeCapability.CAP.of(content.content)).m_43908_()[0]).m_41720_()) != TagPrefix.crushed) continue;
                    output = output.m_41777_();
                    if (fortune > 0) {
                        output.m_41769_(random.m_188503_(fortune));
                    }
                    drops.add(output);
                }
            }
        }
    }

    public static boolean breakBlockRoutine(ServerPlayer player, ItemStack tool, BlockPos pos, boolean playSound) {
        boolean successful;
        if (ToolHelper.isTool(tool, GTToolType.SHEARS) && ToolHelper.shearBlockRoutine(player, tool, pos) == 0) {
            return false;
        }
        Level world = player.m_9236_();
        boolean canBreak = ToolHelper.onBlockBreakEvent(world, player.f_8941_.m_9290_(), player, pos);
        if (!canBreak) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity tile = world.m_7702_(pos);
        if (block instanceof GameMasterBlock && !player.m_36337_()) {
            world.m_7260_(pos, state, state, 3);
            return false;
        }
        if (player.m_36187_(world, pos, player.f_8941_.m_9290_())) {
            return false;
        }
        if (player.m_7500_()) {
            return ToolHelper.removeBlockRoutine(state, world, player, pos, playSound);
        }
        world.m_5898_((Player)player, 2001, pos, Block.m_49956_((BlockState)state));
        ItemStack copiedTool = tool.m_41777_();
        boolean canHarvest = player.m_36298_(state);
        if (!tool.m_41619_()) {
            tool.m_41686_(world, state, pos, (Player)player);
            if (tool.m_41619_() && !copiedTool.m_41619_()) {
                ToolHelper.onPlayerDestroyItem((Player)player, copiedTool, InteractionHand.MAIN_HAND);
            }
        }
        if ((successful = ToolHelper.removeBlockRoutine(null, world, player, pos, playSound)) && canHarvest) {
            block.m_6240_(world, (Player)player, pos, state, tile, copiedTool);
        }
        return successful;
    }

    public static boolean onBlockBreakEvent(Level level, GameType gameType, ServerPlayer player, BlockPos pos) {
        return ForgeHooks.onBlockBreakEvent((Level)level, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos) != -1;
    }

    public static void onPlayerDestroyItem(Player player, ItemStack stack, InteractionHand hand) {
        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
    }

    public static double getPlayerBlockReach(@NotNull Player player) {
        return player.getBlockReach();
    }

    public static boolean isCorrectTierForDrops(BlockState state, int tier) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)ToolHelper.getTier(tier), (BlockState)state);
    }

    private static Tier getTier(int harvestLevel) {
        List<Tier> tiers = TierSortingRegistry.getSortedTiers().stream().filter(tier -> tier.m_6604_() == harvestLevel).toList();
        return !tiers.isEmpty() ? tiers.get(tiers.size() - 1) : Tiers.WOOD;
    }

    public static boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return itemstack.onBlockStartBreak(pos, player);
    }

    public static boolean removeBlockRoutine(@Nullable BlockState state, Level world, ServerPlayer player, BlockPos pos, boolean playSound) {
        state = state == null ? world.m_8055_(pos) : state;
        state.m_60734_().m_5707_(world, pos, state, (Player)player);
        boolean successful = world.m_7471_(pos, false);
        if (playSound) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        if (successful) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return successful;
    }

    public static List<BlockPos> getHarvestableBlocks(ItemStack stack, Player player) {
        if (!ToolHelper.hasBehaviorsTag(stack)) {
            return List.of();
        }
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition.isZero()) {
            return List.of();
        }
        BlockHitResult hitResult = ToolHelper.getPlayerDefaultRaytrace(player);
        UseOnContext context = new UseOnContext(player, player.m_7655_(), hitResult);
        return ToolHelper.getHarvestableBlocks(aoeDefinition, context);
    }

    public static BlockHitResult getPlayerDefaultRaytrace(@NotNull Player player) {
        return ToolHelper.entityPickBlock((Entity)player, ToolHelper.getPlayerBlockReach(player), 1.0f, false);
    }

    public static BlockHitResult entityPickBlock(Entity entity, double hitDistance, float partialTicks, boolean hitFluids) {
        Vec3 eyePos = entity.m_20299_(partialTicks);
        Vec3 lookVec = entity.m_20252_(partialTicks);
        Vec3 maxDistance = eyePos.m_82520_(lookVec.f_82479_ * hitDistance, lookVec.f_82480_ * hitDistance, lookVec.f_82481_ * hitDistance);
        ClipContext context = new ClipContext(eyePos, maxDistance, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity);
        return entity.m_9236_().m_45547_(context);
    }

    public static void onActionDone(@Nullable Player player, @NotNull ItemStack stack, @NotNull Level level, @NotNull Vec3 pos) {
        IGTTool tool = (IGTTool)stack.m_41720_();
        ToolHelper.damageItem(stack, (LivingEntity)player);
        if (tool.getSound() != null) {
            level.m_6263_(player, pos.f_82479_, pos.f_82480_, pos.f_82481_, tool.getSound().getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @NotNull
    public static Set<GTToolType> getToolTypes(ItemStack tool) {
        HashSet<GTToolType> types = new HashSet<GTToolType>();
        Item item = tool.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            return gtTool.getToolClasses(tool);
        }
        for (GTToolType toolType : GTToolType.getTypes().values()) {
            if (!toolType.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).m_204117_(arg_0))) continue;
            types.add(toolType);
        }
        return types;
    }

    public static boolean isTool(ItemStack tool, GTToolType ... toolClasses) {
        for (GTToolType toolType : toolClasses) {
            if (!toolType.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)tool).m_204117_(arg_0))) continue;
            return true;
        }
        Item item = tool.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool igtTool = (IGTTool)item;
            if (toolClasses.length == 1) {
                return igtTool.getToolClasses(tool).contains(toolClasses[0]);
            }
            for (GTToolType toolClass : igtTool.getToolClasses(tool)) {
                for (GTToolType specified : toolClasses) {
                    if (!toolClass.equals(specified)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isToolEffective(BlockState state, Set<GTToolType> toolClasses, int harvestLevel) {
        if (toolClasses.stream().anyMatch(type -> type.harvestTags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0)))) {
            return ToolHelper.isCorrectTierForDrops(state, harvestLevel);
        }
        return false;
    }

    public static void damageItemWhenCrafting(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        int damage = 2;
        if (stack.m_41720_() instanceof IGTTool) {
            damage = ((IGTTool)stack.m_41720_()).getToolStats().getToolDamagePerCraft(stack);
        } else if (stack.m_204131_().anyMatch(s -> s.f_203868_().m_135815_().startsWith("tool") || s.f_203868_().m_135815_().startsWith("crafting_tool"))) {
            damage = 1;
        }
        ToolHelper.damageItem(stack, entity, damage);
    }

    public static void damageItem(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        ToolHelper.damageItem(stack, entity, 1);
    }

    public static float getDestroySpeed(BlockState state, Set<GTToolType> toolClasses) {
        Block block;
        if (toolClasses.contains(GTToolType.SWORD) && (block = state.m_60734_()) instanceof WebBlock) {
            return 15.0f;
        }
        return -1.0f;
    }

    public static int shearBlockRoutine(ServerPlayer player, ItemStack tool, BlockPos pos) {
        IForgeShearable shearable;
        ServerLevel world;
        BlockState state;
        Block block;
        if (!player.m_7500_() && (block = (state = (world = player.m_284548_()).m_8055_(pos)).m_60734_()) instanceof IForgeShearable && (shearable = (IForgeShearable)block).isShearable(tool, (Level)world, pos)) {
            List shearedDrops = shearable.onSheared((Player)player, tool, (Level)world, pos, tool.getEnchantmentLevel(Enchantments.f_44987_));
            boolean relocateMinedBlocks = ToolHelper.hasBehaviorsTag(tool) && ToolHelper.getBehaviorsTag(tool).m_128471_(RELOCATE_MINED_BLOCKS_KEY);
            Iterator iter = shearedDrops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (relocateMinedBlocks && player.m_36356_(stack)) {
                    iter.remove();
                    continue;
                }
                float f = 0.7f;
                double xo = (double)(world.f_46441_.m_188501_() * f) + 0.15;
                double yo = (double)(world.f_46441_.m_188501_() * f) + 0.15;
                double zo = (double)(world.f_46441_.m_188501_() * f) + 0.15;
                ItemEntity entityItem = new ItemEntity((Level)world, (double)pos.m_123341_() + xo, (double)pos.m_123342_() + yo, (double)pos.m_123343_() + zo, stack);
                entityItem.m_32060_();
                world.m_7967_((Entity)entityItem);
            }
            ToolHelper.damageItem(tool, (LivingEntity)player, 1);
            player.m_36246_(Stats.f_12949_.m_12902_((Object)((Block)shearable)));
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return tool.m_41619_() ? 0 : 1;
        }
        return -1;
    }

    @NotNull
    public static List<ItemStack> getSilkTouchDrop(ServerLevel world, BlockPos origin, @NotNull BlockState state) {
        ItemStack tool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, (Object)GTToolType.PICKAXE)).get()).get();
        tool.m_41663_(Enchantments.f_44985_, 1);
        return state.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)origin)).m_287286_(LootContextParams.f_81463_, (Object)tool));
    }
}

