/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public interface IExhaustVentMachine
extends IMachineFeature {
    public static final EnumProperty<RelativeDirection> VENT_DIRECTION_PROPERTY = GTMachineModelProperties.VENT_DIRECTION;

    @NotNull
    public Direction getVentingDirection();

    public boolean isNeedsVenting();

    public void setNeedsVenting(boolean var1);

    public void markVentingComplete();

    public float getVentingDamage();

    default public boolean checkVenting() {
        if (this.isNeedsVenting()) {
            this.tryDoVenting(this.self().getLevel(), this.self().getPos());
        }
        return !this.isNeedsVenting();
    }

    default public boolean isVentingBlocked() {
        Level level = this.self().getLevel();
        Direction ventingSide = this.getVentingDirection();
        BlockPos ventingBlockPos = this.self().getPos().m_121945_(ventingSide);
        BlockState state = level.m_8055_(ventingBlockPos);
        return state.m_60815_() || Shapes.m_83117_((VoxelShape)state.m_60812_((BlockGetter)level, ventingBlockPos), (VoxelShape)Shapes.m_83144_(), (Direction)ventingSide.m_122424_());
    }

    default public void tryDoVenting(@NotNull Level level, @NotNull BlockPos pos) {
        if (!this.isNeedsVenting()) {
            return;
        }
        if (!this.isVentingBlocked()) {
            this.performVenting(level, pos);
            return;
        }
        BlockPos ventingPos = pos.m_121945_(this.getVentingDirection());
        if (GTUtil.tryBreakSnow(level, ventingPos, level.m_8055_(ventingPos), false)) {
            this.performVenting(level, pos);
        }
    }

    private void performVenting(@NotNull Level level, @NotNull BlockPos pos) {
        this.doVentingDamage(level, pos);
        Direction ventingDirection = this.getVentingDirection();
        double posX = (double)pos.m_123341_() + 0.5 + (double)ventingDirection.m_122429_() * 0.6;
        double posY = (double)pos.m_123342_() + 0.5 + (double)ventingDirection.m_122430_() * 0.6;
        double posZ = (double)pos.m_123343_() + 0.5 + (double)ventingDirection.m_122431_() * 0.6;
        this.createVentingParticles(level, posX, posY, posZ);
        if (ConfigHolder.INSTANCE.machines.machineSounds) {
            this.playVentingSound(level, posX, posY, posZ);
        }
        this.markVentingComplete();
    }

    default public void doVentingDamage(@NotNull Level level, @NotNull BlockPos pos) {
        for (LivingEntity entity2 : level.m_6443_(LivingEntity.class, new AABB(pos.m_121945_(this.getVentingDirection())), entity -> {
            Player player;
            return !(entity instanceof Player) || !(player = (Player)entity).m_5833_() && !player.m_7500_();
        })) {
            entity2.m_6469_(GTDamageTypes.HEAT.source((LevelAccessor)level), this.getVentingDamage());
        }
    }

    default public void createVentingParticles(@NotNull Level level, double posX, double posY, double posZ) {
        Direction ventingDirection = this.getVentingDirection();
        int count = 7 + level.f_46441_.m_188503_(3);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, posX, posY, posZ, count, (double)ventingDirection.m_122429_() / 2.0, (double)ventingDirection.m_122430_() / 2.0, (double)ventingDirection.m_122431_() / 2.0, 0.1);
        } else {
            for (int i = 0; i < count; ++i) {
                double d1 = level.f_46441_.m_188583_() * (double)ventingDirection.m_122429_() / 2.0;
                double d3 = level.f_46441_.m_188583_() * (double)ventingDirection.m_122430_() / 2.0;
                double d5 = level.f_46441_.m_188583_() * (double)ventingDirection.m_122431_() / 2.0;
                double d6 = level.f_46441_.m_188583_() * 0.1;
                double d7 = level.f_46441_.m_188583_() * 0.1;
                double d8 = level.f_46441_.m_188583_() * 0.1;
                try {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, posX + d1, posY + d3, posZ + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    GTCEu.LOGGER.warn("Could not spawn particle effect {}", (Object)ParticleTypes.f_123796_);
                    return;
                }
            }
        }
    }

    default public void playVentingSound(@NotNull Level level, double posX, double posY, double posZ) {
        level.m_6263_(null, posX, posY, posZ, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

