/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.placeholder;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.Placeholder;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.exceptions.PlaceholderException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.UnclosedBracketException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.UnexpectedBracketException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.UnknownPlaceholderException;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PlaceholderHandler {
    private static final char ARG_SEPARATOR = ' ';
    private static final char PLACEHOLDER_BEGIN = '{';
    private static final char PLACEHOLDER_END = '}';
    private static final char ESCAPE = '\\';
    private static final char LITERAL_ESCAPE = '\"';
    private static final char NEWLINE = '\n';
    private static final char ESCAPED_NEWLINE = 'n';
    private static final Map<String, Placeholder> placeholders = new HashMap<String, Placeholder>();

    public static void addPlaceholder(Placeholder placeholder) {
        if (placeholders.containsKey(placeholder.getName())) {
            if (placeholders.get(placeholder.getName()).getPriority() <= placeholder.getPriority()) {
                placeholders.put(placeholder.getName(), placeholder);
            }
        } else {
            placeholders.put(placeholder.getName(), placeholder);
        }
    }

    public static boolean placeholderExists(MultiLineComponent placeholder) {
        return placeholders.containsKey(placeholder.toString());
    }

    public static MultiLineComponent processPlaceholder(List<MultiLineComponent> placeholder, PlaceholderContext context) throws PlaceholderException {
        if (!PlaceholderHandler.placeholderExists(placeholder.get(0))) {
            throw new UnknownPlaceholderException(placeholder.get(0).toString());
        }
        return placeholders.get(placeholder.get(0).toString()).apply(context, placeholder.subList(1, placeholder.size()));
    }

    public static MultiLineComponent processPlaceholders(String s, PlaceholderContext ctx) {
        if (ctx.level().f_46443_) {
            GTCEu.LOGGER.warn("Placeholder processing is running on client instead of server!");
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        boolean escape = false;
        boolean escapeNext = false;
        boolean literalEscape = false;
        int line = 1;
        int symbol = 1;
        Stack<ArrayList<MultiLineComponent>> stack = new Stack<ArrayList<MultiLineComponent>>();
        stack.push(GTUtil.list(MultiLineComponent.empty()));
        for (char c : s.toCharArray()) {
            if (escape || literalEscape && c != '\"') {
                if (c == 'n' && !literalEscape) {
                    ((MultiLineComponent)GTUtil.getLast((List)stack.peek())).appendNewline();
                    ++line;
                    symbol = 0;
                } else {
                    if (c == '\n') continue;
                    ((MultiLineComponent)GTUtil.getLast((List)stack.peek())).append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        escapeNext = true;
                        break;
                    }
                    case '\"': {
                        literalEscape = !literalEscape;
                        break;
                    }
                    case '\n': {
                        ((MultiLineComponent)GTUtil.getLast((List)stack.peek())).appendNewline();
                        ++line;
                        symbol = 0;
                        break;
                    }
                    case ' ': {
                        if (stack.size() == 1) {
                            ((MultiLineComponent)GTUtil.getLast((List)stack.peek())).append(c);
                            break;
                        }
                        ((List)stack.peek()).add(MultiLineComponent.empty());
                        break;
                    }
                    case '{': {
                        stack.push(GTUtil.list(MultiLineComponent.empty()));
                        break;
                    }
                    case '}': {
                        List placeholder = (List)stack.pop();
                        try {
                            if (stack.isEmpty()) {
                                throw new UnexpectedBracketException();
                            }
                            MultiLineComponent result = PlaceholderHandler.processPlaceholder(placeholder, ctx);
                            ((MultiLineComponent)GTUtil.getLast((List)stack.peek())).append(result);
                        }
                        catch (PlaceholderException e) {
                            e.setLineInfo(line, symbol);
                            exceptions.add(e);
                        }
                        catch (RuntimeException e) {
                            exceptions.add(e);
                        }
                        break;
                    }
                    default: {
                        ((MultiLineComponent)GTUtil.getLast((List)stack.peek())).append(c);
                    }
                }
            }
            escape = escapeNext;
            escapeNext = false;
            ++symbol;
        }
        if (stack.size() > 1) {
            UnclosedBracketException exception2 = new UnclosedBracketException();
            exception2.setLineInfo(line, symbol);
            exceptions.add(exception2);
        }
        if (exceptions.isEmpty()) {
            return ((List)stack.peek()).stream().reduce(MultiLineComponent.empty(), MultiLineComponent::append);
        }
        MultiLineComponent out = MultiLineComponent.empty();
        exceptions.forEach(exception -> {
            out.append(exception.getMessage());
            out.appendNewline();
        });
        return out.withStyle(ChatFormatting.DARK_RED);
    }

    public static Set<String> getAllPlaceholderNames() {
        return placeholders.keySet();
    }

    public static Widget getPlaceholderHandlerUI(String filter) {
        DraggableScrollableWidgetGroup placeholderReference = new DraggableScrollableWidgetGroup(280, 15, 100, 200);
        Consumer<String> onSearch = newSearch -> {
            placeholderReference.clearAllWidgets();
            int y = 2;
            ArrayList<String> placeholders = new ArrayList<String>(PlaceholderHandler.getAllPlaceholderNames());
            placeholders.removeIf(s -> s == null || !s.contains((CharSequence)newSearch));
            placeholders.sort(String::compareTo);
            for (String placeholder : placeholders) {
                TextTextureWidget placeholderName = new TextTextureWidget(0, y, 80, 15, placeholder);
                placeholderName.getTextTexture().type = TextTexture.TextType.LEFT;
                placeholderName.setHoverTooltips(GTStringUtils.toImmutable(LangHandler.getSingleOrMultiLang("gtceu.placeholder_info." + placeholder)));
                placeholderReference.addWidget((Widget)placeholderName);
                y += 15;
            }
        };
        onSearch.accept(filter);
        TextTextureWidget placeholderReferenceLabel = new TextTextureWidget(280, 0, 160, 15, GTStringUtils.componentsToString(LangHandler.getMultiLang("gtceu.gui.computer_monitor_cover.placeholder_reference")));
        placeholderReferenceLabel.getTextTexture().type = TextTexture.TextType.LEFT;
        WidgetGroup out = new WidgetGroup();
        out.addWidget((Widget)placeholderReferenceLabel);
        out.addWidget((Widget)placeholderReference);
        return out;
    }
}

