/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTRecipe
implements Recipe<Container> {
    public final GTRecipeType recipeType;
    public ResourceLocation id;
    public final Map<RecipeCapability<?>, List<Content>> inputs;
    public final Map<RecipeCapability<?>, List<Content>> outputs;
    public final Map<RecipeCapability<?>, List<Content>> tickInputs;
    public final Map<RecipeCapability<?>, List<Content>> tickOutputs;
    public final Map<RecipeCapability<?>, ChanceLogic> inputChanceLogics;
    public final Map<RecipeCapability<?>, ChanceLogic> outputChanceLogics;
    public final Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogics;
    public final Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogics;
    public final List<RecipeCondition> conditions;
    public final List<?> ingredientActions;
    @NotNull
    public CompoundTag data;
    public int duration;
    public int parallels = 1;
    public int batchParallels = 1;
    public int ocLevel = 0;
    public final GTRecipeCategory recipeCategory;
    @NotNull
    private final AtomicReference<Object> inputEUt = new AtomicReference();
    @NotNull
    private final AtomicReference<Object> outputEUt = new AtomicReference();

    public GTRecipe(GTRecipeType recipeType, Map<RecipeCapability<?>, List<Content>> inputs, Map<RecipeCapability<?>, List<Content>> outputs, Map<RecipeCapability<?>, List<Content>> tickInputs, Map<RecipeCapability<?>, List<Content>> tickOutputs, Map<RecipeCapability<?>, ChanceLogic> inputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> outputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogics, List<RecipeCondition> conditions, List<?> ingredientActions, @NotNull CompoundTag data, int duration, @NotNull GTRecipeCategory recipeCategory) {
        this(recipeType, null, inputs, outputs, tickInputs, tickOutputs, inputChanceLogics, outputChanceLogics, tickInputChanceLogics, tickOutputChanceLogics, conditions, ingredientActions, data, duration, recipeCategory);
    }

    public GTRecipe(GTRecipeType recipeType, @Nullable ResourceLocation id, Map<RecipeCapability<?>, List<Content>> inputs, Map<RecipeCapability<?>, List<Content>> outputs, Map<RecipeCapability<?>, List<Content>> tickInputs, Map<RecipeCapability<?>, List<Content>> tickOutputs, Map<RecipeCapability<?>, ChanceLogic> inputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> outputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogics, Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogics, List<RecipeCondition> conditions, List<?> ingredientActions, @NotNull CompoundTag data, int duration, @NotNull GTRecipeCategory recipeCategory) {
        this.recipeType = recipeType;
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
        this.tickInputs = tickInputs;
        this.tickOutputs = tickOutputs;
        this.inputChanceLogics = inputChanceLogics;
        this.outputChanceLogics = outputChanceLogics;
        this.tickInputChanceLogics = tickInputChanceLogics;
        this.tickOutputChanceLogics = tickOutputChanceLogics;
        this.conditions = conditions;
        this.ingredientActions = ingredientActions;
        this.data = data;
        this.duration = duration;
        this.recipeCategory = recipeCategory != GTRecipeCategory.DEFAULT ? recipeCategory : recipeType.getCategory();
    }

    public GTRecipe copy() {
        return this.copy(ContentModifier.IDENTITY, false);
    }

    public GTRecipe copy(ContentModifier modifier) {
        return this.copy(modifier, true);
    }

    public GTRecipe copy(ContentModifier modifier, boolean modifyDuration) {
        GTRecipe copied = new GTRecipe(this.recipeType, this.id, modifier.applyContents(this.inputs), modifier.applyContents(this.outputs), modifier.applyContents(this.tickInputs), modifier.applyContents(this.tickOutputs), new HashMap(this.inputChanceLogics), new HashMap(this.outputChanceLogics), new HashMap(this.tickInputChanceLogics), new HashMap(this.tickOutputChanceLogics), new ArrayList<RecipeCondition>(this.conditions), new ArrayList(this.ingredientActions), this.data, this.duration, this.recipeCategory);
        if (modifyDuration) {
            copied.duration = modifier.apply(this.duration);
        }
        copied.ocLevel = this.ocLevel;
        copied.parallels = this.parallels;
        copied.batchParallels = this.batchParallels;
        return copied;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return GTRecipeSerializer.SERIALIZER;
    }

    @NotNull
    public GTRecipeType getType() {
        return this.recipeType;
    }

    public boolean m_5818_(@NotNull Container pContainer, @NotNull Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public List<Content> getInputContents(RecipeCapability<?> capability) {
        return this.inputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getOutputContents(RecipeCapability<?> capability) {
        return this.outputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getTickInputContents(RecipeCapability<?> capability) {
        return this.tickInputs.getOrDefault(capability, Collections.emptyList());
    }

    public List<Content> getTickOutputContents(RecipeCapability<?> capability) {
        return this.tickOutputs.getOrDefault(capability, Collections.emptyList());
    }

    public boolean hasTick() {
        return !this.tickInputs.isEmpty() || !this.tickOutputs.isEmpty();
    }

    public ChanceLogic getChanceLogicForCapability(RecipeCapability<?> cap, IO io, boolean isTick) {
        if (io == IO.OUT) {
            if (isTick) {
                return this.tickOutputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
            }
            return this.outputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
        }
        if (io == IO.IN) {
            if (isTick) {
                return this.tickInputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
            }
            return this.inputChanceLogics.getOrDefault(cap, ChanceLogic.OR);
        }
        return ChanceLogic.OR;
    }

    @NotNull
    protected EnergyStack calculateEUt(Map<RecipeCapability<?>, List<Content>> contents) {
        List<Content> outputs = contents.get(EURecipeCapability.CAP);
        if (outputs == null) {
            return EnergyStack.EMPTY;
        }
        long v = 0L;
        long a = 0L;
        for (Content content : outputs) {
            EnergyStack stack = (EnergyStack)EURecipeCapability.CAP.of(content.content);
            v += stack.voltage();
            a += stack.amperage();
        }
        return new EnergyStack(v, a);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GTRecipe)) {
            return false;
        }
        GTRecipe recipe = (GTRecipe)obj;
        return this.id.equals((Object)recipe.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    @Generated
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Generated
    public void setId(ResourceLocation id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Generated
    public EnergyStack getInputEUt() {
        Object $value = this.inputEUt.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.inputEUt;
            synchronized (atomicReference) {
                $value = this.inputEUt.get();
                if ($value == null) {
                    EnergyStack actualValue = this.calculateEUt(this.tickInputs);
                    $value = actualValue == null ? this.inputEUt : actualValue;
                    this.inputEUt.set($value);
                }
            }
        }
        return (EnergyStack)($value == this.inputEUt ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @Generated
    public EnergyStack getOutputEUt() {
        Object $value = this.outputEUt.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.outputEUt;
            synchronized (atomicReference) {
                $value = this.outputEUt.get();
                if ($value == null) {
                    EnergyStack actualValue = this.calculateEUt(this.tickOutputs);
                    $value = actualValue == null ? this.outputEUt : actualValue;
                    this.outputEUt.set($value);
                }
            }
        }
        return (EnergyStack)($value == this.outputEUt ? null : $value);
    }
}

