/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public abstract class RecipeCondition {
    public static final Codec<RecipeCondition> CODEC = GTRegistries.RECIPE_CONDITIONS.codec().dispatch(RecipeCondition::getType, RecipeConditionType::getCodec);
    protected boolean isReverse;

    public static <RC extends RecipeCondition> Products.P1<RecordCodecBuilder.Mu<RC>, Boolean> isReverse(RecordCodecBuilder.Instance<RC> instance) {
        return instance.group((App)Codec.BOOL.optionalFieldOf("reverse", (Object)false).forGetter(val -> val.isReverse));
    }

    public RecipeCondition() {
        this(false);
    }

    public RecipeCondition(boolean isReverse) {
        this.isReverse = isReverse;
    }

    public abstract RecipeConditionType<?> getType();

    public String getTranslationKey() {
        return "gtceu.recipe.condition." + String.valueOf(this.getType());
    }

    public IGuiTexture getInValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + String.valueOf(this.getType()) + ".png").getSubTexture(0.0f, 0.0f, 1.0f, 0.5f);
    }

    public IGuiTexture getValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + String.valueOf(this.getType()) + ".png").getSubTexture(0.0f, 0.5f, 1.0f, 0.5f);
    }

    public boolean isOr() {
        return false;
    }

    public abstract Component getTooltips();

    public boolean check(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        boolean test = this.testCondition(recipe, recipeLogic);
        return test != this.isReverse;
    }

    protected abstract boolean testCondition(@NotNull GTRecipe var1, @NotNull RecipeLogic var2);

    public abstract RecipeCondition createTemplate();

    @NotNull
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        if (this.isReverse) {
            jsonObject.addProperty("reverse", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    public RecipeCondition deserialize(@NotNull JsonObject config) {
        this.isReverse = GsonHelper.m_13855_((JsonObject)config, (String)"reverse", (boolean)false);
        return this;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isReverse);
    }

    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        this.isReverse = buf.readBoolean();
        return this;
    }

    @Generated
    public boolean isReverse() {
        return this.isReverse;
    }

    @NotNull
    @Generated
    public RecipeCondition setReverse(boolean isReverse) {
        this.isReverse = isReverse;
        return this;
    }
}

