/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.block.FluidBlockRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.BoilerMultiPartRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.CentralMonitorRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.FluidAreaRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.FusionRingRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.QuantumChestItemRender;
import com.gregtechceu.gtceu.client.renderer.machine.impl.QuantumTankFluidRender;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DynamicRenderHelper {
    public static DynamicRender<?, ?> makeBoilerPartRender(BoilerFireboxType fireboxType, Supplier<? extends Block> casingBlock) {
        return new BoilerMultiPartRender(fireboxType, casingBlock);
    }

    public static DynamicRender<?, ?> makeFluidAreaRender(FluidBlockRenderer fluidBlockRenderer, Optional<Fluid> fixedFluid, List<RelativeDirection> drawFaces) {
        return new FluidAreaRender(fluidBlockRenderer, fixedFluid, drawFaces);
    }

    public static DynamicRender<?, ?> makeRecipeFluidAreaRender() {
        return DynamicRenderHelper.makeFluidAreaRender(FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer(), Optional.empty(), FluidAreaRender.DEFAULT_FACES);
    }

    public static DynamicRender<?, ?> createPBFLavaRender() {
        return DynamicRenderHelper.makeFluidAreaRender(FluidBlockRenderer.Builder.create().setFaceOffset(-0.125f).setForcedLight(0xF000F0).getRenderer(), Optional.of(Fluids.f_76195_.m_5613_()), FluidAreaRender.DEFAULT_FACES);
    }

    public static DynamicRender<?, ?> createFusionRingRender() {
        return new FusionRingRender();
    }

    public static DynamicRender<?, ?> createQuantumChestRender() {
        return new QuantumChestItemRender();
    }

    public static DynamicRender<?, ?> createQuantumTankRender() {
        return new QuantumTankFluidRender();
    }

    public static DynamicRender<?, ?> createCentralMonitorRender() {
        return new CentralMonitorRender();
    }
}

