/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.WireProperties;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.gregtechceu.gtceu.common.pipelike.cable.LevelEnergyNet;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CableBlock
extends MaterialPipeBlock<Insulation, WireProperties, LevelEnergyNet> {
    public CableBlock(BlockBehaviour.Properties properties, Insulation insulation, Material material) {
        super(properties, insulation, material);
    }

    @Override
    public int tinted(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int index) {
        if (((Insulation)this.pipeType).isCable && index == 0) {
            return 0x404040;
        }
        return super.tinted(state, level, pos, index);
    }

    @Override
    protected WireProperties createProperties(Insulation insulation, Material material) {
        return insulation.modifyProperties(material.getProperty(PropertyKey.WIRE));
    }

    @Override
    protected WireProperties createMaterialData() {
        return this.material.getProperty(PropertyKey.WIRE);
    }

    @Override
    public LevelEnergyNet getWorldPipeNet(ServerLevel level) {
        return LevelEnergyNet.getOrCreate(level);
    }

    @Override
    public BlockEntityType<? extends PipeBlockEntity<Insulation, WireProperties>> getBlockEntityType() {
        return (BlockEntityType)GTBlockEntities.CABLE.get();
    }

    @Override
    public boolean canPipesConnect(IPipeNode<Insulation, WireProperties> selfTile, Direction side, IPipeNode<Insulation, WireProperties> sideTile) {
        return selfTile instanceof CableBlockEntity && sideTile instanceof CableBlockEntity;
    }

    @Override
    public boolean canPipeConnectToBlock(IPipeNode<Insulation, WireProperties> selfTile, Direction side, @Nullable BlockEntity tile) {
        return tile != null && tile.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, side.m_122424_()).isPresent();
    }

    @Override
    protected PipeModel createPipeModel() {
        return ((Insulation)this.pipeType).createPipeModel(this.material);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        WireProperties wireProperties = (WireProperties)this.createProperties(this.m_49966_(), stack);
        byte tier = GTUtil.getTierByVoltage(wireProperties.getVoltage());
        if (wireProperties.isSuperconductor()) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.superconductor", (Object[])new Object[]{GTValues.VN[tier]}));
        }
        tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.voltage", (Object[])new Object[]{FormattingUtil.formatNumbers(wireProperties.getVoltage()), GTValues.VNF[tier]}));
        tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.amperage", (Object[])new Object[]{FormattingUtil.formatNumbers(wireProperties.getAmperage())}));
        tooltip.add((Component)Component.m_237110_((String)"gtceu.cable.loss_per_block", (Object[])new Object[]{FormattingUtil.formatNumbers(wireProperties.getLossPerBlock())}));
    }

    @Override
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        IPipeNode pipeNode = this.getPipeTile((BlockGetter)level, pos);
        if (pipeNode == null) {
            GTCEu.LOGGER.error("Pipe was null");
            return;
        }
        if (!pipeNode.getFrameMaterial().isNull()) {
            BlockState frameState = ((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)pipeNode.getFrameMaterial())).getDefaultState();
            frameState.m_60734_().m_7892_(frameState, level, pos, entity);
            return;
        }
        if (level.f_46443_) {
            return;
        }
        Insulation insulation = (Insulation)this.getPipeTile((BlockGetter)level, pos).getPipeType();
        if (insulation.insulationLevel == -1 && entity instanceof LivingEntity) {
            LivingEntity entityLiving = (LivingEntity)entity;
            CableBlockEntity cable = (CableBlockEntity)this.getPipeTile((BlockGetter)level, pos);
            if (cable != null && cable.getFrameMaterial().isNull() && ((WireProperties)cable.getNodeData()).getLossPerBlock() > 0) {
                long voltage = cable.getCurrentMaxVoltage();
                double amperage = cable.getAverageAmperage();
                if (voltage > 0L && amperage > 0.0) {
                    float damageAmount = (float)((double)(GTUtil.getTierByVoltage(voltage) + 1) * amperage * 4.0);
                    entityLiving.m_6469_(GTDamageTypes.ELECTRIC.source((LevelAccessor)level), damageAmount);
                    if (entityLiving instanceof ServerPlayer) {
                        // empty if block
                    }
                }
            }
        }
    }
}

