/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CoilBlock
extends ActiveBlock {
    public ICoilType coilType;

    public CoilBlock(BlockBehaviour.Properties properties, ICoilType coilType) {
        super(properties);
        this.coilType = coilType;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (GTUtil.isShiftDown()) {
            int coilTier = this.coilType.getTier();
            tooltip.add((Component)Component.m_237110_((String)"block.gtceu.wire_coil.tooltip_heat", (Object[])new Object[]{this.coilType.getCoilTemperature()}));
            tooltip.add((Component)Component.m_237115_((String)"block.gtceu.wire_coil.tooltip_smelter"));
            tooltip.add((Component)Component.m_237110_((String)"block.gtceu.wire_coil.tooltip_parallel_smelter", (Object[])new Object[]{this.coilType.getLevel() * 32}));
            tooltip.add((Component)Component.m_237110_((String)"block.gtceu.wire_coil.tooltip_energy_smelter", (Object[])new Object[]{Math.max(1, 16 / this.coilType.getEnergyDiscount())}));
            tooltip.add((Component)Component.m_237115_((String)"block.gtceu.wire_coil.tooltip_pyro"));
            tooltip.add((Component)Component.m_237110_((String)"block.gtceu.wire_coil.tooltip_speed_pyro", (Object[])new Object[]{coilTier == 0 ? 75 : 50 * (coilTier + 1)}));
            tooltip.add((Component)Component.m_237115_((String)"block.gtceu.wire_coil.tooltip_cracking"));
            tooltip.add((Component)Component.m_237110_((String)"block.gtceu.wire_coil.tooltip_energy_cracking", (Object[])new Object[]{100 - 10 * coilTier}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"block.gtceu.wire_coil.tooltip_extended_info"));
        }
    }

    public static enum CoilType implements StringRepresentable,
    ICoilType
    {
        CUPRONICKEL("cupronickel", 1800, 1, 1, GTMaterials.Cupronickel, GTCEu.id("block/casings/coils/machine_coil_cupronickel")),
        KANTHAL("kanthal", 2700, 2, 1, GTMaterials.Kanthal, GTCEu.id("block/casings/coils/machine_coil_kanthal")),
        NICHROME("nichrome", 3600, 2, 2, GTMaterials.Nichrome, GTCEu.id("block/casings/coils/machine_coil_nichrome")),
        RTMALLOY("rtm_alloy", 4500, 4, 2, GTMaterials.RTMAlloy, GTCEu.id("block/casings/coils/machine_coil_rtm_alloy")),
        HSSG("hssg", 5400, 4, 4, GTMaterials.HSSG, GTCEu.id("block/casings/coils/machine_coil_hssg")),
        NAQUADAH("naquadah", 7200, 8, 4, GTMaterials.Naquadah, GTCEu.id("block/casings/coils/machine_coil_naquadah")),
        TRINIUM("trinium", 9001, 8, 8, GTMaterials.Trinium, GTCEu.id("block/casings/coils/machine_coil_trinium")),
        TRITANIUM("tritanium", 10800, 16, 8, GTMaterials.Tritanium, GTCEu.id("block/casings/coils/machine_coil_tritanium"));

        @NotNull
        private final String name;
        private final int coilTemperature;
        private final int level;
        private final int energyDiscount;
        @NotNull
        private final Material material;
        @NotNull
        private final ResourceLocation texture;

        private CoilType(String name, int coilTemperature, int level, int energyDiscount, Material material, ResourceLocation texture) {
            this.name = name;
            this.coilTemperature = coilTemperature;
            this.level = level;
            this.energyDiscount = energyDiscount;
            this.material = material;
            this.texture = texture;
        }

        @Override
        public int getTier() {
            return this.ordinal();
        }

        @NotNull
        public String toString() {
            return this.getName();
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        @Override
        @NotNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public int getCoilTemperature() {
            return this.coilTemperature;
        }

        @Override
        @Generated
        public int getLevel() {
            return this.level;
        }

        @Override
        @Generated
        public int getEnergyDiscount() {
            return this.energyDiscount;
        }

        @Override
        @NotNull
        @Generated
        public Material getMaterial() {
            return this.material;
        }

        @Override
        @NotNull
        @Generated
        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

