/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.placeholder.IPlaceholderInfoProviderCover;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.client.renderer.cover.CoverTextRenderer;
import com.gregtechceu.gtceu.client.renderer.cover.IDynamicCoverRenderer;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.integration.create.GTCreateIntegration;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ComputerMonitorCover
extends CoverBehavior
implements IUICover,
IDataStickInteractable,
IPlaceholderInfoProviderCover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ComputerMonitorCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    private TickableSubscription subscription;
    private final CoverTextRenderer renderer;
    @Persisted
    private final List<String> formatStringArgs = new ArrayList<String>(8);
    @Persisted
    private final List<String> formatStringLines = new ArrayList<String>(8);
    @Persisted
    @DescSynced
    private List<MutableComponent> text = new ArrayList<MutableComponent>();
    @Persisted
    public final CustomItemStackHandler itemStackHandler = new CustomItemStackHandler(8);
    private String placeholderSearch = "";
    @Persisted
    private int updateInterval = 100;
    @Persisted
    private long ticksSincePlaced = 0L;
    @Persisted
    private final List<MutableComponent> createDisplayTargetBuffer = new ArrayList<MutableComponent>();

    public ComputerMonitorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        this.renderer = new CoverTextRenderer(this::getText);
        for (int i = 0; i < 100; ++i) {
            this.createDisplayTargetBuffer.add(MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_));
        }
    }

    public List<MutableComponent> getRenderedText() {
        String s = this.formatStringLines.stream().reduce((a, b) -> a + "\n" + b).orElse("");
        List<String> tmp = new ArrayList<String>(this.formatStringArgs);
        tmp = tmp.stream().map(str -> "{" + str + "}").toList();
        return PlaceholderHandler.processPlaceholders(GTStringUtils.replace(s, "\\{}", tmp), new PlaceholderContext(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide, this.itemStackHandler, this, new MultiLineComponent(this.text)));
    }

    @Override
    public void setDisplayTargetBufferLine(int line, MutableComponent component) {
        this.createDisplayTargetBuffer.set(line, component);
    }

    @Override
    public boolean canPipePassThrough() {
        return false;
    }

    @Override
    public Supplier<IDynamicCoverRenderer> getDynamicRenderer() {
        return () -> this.renderer;
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public Widget createUIWidget() {
        int finalI;
        int i;
        int textFieldWidth = 160;
        int horizontalPadding = 10;
        int verticalPadding = 2;
        WidgetGroup group = new WidgetGroup(0, 0, 2 * textFieldWidth + 3 * horizontalPadding, 150);
        WidgetGroup mainPage = new WidgetGroup(0, 0, 2 * textFieldWidth + 3 * horizontalPadding, 150);
        WidgetGroup formatStringArgsPage = new WidgetGroup(0, 0, 2 * textFieldWidth + 3 * horizontalPadding, 150);
        for (i = 0; i < 8; ++i) {
            TextFieldWidget formatStringInput = new TextFieldWidget();
            formatStringInput.setSize(textFieldWidth, 15);
            formatStringInput.setSelfPosition(horizontalPadding + textFieldWidth / 2, 10 + verticalPadding + i * (15 + verticalPadding));
            formatStringInput.setHoverTooltips(GTStringUtils.toImmutable(LangHandler.getMultiLang("gtceu.gui.computer_monitor_cover.main_textbox_tooltip", i + 1)));
            finalI = i;
            if (i >= this.formatStringLines.size()) {
                this.formatStringLines.add("");
            }
            formatStringInput.setCurrentString((Object)this.formatStringLines.get(i));
            formatStringInput.setTextResponder(s -> this.formatStringLines.set(finalI, (String)s));
            mainPage.addWidget((Widget)formatStringInput);
            SlotWidget slot = new SlotWidget((IItemHandlerModifiable)this.itemStackHandler, i, horizontalPadding + 50, 20 * i);
            slot.setBackgroundTexture((IGuiTexture)com.lowdragmc.lowdraglib.gui.widget.SlotWidget.ITEM_SLOT_TEXTURE);
            slot.setHoverTooltips(GTStringUtils.toImmutable(LangHandler.getMultiLang("gtceu.gui.computer_monitor_cover.slot_tooltip", i + 1)));
            mainPage.addWidget((Widget)slot);
        }
        for (i = 0; i < 8; ++i) {
            TextFieldWidget formatStringArgsInput = new TextFieldWidget();
            formatStringArgsInput.setSize(textFieldWidth, 15);
            formatStringArgsInput.setSelfPosition(textFieldWidth / 2 + horizontalPadding, 10 + verticalPadding + i * (15 + verticalPadding));
            formatStringArgsInput.setHoverTooltips(GTStringUtils.toImmutable(LangHandler.getMultiLang("gtceu.gui.computer_monitor_cover.second_page_textbox_tooltip", GTStringUtils.getIntOrderingSuffix(i + 1))));
            finalI = i;
            if (i >= this.formatStringArgs.size()) {
                this.formatStringArgs.add("");
            }
            formatStringArgsInput.setCurrentString((Object)this.formatStringArgs.get(i));
            formatStringArgsInput.setTextResponder(s -> this.formatStringArgs.set(finalI, (String)s));
            formatStringArgsPage.addWidget((Widget)formatStringArgsInput);
        }
        ButtonWidget switchToFormatStringArgsPageButton = new ButtonWidget(horizontalPadding + 50, 10 * (15 + verticalPadding) + verticalPadding, 20, 20, (IGuiTexture)new ResourceBorderTexture(), clickData -> {
            group.clearAllWidgets();
            group.addWidget((Widget)formatStringArgsPage);
        });
        ButtonWidget switchBack = new ButtonWidget(horizontalPadding + 50, 10 * (15 + verticalPadding) + verticalPadding, 20, 20, (IGuiTexture)new ResourceBorderTexture(), clickData -> {
            group.clearAllWidgets();
            group.addWidget((Widget)mainPage);
        });
        mainPage.addWidget(PlaceholderHandler.getPlaceholderHandlerUI(""));
        IntInputWidget updateIntervalInput = new IntInputWidget(0, 0, 60, 20, this::getUpdateInterval, this::setUpdateInterval);
        updateIntervalInput.setMin(1);
        updateIntervalInput.setMax(1200);
        updateIntervalInput.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtceu.gui.computer_monitor_cover.update_interval")});
        mainPage.addWidget((Widget)updateIntervalInput);
        switchToFormatStringArgsPageButton.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtceu.gui.computer_monitor_cover.edit_blank_placeholders")});
        switchBack.setHoverTooltips(new Component[]{Component.m_237115_((String)"gtceu.gui.computer_monitor_cover.edit_displayed_text")});
        mainPage.addWidget((Widget)switchToFormatStringArgsPageButton);
        formatStringArgsPage.addWidget((Widget)switchBack);
        group.addWidget((Widget)mainPage);
        return group;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscription = this.coverHolder.subscribeServerTick(this.subscription, this::update);
    }

    private void update() {
        ++this.ticksSincePlaced;
        if (this.coverHolder.getOffsetTimer() % (long)this.updateInterval == 0L) {
            try {
                if (GTCEu.Mods.isCreateLoaded()) {
                    GTCreateIntegration.TemporaryRedstoneLinkTransmitter.destroyAll();
                }
                this.setRedstoneSignalOutput(0);
                this.text = this.getRenderedText();
            }
            catch (RuntimeException e) {
                this.text = GTUtil.list(Component.m_237110_((String)"gtceu.computer_monitor_cover.error.exception", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public List<ItemStack> getAdditionalDrops() {
        List<ItemStack> drops = super.getAdditionalDrops();
        for (int i = 0; i < 8; ++i) {
            if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
            drops.add(this.itemStackHandler.getStackInSlot(i));
        }
        return drops;
    }

    @Override
    public InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        CompoundTag tag = dataStick.m_41737_("computer_monitor_cover_config");
        if (tag == null) {
            return InteractionResult.FAIL;
        }
        ArrayList<String> stringLines = new ArrayList<String>();
        ListTag stringLinesTag = tag.m_128437_("lines", 8);
        for (int i = 0; i < stringLinesTag.size(); ++i) {
            stringLines.add(stringLinesTag.m_128778_(i));
        }
        this.formatStringLines.clear();
        this.formatStringLines.addAll(stringLines);
        ArrayList<String> stringArgs = new ArrayList<String>();
        ListTag stringArgsTag = tag.m_128437_("args", 8);
        for (int i = 0; i < stringArgsTag.size(); ++i) {
            stringArgs.add(stringArgsTag.m_128778_(i));
        }
        this.formatStringArgs.clear();
        this.formatStringArgs.addAll(stringArgs);
        this.updateInterval = tag.m_128451_("updateInterval");
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onDataStickShiftUse(Player player, ItemStack dataStick) {
        CompoundTag tag = dataStick.m_41698_("computer_monitor_cover_config");
        ListTag stringLinesTag = new ListTag();
        this.formatStringLines.forEach(line -> stringLinesTag.add((Object)StringTag.m_129297_((String)line)));
        tag.m_128365_("lines", (Tag)stringLinesTag);
        ListTag stringArgsTag = new ListTag();
        this.formatStringArgs.forEach(line -> stringArgsTag.add((Object)StringTag.m_129297_((String)line)));
        tag.m_128365_("args", (Tag)stringArgsTag);
        tag.m_128405_("updateInterval", this.updateInterval);
        return InteractionResult.SUCCESS;
    }

    @Generated
    public List<MutableComponent> getText() {
        return this.text;
    }

    @Generated
    public void setPlaceholderSearch(String placeholderSearch) {
        this.placeholderSearch = placeholderSearch;
    }

    @Generated
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Generated
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    @Generated
    public long getTicksSincePlaced() {
        return this.ticksSincePlaced;
    }

    @Generated
    public List<MutableComponent> getCreateDisplayTargetBuffer() {
        return this.createDisplayTargetBuffer;
    }
}

