/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.placeholder.IPlaceholderInfoProviderCover;
import com.gregtechceu.gtceu.api.placeholder.MultiLineComponent;
import com.gregtechceu.gtceu.api.placeholder.Placeholder;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderContext;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderHandler;
import com.gregtechceu.gtceu.api.placeholder.PlaceholderUtils;
import com.gregtechceu.gtceu.api.placeholder.exceptions.InvalidArgsException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.InvalidNumberException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.MissingItemException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.NotSupportedException;
import com.gregtechceu.gtceu.api.placeholder.exceptions.PlaceholderException;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTPlaceholders {
    public static int countItems(String id, @Nullable IItemHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        int cnt = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            String itemId = "%s:%s".formatted(itemStack.m_41720_().getCreatorModId(itemStack), itemStack.m_41720_().toString());
            if (!itemId.equals(id)) continue;
            cnt += itemStack.m_41613_();
        }
        return cnt;
    }

    public static int countFluids(@Nullable String id, @Nullable IFluidHandler fluidHandler) {
        if (fluidHandler == null) {
            return 0;
        }
        int cnt = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
            String fluidId = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid())).toString();
            if (id != null && !fluidId.equals(id)) continue;
            cnt += fluidStack.getAmount();
        }
        return cnt;
    }

    public static int countItems(@Nullable ItemFilter filter, @Nullable IItemHandler itemHandler) {
        if (itemHandler == null) {
            return -1;
        }
        int cnt = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (filter != null && !filter.test(itemHandler.getStackInSlot(i))) continue;
            cnt += itemHandler.getStackInSlot(i).m_41613_();
        }
        return cnt;
    }

    public static void initPlaceholders() {
        PlaceholderHandler.addPlaceholder(new Placeholder("energy"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                IEnergyContainer energy = GTCapabilityHelper.getEnergyContainer(ctx.level(), ctx.pos(), ctx.side());
                return MultiLineComponent.literal(energy != null ? energy.getEnergyStored() : 0L);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("energyCapacity"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                IEnergyContainer energy = GTCapabilityHelper.getEnergyContainer(ctx.level(), ctx.pos(), ctx.side());
                return MultiLineComponent.literal(energy != null ? energy.getEnergyCapacity() : 0L);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("calc"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) {
                ArrayList<String> stringArgs = new ArrayList<String>();
                args.forEach(components -> stringArgs.add(GTStringUtils.componentsToString(components)));
                return MultiLineComponent.literal(GTStringUtils.calc(stringArgs));
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("itemCount"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IItemHandler itemHandler = GTCapabilityHelper.getItemHandler(ctx.level(), ctx.pos(), ctx.side());
                if (args.isEmpty()) {
                    return MultiLineComponent.literal(GTPlaceholders.countItems((ItemFilter)null, itemHandler));
                }
                if (args.size() == 1) {
                    return MultiLineComponent.literal(GTPlaceholders.countItems(GTStringUtils.componentsToString(args.get(0)), itemHandler));
                }
                if (GTStringUtils.equals(args.get(0), "filter")) {
                    int slot = PlaceholderUtils.toInt(args.get(1));
                    PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                    try {
                        if (ctx.itemStackHandler() == null) {
                            throw new NotSupportedException();
                        }
                        return MultiLineComponent.literal(GTPlaceholders.countItems(ItemFilter.loadFilter(ctx.itemStackHandler().getStackInSlot(slot - 1)), itemHandler));
                    }
                    catch (NullPointerException e) {
                        throw new MissingItemException("filter", slot);
                    }
                }
                throw new InvalidArgsException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("fluidCount"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                IFluidHandler fluidHandler = GTCapabilityHelper.getFluidHandler(ctx.level(), ctx.pos(), ctx.side());
                if (args.isEmpty()) {
                    return MultiLineComponent.literal(GTPlaceholders.countFluids(null, fluidHandler));
                }
                if (args.size() == 1) {
                    return MultiLineComponent.literal(GTPlaceholders.countFluids(GTStringUtils.componentsToString(args.get(0)), fluidHandler));
                }
                PlaceholderUtils.checkArgs(args, 1);
                return MultiLineComponent.empty();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("if"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2, true);
                try {
                    if (GTStringUtils.toDouble(args.get(0)) != 0.0) {
                        return args.get(1);
                    }
                    if (args.size() > 2) {
                        return args.get(2);
                    }
                    return MultiLineComponent.empty();
                }
                catch (NumberFormatException e) {
                    return args.get(1);
                }
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("color"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2);
                ChatFormatting color = ChatFormatting.m_126657_((String)GTStringUtils.componentsToString(args.get(0)));
                if (color == null) {
                    throw new InvalidArgsException();
                }
                return new MultiLineComponent(args.get(1).stream().map(c -> c.m_130940_(color)).toList());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("underline"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                return new MultiLineComponent(args.get(0).stream().map(c -> c.m_130940_(ChatFormatting.UNDERLINE)).toList());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("strike"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                return new MultiLineComponent(args.get(0).stream().map(c -> c.m_130940_(ChatFormatting.STRIKETHROUGH)).toList());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("obf"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                return new MultiLineComponent(args.get(0).stream().map(c -> c.m_130940_(ChatFormatting.OBFUSCATED)).toList());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("random"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2);
                return MultiLineComponent.literal(GTValues.RNG.m_216332_(PlaceholderUtils.toInt(args.get(0)), PlaceholderUtils.toInt(args.get(1))));
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("repeat"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2);
                int count = PlaceholderUtils.toInt(args.get(0));
                MultiLineComponent out = MultiLineComponent.empty();
                for (int i = 0; i < count; ++i) {
                    out.append(args.get(1));
                }
                return out;
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("block"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                return MultiLineComponent.literal("\u2588");
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("tick"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                CoverBehavior coverBehavior = ctx.cover();
                if (coverBehavior instanceof IPlaceholderInfoProviderCover) {
                    IPlaceholderInfoProviderCover cover = (IPlaceholderInfoProviderCover)((Object)coverBehavior);
                    return MultiLineComponent.literal(cover.getTicksSincePlaced());
                }
                throw new NotSupportedException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("select"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1, true);
                int i = PlaceholderUtils.toInt(args.get(0));
                PlaceholderUtils.checkArgs(args, i + 2);
                return args.get(i + 1);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("redstone"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2, true);
                if (GTStringUtils.equals(args.get(0), "get")) {
                    Direction direction = Direction.m_122402_((String)GTStringUtils.componentsToString(args.get(1)));
                    if (direction == null) {
                        throw new InvalidArgsException();
                    }
                    return MultiLineComponent.literal(ctx.level().m_277185_(ctx.pos().m_121945_(direction), direction));
                }
                if (GTStringUtils.equals(args.get(1), "set")) {
                    int power = PlaceholderUtils.toInt(args.get(1));
                    PlaceholderUtils.checkRange("redstone power", 0, 15, power);
                    if (ctx.cover() == null) {
                        throw new NotSupportedException();
                    }
                    ctx.cover().setRedstoneSignalOutput(power);
                    return MultiLineComponent.empty();
                }
                throw new InvalidArgsException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("previousText"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                int i = PlaceholderUtils.toInt(args.get(0));
                if (ctx.previousText() == null) {
                    throw new NotSupportedException();
                }
                PlaceholderUtils.checkRange("line", 1, ctx.previousText().size(), i);
                return MultiLineComponent.of((Component)ctx.previousText().get(i - 1));
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("progress"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                IWorkable workable = GTCapabilityHelper.getWorkable(ctx.level(), ctx.pos(), ctx.side());
                if (workable == null) {
                    throw new NotSupportedException();
                }
                return MultiLineComponent.literal(workable.getProgress());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("maxProgress"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                IWorkable workable = GTCapabilityHelper.getWorkable(ctx.level(), ctx.pos(), ctx.side());
                if (workable == null) {
                    throw new NotSupportedException();
                }
                return MultiLineComponent.literal(workable.getMaxProgress());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("maintenance"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                IMaintenanceMachine maintenance = GTCapabilityHelper.getMaintenanceMachine(ctx.level(), ctx.pos(), ctx.side());
                if (maintenance == null) {
                    throw new NotSupportedException();
                }
                return MultiLineComponent.literal(maintenance.hasMaintenanceProblems() ? 1L : 0L);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("active"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                IWorkable workable = GTCapabilityHelper.getWorkable(ctx.level(), ctx.pos(), ctx.side());
                if (workable == null) {
                    throw new NotSupportedException();
                }
                return MultiLineComponent.literal(workable.isActive() ? 1L : 0L);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("voltage"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                BlockEntity blockEntity = ctx.level().m_7702_(ctx.pos());
                if (blockEntity instanceof CableBlockEntity) {
                    CableBlockEntity cable = (CableBlockEntity)blockEntity;
                    return MultiLineComponent.literal(cable.getAverageVoltage());
                }
                throw new NotSupportedException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("amperage"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 0);
                BlockEntity blockEntity = ctx.level().m_7702_(ctx.pos());
                if (blockEntity instanceof CableBlockEntity) {
                    CableBlockEntity cable = (CableBlockEntity)blockEntity;
                    return MultiLineComponent.literal(cable.getAverageAmperage());
                }
                throw new NotSupportedException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("count"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1, true);
                String arg1 = GTStringUtils.componentsToString(args.get(0));
                int cnt = -1;
                for (List list : args) {
                    if (!GTStringUtils.equals(list, arg1)) continue;
                    ++cnt;
                }
                return MultiLineComponent.literal(cnt);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("data"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2, true);
                try {
                    int slot = PlaceholderUtils.toInt(args.get(1));
                    PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                    if (ctx.itemStackHandler() == null) {
                        throw new NotSupportedException();
                    }
                    ItemStack stack = ctx.itemStackHandler().getStackInSlot(slot - 1);
                    int capacity = -1;
                    Item item = stack.m_41720_();
                    if (item instanceof ComponentItem) {
                        ComponentItem componentItem = (ComponentItem)item;
                        for (IItemComponent component : componentItem.getComponents()) {
                            if (!(component instanceof IDataItem)) continue;
                            IDataItem dataComponent = (IDataItem)((Object)component);
                            capacity = dataComponent.getCapacity();
                            break;
                        }
                    }
                    if (capacity == -1) {
                        throw new MissingItemException("any data item", slot);
                    }
                    PlaceholderUtils.checkRange("index", 0, capacity - 1, PlaceholderUtils.toInt(args.get(2)));
                    ListTag data = stack.m_41784_().m_128437_("computer_monitor_cover_data", 8);
                    while (data.size() <= PlaceholderUtils.toInt(args.get(2))) {
                        data.add((Object)StringTag.m_129297_((String)""));
                    }
                    int p = stack.m_41784_().m_128451_("computer_monitor_cover_p");
                    if (GTStringUtils.equals(args.get(2), "")) {
                        args.set(2, MultiLineComponent.literal(p));
                    }
                    if (GTStringUtils.equals(args.get(0), "get")) {
                        return MultiLineComponent.literal(data.m_128778_(PlaceholderUtils.toInt(args.get(2)) % capacity));
                    }
                    if (args.get(0).equalsString("set")) {
                        data.set(PlaceholderUtils.toInt(args.get(2)) % capacity, (Tag)StringTag.m_129297_((String)args.get(3).toString()));
                        stack.m_41784_().m_128365_("computer_monitor_cover_data", (Tag)data);
                        return MultiLineComponent.empty();
                    }
                    if (args.get(0).equalsString("setp")) {
                        stack.m_41784_().m_128405_("computer_monitor_cover_p", PlaceholderUtils.toInt(args.get(3)) % capacity);
                        return MultiLineComponent.empty();
                    }
                    if (args.get(0).equalsString("inc")) {
                        stack.m_41784_().m_128405_("computer_monitor_cover_p", (p + 1) % capacity);
                        return MultiLineComponent.empty();
                    }
                    if (args.get(0).equalsString("dec")) {
                        stack.m_41784_().m_128405_("computer_monitor_cover_p", p == 0 ? capacity - 1 : p - 1);
                        return MultiLineComponent.empty();
                    }
                    throw new InvalidArgsException();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new InvalidArgsException();
                }
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("combine"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) {
                MultiLineComponent out = MultiLineComponent.empty();
                for (int i = 0; i < args.size(); ++i) {
                    out.append(args.get(i));
                    if (i == args.size() - 1) continue;
                    out.append(" ");
                }
                return out;
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("nbt"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                int slot = GTStringUtils.toInt(args.get(0));
                PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                if (ctx.itemStackHandler() == null) {
                    throw new NotSupportedException();
                }
                return MultiLineComponent.literal(ctx.itemStackHandler().getStackInSlot(slot - 1).m_41784_().toString());
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("toChars"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                if (args.get(0).isEmpty()) {
                    return MultiLineComponent.empty();
                }
                StringBuilder out = new StringBuilder();
                for (char c : GTStringUtils.componentsToString(args.get(0)).toCharArray()) {
                    out.append(c).append(' ');
                }
                return MultiLineComponent.literal(out.substring(0, out.length() - 2));
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("toAscii"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                String arg = args.get(0).toString();
                if (arg.length() != 1) {
                    throw new InvalidArgsException();
                }
                return MultiLineComponent.literal(arg.toCharArray()[0]);
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("fromAscii"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                return MultiLineComponent.literal((char)PlaceholderUtils.toInt(args.get(0)));
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("subList"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2, true);
                int l = PlaceholderUtils.toInt(args.get(0));
                int r = PlaceholderUtils.toInt(args.get(1));
                PlaceholderUtils.checkRange("start index", 0, args.size(), l);
                PlaceholderUtils.checkRange("end index", 0, args.size(), r);
                MultiLineComponent out = MultiLineComponent.empty();
                for (int i = l; i < r - 1; ++i) {
                    out.append(args.get(i)).append(' ');
                }
                out.append(args.get(r - 1));
                return out;
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("cmp"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 3);
                double a = PlaceholderUtils.toDouble(args.get(0));
                double b = PlaceholderUtils.toDouble(args.get(2));
                return switch (args.get(1).toString()) {
                    case ">" -> MultiLineComponent.literal(a > b ? 1L : 0L);
                    case "<" -> MultiLineComponent.literal(a < b ? 1L : 0L);
                    case ">=" -> MultiLineComponent.literal(a >= b ? 1L : 0L);
                    case "<=" -> MultiLineComponent.literal(a <= b ? 1L : 0L);
                    case "==" -> MultiLineComponent.literal(a == b ? 1L : 0L);
                    case "!=" -> MultiLineComponent.literal(a != b ? 1L : 0L);
                    default -> throw new InvalidArgsException();
                };
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("bf"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 2);
                int slot = PlaceholderUtils.toInt(args.get(0));
                PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                if (ctx.itemStackHandler() == null) {
                    throw new NotSupportedException();
                }
                ItemStack stack = ctx.itemStackHandler().getStackInSlot(slot - 1);
                int capacity = -1;
                Item item = stack.m_41720_();
                if (item instanceof ComponentItem) {
                    ComponentItem componentItem = (ComponentItem)item;
                    for (IItemComponent component : componentItem.getComponents()) {
                        if (!(component instanceof IDataItem)) continue;
                        IDataItem dataComponent = (IDataItem)((Object)component);
                        capacity = dataComponent.getCapacity();
                        break;
                    }
                }
                if (capacity == -1) {
                    throw new MissingItemException("any data item", slot);
                }
                ListTag tag = stack.m_41784_().m_128437_("computer_monitor_cover_data", 8);
                int operationsLeft = 1000;
                int p = 0;
                String code = args.get(1).toString();
                Stack<Integer> loops = new Stack<Integer>();
                for (int i = 0; i < code.length() && operationsLeft > 0; --operationsLeft, ++i) {
                    while (tag.size() <= p) {
                        tag.add((Object)StringTag.m_129297_((String)"0"));
                    }
                    if (tag.m_128778_(p).isEmpty()) {
                        tag.set(i, (Tag)StringTag.m_129297_((String)"0"));
                    }
                    try {
                        switch (code.charAt(i)) {
                            case '+': {
                                tag.set(p, (Tag)StringTag.m_129297_((String)String.valueOf(Integer.parseInt(tag.m_128778_(p)) + 1)));
                                break;
                            }
                            case '-': {
                                tag.set(p, (Tag)StringTag.m_129297_((String)String.valueOf(Integer.parseInt(tag.m_128778_(p)) - 1)));
                                break;
                            }
                            case '>': {
                                ++p;
                                break;
                            }
                            case '<': {
                                --p;
                                break;
                            }
                            case '[': {
                                loops.push(i);
                                break;
                            }
                            case ']': {
                                if (Integer.parseInt(tag.m_128778_(p)) == 0) {
                                    loops.pop();
                                    break;
                                }
                                i = (Integer)loops.peek();
                                break;
                            }
                            default: {
                                throw new PlaceholderException(Component.m_237110_((String)"gtceu.computer_monitor_cover.error.bf_invalid", (Object[])new Object[]{i}).getString());
                            }
                        }
                        continue;
                    }
                    catch (InvalidNumberException e) {
                        throw new PlaceholderException(Component.m_237110_((String)"gtceu.computer_monitor_cover.error.bf_invalid_num", (Object[])new Object[]{p, i}).getString());
                    }
                }
                return MultiLineComponent.empty();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("cmd"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                Level level;
                PlaceholderUtils.checkArgs(args, 2);
                if (ctx.itemStackHandler() == null) {
                    throw new NotSupportedException();
                }
                int slot = PlaceholderUtils.toInt(args.get(0));
                PlaceholderUtils.checkRange("slot index", 1, 8, slot);
                ItemStack stack = ctx.itemStackHandler().getStackInSlot(slot - 1);
                if (!stack.m_41784_().m_128441_("boundPlayerPermLevel")) {
                    throw new MissingItemException("any data item bound to player", slot);
                }
                int perm = stack.m_41784_().m_128451_("boundPlayerPermLevel");
                MutableComponent displayName = Component.Serializer.m_130701_((String)stack.m_41784_().m_128461_("boundPlayerName"));
                if (displayName == null) {
                    displayName = Component.m_237113_((String)"Placeholder processor");
                }
                if ((level = ctx.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    MinecraftServer server = serverLevel.m_7654_();
                    final MultiLineComponent output = MultiLineComponent.empty();
                    UUID playerUUID = null;
                    try {
                        playerUUID = UUID.fromString(stack.m_41784_().m_128461_("boundPlayerUUID"));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    ServerPlayer player = playerUUID == null ? null : server.m_6846_().m_11259_(playerUUID);
                    CommandSource customSource = new CommandSource(){

                        public void m_213846_(@NotNull Component message) {
                            output.append(List.of(message));
                            output.appendNewline();
                        }

                        public boolean m_6999_() {
                            return true;
                        }

                        public boolean m_7028_() {
                            return true;
                        }

                        public boolean m_6102_() {
                            return false;
                        }
                    };
                    CommandSourceStack source = new CommandSourceStack(customSource, ctx.pos() == null ? Vec3.f_82478_ : ctx.pos().m_252807_(), Vec2.f_82462_, serverLevel, perm, displayName.getString(), (Component)displayName, server, (Entity)player);
                    server.m_129892_().m_230957_(source, args.get(1).toString());
                    return output;
                }
                throw new NotSupportedException();
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("tm"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) {
                return MultiLineComponent.literal("\u2122");
            }
        });
        PlaceholderHandler.addPlaceholder(new Placeholder("formatInt"){

            @Override
            public MultiLineComponent apply(PlaceholderContext ctx, List<MultiLineComponent> args) throws PlaceholderException {
                PlaceholderUtils.checkArgs(args, 1);
                long n = PlaceholderUtils.toLong(args.get(0));
                Map<Long, String> suffixes = Map.of(1L, "", 1000L, "K", 1000000L, "M", 1000000000L, "B", 1000000000000L, "T");
                long max = 1L;
                for (Long i : suffixes.keySet()) {
                    if (n < i || max >= i) continue;
                    max = i;
                }
                return MultiLineComponent.literal("%.2f%s".formatted((double)n / (double)max, suffixes.get(max)));
            }
        });
    }
}

