/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data.machines;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.PropertyFluidFilter;
import com.gregtechceu.gtceu.api.item.DrumMachineItem;
import com.gregtechceu.gtceu.api.item.QuantumTankMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.SimpleGeneratorMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderHelper;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTMedicalConditions;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.models.GTMachineModels;
import com.gregtechceu.gtceu.common.machine.electric.BatteryBufferMachine;
import com.gregtechceu.gtceu.common.machine.electric.ChargerMachine;
import com.gregtechceu.gtceu.common.machine.electric.ConverterMachine;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.MultiblockTankMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeCombustionEngineMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.generator.LargeTurbineMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.LaserHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.TankValvePartMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.LargeBoilerMachine;
import com.gregtechceu.gtceu.common.machine.storage.CrateMachine;
import com.gregtechceu.gtceu.common.machine.storage.DrumMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class GTMachineUtils {
    public static final int[] ALL_TIERS = GTValues.tiersBetween(0, GTCEuAPI.isHighTier() ? 14 : 9);
    public static final int[] ELECTRIC_TIERS = GTValues.tiersBetween(1, GTCEuAPI.isHighTier() ? 13 : 8);
    public static final int[] LOW_TIERS = GTValues.tiersBetween(1, 4);
    public static final int[] HIGH_TIERS = GTValues.tiersBetween(5, GTCEuAPI.isHighTier() ? 13 : 9);
    public static final int[] MULTI_HATCH_TIERS = GTValues.tiersBetween(4, GTCEuAPI.isHighTier() ? 14 : 9);
    public static final int[] DUAL_HATCH_TIERS = GTValues.tiersBetween(6, GTCEuAPI.isHighTier() ? 14 : 9);
    public static final Int2IntFunction defaultTankSizeFunction = tier -> (tier <= 1 ? 8 : (tier == 2 ? 12 : (tier == 3 ? 16 : (tier == 4 ? 32 : 64)))) * 1000;
    public static final Int2IntFunction hvCappedTankSizeFunction = tier -> (tier <= 1 ? 8 : (tier == 2 ? 12 : 16)) * 1000;
    public static final Int2IntFunction largeTankSizeFunction = tier -> (tier <= 1 ? 32 : (tier == 2 ? 48 : 64)) * 1000;
    public static final Int2IntFunction steamGeneratorTankSizeFunction = tier -> Math.min(16 * (1 << tier - 1), 64) * 1000;
    public static final Int2IntFunction genericGeneratorTankSizeFunction = tier -> Math.min(4 * (1 << tier - 1), 16) * 1000;
    public static Object2IntMap<MachineDefinition> DRUM_CAPACITY = new Object2IntArrayMap();
    public static final PartAbility[] DUAL_INPUT_HATCH_ABILITIES = new PartAbility[]{PartAbility.IMPORT_ITEMS, PartAbility.IMPORT_FLUIDS};
    public static final PartAbility[] DUAL_OUTPUT_HATCH_ABILITIES = new PartAbility[]{PartAbility.EXPORT_ITEMS, PartAbility.EXPORT_FLUIDS};
    public static BiConsumer<ItemStack, List<Component>> TANK_TOOLTIPS = (stack, list) -> {
        if (stack.m_41782_()) {
            String key = stack.m_41783_().m_128441_("stored") ? "stored" : "Fluid";
            FluidStack stored = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41698_(key));
            long storedAmount = stack.m_41784_().m_128454_("storedAmount");
            if (storedAmount == 0L && !stored.isEmpty()) {
                storedAmount = stored.getAmount();
            }
            list.add(1, Component.m_237110_((String)"gtceu.universal.tooltip.fluid_stored", (Object[])new Object[]{stored.getDisplayName(), FormattingUtil.formatNumbers(storedAmount)}));
        }
    };
    public static BiConsumer<ItemStack, List<Component>> CHEST_TOOLTIPS = (stack, list) -> {
        if (stack.m_41782_()) {
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack.m_41698_("stored"));
            long storedAmount = stack.m_41784_().m_128454_("storedAmount");
            list.add(1, Component.m_237110_((String)"gtceu.universal.tooltip.item_stored", (Object[])new Object[]{itemStack.m_41786_(), FormattingUtil.formatNumbers(storedAmount)}));
        }
    };

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, boolean hasPollutionDebuff) {
        return GTMachineUtils.registerSimpleMachines(GTRegistration.REGISTRATE, name, recipeType, tankScalingFunction, hasPollutionDebuff);
    }

    public static MachineDefinition[] registerSimpleMachines(GTRegistrate registrate, String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, boolean hasPollutionDebuff) {
        return GTMachineUtils.registerSimpleMachines(registrate, name, recipeType, tankScalingFunction, hasPollutionDebuff, ELECTRIC_TIERS);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction) {
        return GTMachineUtils.registerSimpleMachines(GTRegistration.REGISTRATE, name, recipeType, tankScalingFunction);
    }

    public static MachineDefinition[] registerSimpleMachines(GTRegistrate registrate, String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction) {
        return GTMachineUtils.registerSimpleMachines(registrate, name, recipeType, tankScalingFunction, false);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType) {
        return GTMachineUtils.registerSimpleMachines(GTRegistration.REGISTRATE, name, recipeType);
    }

    public static MachineDefinition[] registerSimpleMachines(GTRegistrate registrate, String name, GTRecipeType recipeType) {
        return GTMachineUtils.registerSimpleMachines(registrate, name, recipeType, defaultTankSizeFunction);
    }

    public static MachineDefinition[] registerSimpleMachines(GTRegistrate registrate, String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, boolean hasPollutionDebuff, int ... tiers) {
        return GTMachineUtils.registerTieredMachines(registrate, name, (IMachineBlockEntity holder, Integer tier) -> new SimpleTieredMachine((IMachineBlockEntity)holder, (int)tier, tankScalingFunction, new Object[0]), (tier, builder) -> {
            if (hasPollutionDebuff) {
                builder.recipeModifiers(GTRecipeModifiers.ENVIRONMENT_REQUIREMENT.apply(GTMedicalConditions.CARBON_MONOXIDE_POISONING, 100 * tier), GTRecipeModifiers.OC_NON_PERFECT).conditionalTooltip(GTMachineUtils.defaultEnvironmentRequirement(), ConfigHolder.INSTANCE.gameplay.environmentalHazards);
            } else {
                builder.recipeModifier(GTRecipeModifiers.OC_NON_PERFECT);
            }
            return builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(name), GTValues.VLVT[tier])).editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id(name), recipeType)).rotationState(RotationState.NON_Y_AXIS).recipeType(recipeType).workableTieredHullModel(GTCEu.id("block/machines/" + name)).tooltips(GTMachineUtils.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, tankScalingFunction.applyAsInt(tier.intValue()), true)).register();
        }, tiers);
    }

    public static MachineDefinition[] registerTieredMachines(String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, int ... tiers) {
        return GTMachineUtils.registerTieredMachines(GTRegistration.REGISTRATE, name, factory, builder, tiers);
    }

    public static MachineDefinition[] registerTieredMachines(GTRegistrate registrate, String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            MachineBuilder<MachineDefinition> register = registrate.machine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSteamMachines(String name, BiFunction<IMachineBlockEntity, Boolean, MetaMachine> factory, BiFunction<Boolean, MachineBuilder<MachineDefinition>, MachineDefinition> builder) {
        return GTMachineUtils.registerSteamMachines(GTRegistration.REGISTRATE, name, factory, builder);
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSteamMachines(GTRegistrate registrate, String name, BiFunction<IMachineBlockEntity, Boolean, MetaMachine> factory, BiFunction<Boolean, MachineBuilder<MachineDefinition>, MachineDefinition> builder) {
        MachineDefinition lowTier = builder.apply(false, registrate.machine("lp_%s".formatted(name), holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, false)).langValue("Low Pressure " + FormattingUtil.toEnglishName(name)).tier(0));
        MachineDefinition highTier = builder.apply(true, registrate.machine("hp_%s".formatted(name), holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, true)).langValue("High Pressure " + FormattingUtil.toEnglishName(name)).tier(1));
        return Pair.of((Object)lowTier, (Object)highTier);
    }

    public static MachineDefinition[] registerFluidHatches(String name, String displayName, String tooltip, IO io, int initialCapacity, int slots, int[] tiers, PartAbility ... abilities) {
        return GTMachineUtils.registerFluidHatches(GTRegistration.REGISTRATE, name, displayName, tooltip, io, initialCapacity, slots, tiers, abilities);
    }

    public static MachineDefinition[] registerFluidHatches(GTRegistrate registrate, String name, String displayName, String tooltip, IO io, int initialCapacity, int slots, int[] tiers, PartAbility ... abilities) {
        String pipeOverlay = slots >= 9 ? "overlay_pipe_9x" : (slots >= 4 ? "overlay_pipe_4x" : null);
        String ioOverlay = io == IO.OUT ? "overlay_pipe_out_emissive" : "overlay_pipe_in_emissive";
        String emissiveOverlay = slots > 4 ? "overlay_fluid_hatch_half_px_out" : "overlay_fluid_hatch";
        return GTMachineUtils.registerTieredMachines(registrate, name, (IMachineBlockEntity holder, Integer tier) -> new FluidHatchPartMachine((IMachineBlockEntity)holder, (int)tier, io, initialCapacity, slots, new Object[0]), (tier, builder) -> {
            builder.langValue(GTValues.VNF[tier] + " " + displayName).rotationState(RotationState.ALL).colorOverlayTieredHullModel(ioOverlay, pipeOverlay, emissiveOverlay).abilities(abilities).tooltips(new Component[]{Component.m_237115_((String)("gtceu.machine." + tooltip + ".tooltip"))}).allowCoverOnFront(true);
            if (slots == 1) {
                builder.tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(FluidHatchPartMachine.getTankCapacity(initialCapacity, tier))})});
            } else {
                builder.tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity_mult", (Object[])new Object[]{slots, FormattingUtil.formatNumbers(FluidHatchPartMachine.getTankCapacity(initialCapacity, tier))})});
            }
            return builder.register();
        }, tiers);
    }

    public static MachineDefinition[] registerTransformerMachines(String langName, int baseAmp) {
        return GTMachineUtils.registerTransformerMachines(GTRegistration.REGISTRATE, langName, baseAmp);
    }

    public static MachineDefinition[] registerTransformerMachines(GTRegistrate registrate, String langName, int baseAmp) {
        return GTMachineUtils.registerTieredMachines(registrate, "transformer_%da".formatted(baseAmp), (IMachineBlockEntity holder, Integer tier) -> new TransformerMachine((IMachineBlockEntity)holder, (int)tier, baseAmp, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).itemColor((itemStack, index) -> switch (index) {
            case 1 -> ConfigHolder.INSTANCE.client.getDefaultPaintingColor();
            case 2 -> GTValues.VC[tier + 1];
            case 3 -> GTValues.VC[tier];
            default -> -1;
        }).modelProperty(GTMachineModelProperties.IS_TRANSFORM_UP, false).model(GTMachineModels.createTransformerModel(baseAmp)).langValue("%s %sTransformer".formatted(GTValues.VCF[tier] + GTValues.VOLTAGE_NAMES[tier] + String.valueOf(ChatFormatting.RESET), langName.isEmpty() ? "" : langName + " ")).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.transformer.description"), Component.m_237115_((String)"gtceu.machine.transformer.tooltip_tool_usage"), Component.m_237110_((String)"gtceu.machine.transformer.tooltip_transform_down", (Object[])new Object[]{baseAmp, FormattingUtil.formatNumbers(GTValues.V[tier + 1]), GTValues.VNF[tier + 1], baseAmp * 4, FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.machine.transformer.tooltip_transform_up", (Object[])new Object[]{baseAmp * 4, FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier], baseAmp, FormattingUtil.formatNumbers(GTValues.V[tier + 1]), GTValues.VNF[tier + 1]})}).register(), GTValues.tiersBetween(0, GTCEuAPI.isHighTier() ? 13 : 8));
    }

    public static MachineDefinition[] registerSimpleGenerator(String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, float hazardStrengthPerOperation, int ... tiers) {
        return GTMachineUtils.registerSimpleGenerator(GTRegistration.REGISTRATE, name, recipeType, tankScalingFunction, hazardStrengthPerOperation, tiers);
    }

    public static MachineDefinition[] registerSimpleGenerator(GTRegistrate registrate, String name, GTRecipeType recipeType, Int2IntFunction tankScalingFunction, float hazardStrengthPerOperation, int ... tiers) {
        return GTMachineUtils.registerTieredMachines(registrate, name, (IMachineBlockEntity holder, Integer tier) -> new SimpleGeneratorMachine((IMachineBlockEntity)holder, (int)tier, hazardStrengthPerOperation * (float)tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s Generator %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(name), GTValues.VLVT[tier])).editableUI(SimpleGeneratorMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id(name), recipeType)).rotationState(RotationState.ALL).recipeType(recipeType).recipeModifier(SimpleGeneratorMachine::recipeModifier, true).addOutputLimit(ItemRecipeCapability.CAP, 0).addOutputLimit(FluidRecipeCapability.CAP, 0).simpleGeneratorModel(GTCEu.id("block/generators/" + name)).tooltips(GTMachineUtils.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, tankScalingFunction.applyAsInt(tier.intValue()), false)).register(), tiers);
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSimpleSteamMachines(String name, GTRecipeType recipeType) {
        return GTMachineUtils.registerSimpleSteamMachines(GTRegistration.REGISTRATE, name, recipeType);
    }

    public static Pair<MachineDefinition, MachineDefinition> registerSimpleSteamMachines(GTRegistrate registrate, String name, GTRecipeType recipeType) {
        return GTMachineUtils.registerSteamMachines(registrate, "steam_" + name, (x$0, x$1) -> new SimpleSteamMachine((IMachineBlockEntity)x$0, (boolean)x$1, new Object[0]), (pressure, builder) -> builder.rotationState(RotationState.ALL).recipeType(recipeType).recipeModifier(SimpleSteamMachine::recipeModifier).modelProperty(GTMachineModelProperties.VENT_DIRECTION, RelativeDirection.BACK).workableSteamHullModel((boolean)pressure, GTCEu.id("block/machines/" + name)).register());
    }

    public static MachineDefinition[] registerBatteryBuffer(int batterySlotSize) {
        return GTMachineUtils.registerBatteryBuffer(GTRegistration.REGISTRATE, batterySlotSize);
    }

    public static MachineDefinition[] registerBatteryBuffer(GTRegistrate registrate, int batterySlotSize) {
        return GTMachineUtils.registerTieredMachines(registrate, "battery_buffer_" + batterySlotSize + "x", (IMachineBlockEntity holder, Integer tier) -> new BatteryBufferMachine((IMachineBlockEntity)holder, (int)tier, batterySlotSize, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).model(GTMachineModels.createBatteryBufferModel(batterySlotSize)).langValue("%s %sx Battery Buffer".formatted(GTValues.VCF[tier] + GTValues.VOLTAGE_NAMES[tier] + String.valueOf(ChatFormatting.RESET), batterySlotSize)).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{batterySlotSize}), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in_till", (Object[])new Object[]{(long)batterySlotSize * 2L}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out_till", (Object[])new Object[]{batterySlotSize})}).register(), ALL_TIERS);
    }

    public static MachineDefinition[] registerCharger(int itemSlotSize) {
        return GTMachineUtils.registerCharger(GTRegistration.REGISTRATE, itemSlotSize);
    }

    public static MachineDefinition[] registerCharger(GTRegistrate registrate, int itemSlotSize) {
        return GTMachineUtils.registerTieredMachines(registrate, "charger_" + itemSlotSize + "x", (IMachineBlockEntity holder, Integer tier) -> new ChargerMachine((IMachineBlockEntity)holder, (int)tier, itemSlotSize, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).modelProperty(GTMachineModelProperties.CHARGER_STATE, ChargerMachine.State.IDLE).model(GTMachineModels.createChargerModel()).langValue("%s %sx Turbo Charger".formatted(GTValues.VCF[tier] + GTValues.VOLTAGE_NAMES[tier] + String.valueOf(ChatFormatting.RESET), itemSlotSize)).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{itemSlotSize}), Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in_out", (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in_till", (Object[])new Object[]{(long)itemSlotSize * 4L})}).register(), ALL_TIERS);
    }

    public static MachineDefinition[] registerConverter(int amperage) {
        return GTMachineUtils.registerConverter(GTRegistration.REGISTRATE, amperage);
    }

    public static MachineDefinition[] registerConverter(GTRegistrate registrate, int amperage) {
        RegistryEntry<CreativeModeTab> tab = registrate.creativeModeTab();
        if (!ConfigHolder.INSTANCE.compat.energy.enableFEConverters) {
            registrate.creativeModeTab(() -> null);
        }
        MachineDefinition[] converters = GTMachineUtils.registerTieredMachines(registrate, amperage + "a_energy_converter", (IMachineBlockEntity holder, Integer tier) -> new ConverterMachine((IMachineBlockEntity)holder, (int)tier, amperage, new Object[0]), (tier, builder) -> builder.rotationState(RotationState.ALL).langValue("%s %s\u00a7eA\u00a7r Energy Converter".formatted(GTValues.VCF[tier] + GTValues.VN[tier] + String.valueOf(ChatFormatting.RESET), amperage)).modelProperty(GTMachineModelProperties.IS_FE_TO_EU, false).model(GTMachineModels.createConverterModel(amperage)).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.energy_converter.description"), Component.m_237115_((String)"gtceu.machine.energy_converter.tooltip_tool_usage"), Component.m_237110_((String)"gtceu.machine.energy_converter.tooltip_conversion_native", (Object[])new Object[]{FeCompat.toFeLong(GTValues.V[tier] * (long)amperage, FeCompat.ratio(true)), amperage, GTValues.V[tier], GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.machine.energy_converter.tooltip_conversion_eu", (Object[])new Object[]{amperage, GTValues.V[tier], GTValues.VNF[tier], FeCompat.toFeLong(GTValues.V[tier] * (long)amperage, FeCompat.ratio(false))})}).register(), ALL_TIERS);
        if (!ConfigHolder.INSTANCE.compat.energy.enableFEConverters) {
            registrate.creativeModeTab(() -> tab);
        }
        return converters;
    }

    public static MachineDefinition[] registerLaserHatch(IO io, int amperage, PartAbility ability) {
        return GTMachineUtils.registerLaserHatch(GTRegistration.REGISTRATE, io, amperage, ability);
    }

    public static MachineDefinition[] registerLaserHatch(GTRegistrate registrate, IO io, int amperage, PartAbility ability) {
        String name = io == IO.IN ? "target" : "source";
        return GTMachineUtils.registerTieredMachines(registrate, amperage + "a_laser_" + name + "_hatch", (IMachineBlockEntity holder, Integer tier) -> new LaserHatchPartMachine((IMachineBlockEntity)holder, io, (int)tier, amperage), (tier, builder) -> builder.langValue(GTValues.VNF[tier] + "\u00a7r " + FormattingUtil.formatNumbers(amperage) + "\u00a7eA\u00a7r Laser " + FormattingUtil.toEnglishName(name) + " Hatch").rotationState(RotationState.ALL).tooltips(new Component[]{Component.m_237115_((String)("gtceu.machine.laser_hatch." + name + ".tooltip")), Component.m_237115_((String)"gtceu.machine.laser_hatch.both.tooltip"), Component.m_237110_((String)("gtceu.universal.tooltip.voltage_" + (io == IO.IN ? "in" : "out")), (Object[])new Object[]{FormattingUtil.formatNumbers(GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_in", (Object[])new Object[]{amperage}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(EnergyHatchPartMachine.getHatchEnergyCapacity(tier, amperage))}), Component.m_237115_((String)"gtceu.part_sharing.disabled")}).abilities(ability).overlayTieredHullModel("laser_" + name + "_hatch").register(), HIGH_TIERS);
    }

    public static MachineDefinition registerCrate(Material material, int capacity, String lang) {
        return GTMachineUtils.registerCrate(GTRegistration.REGISTRATE, material, capacity, lang);
    }

    public static MachineDefinition registerCrate(GTRegistrate registrate, Material material, int capacity, String lang) {
        boolean wooden = material.hasProperty(PropertyKey.WOOD);
        return registrate.machine(material.getName() + "_crate", holder -> new CrateMachine((IMachineBlockEntity)holder, material, capacity)).langValue(lang).rotationState(RotationState.NONE).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{capacity})}).modelProperty(GTMachineModelProperties.IS_TAPED, false).model(GTMachineModels.createCrateModel(wooden)).paintingColor(wooden ? 0xFFFFFF : material.getMaterialRGB()).itemColor((s, t) -> wooden ? 0xFFFFFF : material.getMaterialRGB()).register();
    }

    public static MachineDefinition registerDrum(Material material, int capacity, String lang) {
        return GTMachineUtils.registerDrum(GTRegistration.REGISTRATE, material, capacity, lang);
    }

    public static MachineDefinition registerDrum(GTRegistrate registrate, Material material, int capacity, String lang) {
        boolean wooden = material.hasProperty(PropertyKey.WOOD);
        Object definition = registrate.machine(material.getName() + "_drum", MachineDefinition::new, holder -> new DrumMachine((IMachineBlockEntity)holder, material, capacity, new Object[0]), MetaMachineBlock::new, (holder, prop) -> DrumMachineItem.create(holder, prop, material), MetaMachineBlockEntity::new).langValue(lang).rotationState(RotationState.NONE).simpleModel(GTCEu.id("block/machine/template/drum/" + (wooden ? "wooden" : "metal") + "_drum")).tooltipBuilder((stack, list) -> {
            TANK_TOOLTIPS.accept((ItemStack)stack, (List<Component>)list);
            if (material.hasProperty(PropertyKey.FLUID_PIPE)) {
                FluidPipeProperties pipeprops = material.getProperty(PropertyKey.FLUID_PIPE);
                pipeprops.appendTooltips((List<Component>)list, false, true);
            }
        }).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(capacity)})}).paintingColor(wooden ? 0xFFFFFF : material.getMaterialRGB()).itemColor((s, i) -> wooden ? 0xFFFFFF : material.getMaterialRGB()).register();
        DRUM_CAPACITY.put(definition, capacity);
        return definition;
    }

    public static MachineDefinition[] registerQuantumTanks(String name, int ... tiers) {
        return GTMachineUtils.registerQuantumTanks(GTRegistration.REGISTRATE, name, tiers);
    }

    public static MachineDefinition[] registerQuantumTanks(GTRegistrate registrate, String name, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            long maxAmount = 4000000L * (long)Math.pow(2.0, tier - 1);
            Object register = registrate.machine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, MachineDefinition::new, holder -> new QuantumTankMachine((IMachineBlockEntity)holder, tier, maxAmount, new Object[0]), MetaMachineBlock::new, QuantumTankMachineItem::new, MetaMachineBlockEntity::new).langValue(FormattingUtil.toEnglishName(name) + " " + GTValues.LVT[tier]).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).rotationState(RotationState.ALL).allowExtendedFacing(true).model(GTMachineModels.createTieredHullMachineModel(GTCEu.id("block/machine/template/quantum/quantum_tank")).andThen(b -> b.addDynamicRenderer(DynamicRenderHelper::createQuantumTankRender))).hasBER(true).tooltipBuilder(TANK_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(maxAmount)})}).tier(tier).register();
            QuantumTankMachine.TANK_CAPACITY.put(register, maxAmount);
            definitions[tier] = register;
        }
        return definitions;
    }

    public static MachineDefinition[] registerQuantumChests(String name, int ... tiers) {
        return GTMachineUtils.registerQuantumChests(GTRegistration.REGISTRATE, name, tiers);
    }

    public static MachineDefinition[] registerQuantumChests(GTRegistrate registrate, String name, int ... tiers) {
        return GTMachineUtils.registerTieredMachines(registrate, name, (IMachineBlockEntity holder, Integer tier) -> new QuantumChestMachine((IMachineBlockEntity)holder, (int)tier, tier == 14 ? Long.MAX_VALUE : 4000000L * (long)Math.pow(2.0, tier - 1), new Object[0]), (tier, builder) -> builder.langValue(FormattingUtil.toEnglishName(name) + " " + GTValues.LVT[tier]).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).rotationState(RotationState.ALL).allowExtendedFacing(true).model(GTMachineModels.createTieredHullMachineModel(GTCEu.id("block/machine/template/quantum/quantum_chest")).andThen(b -> b.addDynamicRenderer(DynamicRenderHelper::createQuantumChestRender))).hasBER(true).tooltipBuilder(CHEST_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_chest.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_total", (Object[])new Object[]{FormattingUtil.formatNumbers(tier == 14 ? Long.MAX_VALUE : 4000000L * (long)Math.pow(2.0, tier - 1))})}).register(), tiers);
    }

    public static MultiblockMachineDefinition registerMultiblockTank(String name, String displayName, int capacity, Supplier<? extends Block> casing, Supplier<? extends Block> valve, @Nullable PropertyFluidFilter filter, BiConsumer<MultiblockMachineBuilder, ResourceLocation> rendererSetup) {
        return GTMachineUtils.registerMultiblockTank(GTRegistration.REGISTRATE, name, displayName, capacity, casing, valve, filter, rendererSetup);
    }

    public static MultiblockMachineDefinition registerMultiblockTank(GTRegistrate registrate, String name, String displayName, int capacity, Supplier<? extends Block> casing, Supplier<? extends Block> valve, @Nullable PropertyFluidFilter filter, BiConsumer<MultiblockMachineBuilder, ResourceLocation> rendererSetup) {
        MachineBuilder builder = registrate.multiblock(name, holder -> new MultiblockTankMachine((IMachineBlockEntity)holder, capacity, filter, new Object[0])).langValue(displayName).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.multiblock.tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{capacity}), filter != null ? Component.m_237110_((String)"gtceu.fluid_pipe.max_temperature", (Object[])new Object[]{filter.getMaxFluidTemperature()}) : null}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.DUMMY_RECIPES).pattern(definition -> FactoryBlockPattern.start().aisle("CCC", "CCC", "CCC").aisle("CCC", "C#C", "CCC").aisle("CCC", "CSC", "CCC").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('C', Predicates.blocks((Block)casing.get()).or(Predicates.blocks((Block)valve.get()).setMaxGlobalLimited(2, 0))).where('#', Predicates.air()).build()).appearanceBlock((Supplier)casing);
        rendererSetup.accept((MultiblockMachineBuilder)builder, GTCEu.id("block/multiblock/multiblock_tank"));
        return ((MultiblockMachineBuilder)builder).register();
    }

    public static MachineDefinition registerTankValve(String name, String displayName, boolean isMetal, BiConsumer<MachineBuilder<?>, ResourceLocation> rendererSetup) {
        return GTMachineUtils.registerTankValve(GTRegistration.REGISTRATE, name, displayName, isMetal, rendererSetup);
    }

    public static MachineDefinition registerTankValve(GTRegistrate registrate, String name, String displayName, boolean isMetal, BiConsumer<MachineBuilder<?>, ResourceLocation> rendererSetup) {
        MachineBuilder<MachineDefinition> builder = registrate.machine(name, holder -> new TankValvePartMachine((IMachineBlockEntity)holder, isMetal, new Object[0])).langValue(displayName).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.tank_valve.tooltip"), Component.m_237115_((String)"gtceu.part_sharing.disabled")}).rotationState(RotationState.ALL);
        rendererSetup.accept(builder, GTCEu.id("block/multiblock/tank_valve"));
        return builder.register();
    }

    public static MultiblockMachineDefinition[] registerTieredMultis(String name, BiFunction<IMachineBlockEntity, Integer, MultiblockControllerMachine> factory, BiFunction<Integer, MultiblockMachineBuilder, MultiblockMachineDefinition> builder, int ... tiers) {
        return GTMachineUtils.registerTieredMultis(GTRegistration.REGISTRATE, name, factory, builder, tiers);
    }

    public static MultiblockMachineDefinition[] registerTieredMultis(GTRegistrate registrate, String name, BiFunction<IMachineBlockEntity, Integer, MultiblockControllerMachine> factory, BiFunction<Integer, MultiblockMachineBuilder, MultiblockMachineDefinition> builder, int ... tiers) {
        MultiblockMachineDefinition[] definitions = new MultiblockMachineDefinition[GTValues.TIER_COUNT];
        for (int tier : tiers) {
            MultiblockMachineBuilder register = registrate.multiblock(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MultiblockControllerMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[tier] = builder.apply(tier, register);
        }
        return definitions;
    }

    public static MultiblockMachineDefinition registerLargeBoiler(String name, Supplier<? extends Block> casing, Supplier<? extends Block> pipe, Supplier<? extends Block> fireBox, ResourceLocation texture, BoilerFireboxType firebox, int maxTemperature, int heatSpeed) {
        return GTMachineUtils.registerLargeBoiler(GTRegistration.REGISTRATE, name, casing, pipe, fireBox, texture, firebox, maxTemperature, heatSpeed);
    }

    public static MultiblockMachineDefinition registerLargeBoiler(GTRegistrate registrate, String name, Supplier<? extends Block> casing, Supplier<? extends Block> pipe, Supplier<? extends Block> fireBox, ResourceLocation texture, BoilerFireboxType firebox, int maxTemperature, int heatSpeed) {
        return ((MultiblockMachineBuilder)((MultiblockMachineBuilder)registrate.multiblock("%s_large_boiler".formatted(name), holder -> new LargeBoilerMachine((IMachineBlockEntity)holder, maxTemperature, heatSpeed, new Object[0])).langValue("Large %s Boiler".formatted(FormattingUtil.toEnglishName(name))).allowExtendedFacing(false).rotationState(RotationState.NON_Y_AXIS).recipeType(GTRecipeTypes.LARGE_BOILER_RECIPES).recipeModifier(LargeBoilerMachine::recipeModifier, true).appearanceBlock((Supplier)casing)).partAppearance((TriFunction<IMultiController, IMultiPart, Direction, BlockState>)((TriFunction)(controller, part, side) -> controller.self().getPos().m_7495_().m_123342_() == part.self().getPos().m_123342_() ? ((Block)fireBox.get()).m_49966_() : ((Block)casing.get()).m_49966_())).pattern(definition -> {
            TraceabilityPredicate fireboxPred = Predicates.blocks((Block)GTBlocks.ALL_FIREBOXES.get(firebox).get()).setMinGlobalLimited(3).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMinGlobalLimited(1).setPreviewCount(1)).or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setMaxGlobalLimited(1).setPreviewCount(1)).or(Predicates.abilities(PartAbility.MUFFLER).setExactLimit(1));
            if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
                fireboxPred = fireboxPred.or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1));
            }
            return FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "CCC").aisle("XXX", "CPC", "CPC", "CCC").aisle("XXX", "CSC", "CCC", "CCC").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('P', Predicates.blocks((Block)pipe.get())).where('X', fireboxPred).where('C', Predicates.blocks((Block)casing.get()).setMinGlobalLimited(20).or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setMinGlobalLimited(1).setPreviewCount(1))).build();
        }).recoveryItems(() -> new ItemLike[]{(ItemLike)((ItemEntry)GTMaterialItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE))).model(GTMachineModels.createWorkableCasingMachineModel(texture, GTCEu.id("block/multiblock/generator/large_%s_boiler".formatted(name))).andThen(b -> b.addDynamicRenderer(() -> GTMachineUtils.lambda$registerLargeBoiler$48(firebox, (Supplier)casing)))).tooltips(new Component[]{Component.m_237110_((String)"gtceu.multiblock.large_boiler.max_temperature", (Object[])new Object[]{maxTemperature + 274, maxTemperature}), Component.m_237110_((String)"gtceu.multiblock.large_boiler.heat_time_tooltip", (Object[])new Object[]{maxTemperature / heatSpeed / 20}), Component.m_237115_((String)"gtceu.multiblock.large_boiler.explosion_tooltip").m_130940_(ChatFormatting.DARK_RED)}).register();
    }

    public static MultiblockMachineDefinition registerLargeCombustionEngine(String name, int tier, Supplier<? extends Block> casing, Supplier<? extends Block> gear, Supplier<? extends Block> intake, ResourceLocation casingTexture, ResourceLocation overlayModel) {
        return GTMachineUtils.registerLargeCombustionEngine(GTRegistration.REGISTRATE, name, tier, casing, gear, intake, casingTexture, overlayModel);
    }

    public static MultiblockMachineDefinition registerLargeCombustionEngine(GTRegistrate registrate, String name, int tier, Supplier<? extends Block> casing, Supplier<? extends Block> gear, Supplier<? extends Block> intake, ResourceLocation casingTexture, ResourceLocation overlayModel) {
        return ((MultiblockMachineBuilder)registrate.multiblock(name, holder -> new LargeCombustionEngineMachine((IMachineBlockEntity)holder, tier)).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.COMBUSTION_GENERATOR_FUELS).generator(true).recipeModifier(LargeCombustionEngineMachine::recipeModifier, true).appearanceBlock((Supplier)casing)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XDX", "XXX").aisle("XCX", "CGC", "XCX").aisle("XCX", "CGC", "XCX").aisle("AAA", "AYA", "AAA").where('X', Predicates.blocks((Block)casing.get())).where('G', Predicates.blocks((Block)gear.get())).where('C', Predicates.blocks((Block)casing.get()).setMinGlobalLimited(3).or(Predicates.autoAbilities(definition.getRecipeTypes(), false, false, true, true, true, true)).or(Predicates.autoAbilities(true, true, false))).where('D', Predicates.ability(PartAbility.OUTPUT_ENERGY, IntStream.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9).filter(t -> t >= tier).toArray()).addTooltips(new Component[]{Component.m_237110_((String)"gtceu.multiblock.pattern.error.limited.1", (Object[])new Object[]{GTValues.VN[tier]})})).where('A', Predicates.blocks((Block)intake.get()).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.clear_amount_1")})).where('Y', Predicates.controller(Predicates.blocks(definition.getBlock()))).build()).recoveryItems(() -> new ItemLike[]{(ItemLike)((ItemEntry)GTMaterialItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).workableCasingModel(casingTexture, overlayModel).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.uses_per_hour_lubricant", (Object[])new Object[]{1000}), tier > 4 ? Component.m_237110_((String)"gtceu.machine.large_combustion_engine.tooltip.boost_extreme", (Object[])new Object[]{GTValues.V[tier] * 4L}) : Component.m_237110_((String)"gtceu.machine.large_combustion_engine.tooltip.boost_regular", (Object[])new Object[]{GTValues.V[tier] * 3L})}).register();
    }

    public static MultiblockMachineDefinition registerLargeTurbine(String name, int tier, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, ResourceLocation casingTexture, ResourceLocation overlayModel) {
        return GTMachineUtils.registerLargeTurbine(GTRegistration.REGISTRATE, name, tier, recipeType, casing, gear, casingTexture, overlayModel);
    }

    public static MultiblockMachineDefinition registerLargeTurbine(GTRegistrate registrate, String name, int tier, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, ResourceLocation casingTexture, ResourceLocation overlayModel) {
        return GTMachineUtils.registerLargeTurbine(registrate, name, tier, recipeType, casing, gear, casingTexture, overlayModel, true);
    }

    public static MultiblockMachineDefinition registerLargeTurbine(String name, int tier, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, ResourceLocation casingTexture, ResourceLocation overlayModel, boolean needsMuffler) {
        return GTMachineUtils.registerLargeTurbine(GTRegistration.REGISTRATE, name, tier, recipeType, casing, gear, casingTexture, overlayModel, needsMuffler);
    }

    public static MultiblockMachineDefinition registerLargeTurbine(GTRegistrate registrate, String name, int tier, GTRecipeType recipeType, Supplier<? extends Block> casing, Supplier<? extends Block> gear, ResourceLocation casingTexture, ResourceLocation overlayModel, boolean needsMuffler) {
        return ((MultiblockMachineBuilder)registrate.multiblock(name, holder -> new LargeTurbineMachine((IMachineBlockEntity)holder, tier)).rotationState(RotationState.ALL).recipeType(recipeType).generator(true).recipeModifier(LargeTurbineMachine::recipeModifier, true).appearanceBlock((Supplier)casing)).pattern(definition -> FactoryBlockPattern.start().aisle("CCCC", "CHHC", "CCCC").aisle("CHHC", "RGGR", "CHHC").aisle("CCCC", "CSHC", "CCCC").where('S', Predicates.controller(Predicates.blocks(definition.getBlock()))).where('G', Predicates.blocks((Block)gear.get())).where('C', Predicates.blocks((Block)casing.get())).where('R', new TraceabilityPredicate(new SimplePredicate(state -> {
            MetaMachine patt55536$temp = MetaMachine.getMachine((BlockGetter)state.getWorld(), state.getPos());
            if (!(patt55536$temp instanceof IRotorHolderMachine)) return false;
            IRotorHolderMachine rotorHolder = (IRotorHolderMachine)((Object)patt55536$temp);
            if (!state.getWorld().m_8055_(state.getPos().m_121945_(rotorHolder.self().getFrontFacing())).m_60795_()) return false;
            return true;
        }, () -> (BlockInfo[])PartAbility.ROTOR_HOLDER.getAllBlocks().stream().map(BlockInfo::fromBlock).toArray(BlockInfo[]::new))).addTooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.pattern.clear_amount_3")}).addTooltips(new Component[]{Component.m_237110_((String)"gtceu.multiblock.pattern.error.limited.1", (Object[])new Object[]{GTValues.VN[tier]})}).setExactLimit(1).or(Predicates.abilities(PartAbility.OUTPUT_ENERGY)).setExactLimit(1)).where('H', Predicates.blocks((Block)casing.get()).or(Predicates.autoAbilities(definition.getRecipeTypes(), false, false, true, true, true, true)).or(Predicates.autoAbilities(true, needsMuffler, false))).build()).recoveryItems(() -> new ItemLike[]{(ItemLike)((ItemEntry)GTMaterialItems.MATERIAL_ITEMS.get((Object)TagPrefix.dustTiny, (Object)GTMaterials.Ash)).get()}).workableCasingModel(casingTexture, overlayModel).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[tier] * 2L}), Component.m_237110_((String)"gtceu.multiblock.turbine.efficiency_tooltip", (Object[])new Object[]{GTValues.VNF[tier]})}).register();
    }

    public static Component explosion() {
        if (ConfigHolder.INSTANCE.machines.shouldWeatherOrTerrainExplosion) {
            return Component.m_237115_((String)"gtceu.universal.tooltip.terrain_resist");
        }
        return null;
    }

    public static Component environmentRequirement(MedicalCondition condition) {
        return Component.m_237110_((String)"gtceu.recipe.environmental_hazard.reverse", (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + condition.name))});
    }

    public static Component defaultEnvironmentRequirement() {
        return GTMachineUtils.environmentRequirement(GTMedicalConditions.CARBON_MONOXIDE_POISONING);
    }

    public static Component[] workableTiered(int tier, long voltage, long energyCapacity, GTRecipeType recipeType, long tankCapacity, boolean input) {
        ArrayList<MutableComponent> tooltipComponents = new ArrayList<MutableComponent>();
        tooltipComponents.add(input ? Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers(voltage), GTValues.VNF[tier]}) : Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{FormattingUtil.formatNumbers(voltage), GTValues.VNF[tier]}));
        tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(energyCapacity)}));
        if (recipeType.getMaxInputs(FluidRecipeCapability.CAP) > 0 || recipeType.getMaxOutputs(FluidRecipeCapability.CAP) > 0) {
            tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers(tankCapacity)}));
        }
        return (Component[])tooltipComponents.toArray(Component[]::new);
    }

    public static void init() {
    }

    private static /* synthetic */ DynamicRender lambda$registerLargeBoiler$48(BoilerFireboxType firebox, Supplier casing) {
        return DynamicRenderHelper.makeBoilerPartRender(firebox, casing);
    }
}

