/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HarvestCropsBehavior
implements IToolBehavior {
    public static final HarvestCropsBehavior INSTANCE = new HarvestCropsBehavior();

    protected HarvestCropsBehavior() {
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        List<BlockPos> blocks;
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (aoeDefinition.isZero()) {
            blocks = List.of(pos);
        } else {
            blocks = ToolHelper.iterateAoE(aoeDefinition, HarvestCropsBehavior::isBlockCrops, context);
            if (HarvestCropsBehavior.isBlockCrops(context)) {
                blocks.add(0, context.m_8083_());
            }
        }
        boolean harvested = false;
        for (BlockPos blockPos : blocks) {
            harvested |= HarvestCropsBehavior.harvestBlockRoutine(blockPos, context);
            if (!stack.m_41619_()) continue;
            break;
        }
        return harvested ? InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_) : InteractionResult.PASS;
    }

    private static boolean isBlockCrops(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        if (level.m_8055_((pos = context.m_8083_()).m_7494_()).m_60795_()) {
            Block block = level.m_8055_(pos).m_60734_();
            return block instanceof CropBlock;
        }
        return false;
    }

    private static boolean harvestBlockRoutine(BlockPos pos, UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!(block instanceof CropBlock)) {
            return false;
        }
        CropBlock cropBlock = (CropBlock)block;
        ItemStack seed = blockState.getCloneItemStack((HitResult)context.m_43718_().m_82430_(pos), (BlockGetter)level, pos, player);
        if (cropBlock.m_52307_(blockState)) {
            if (!level.f_46443_) {
                List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, null);
                boolean removedSeed = false;
                for (ItemStack drop : drops) {
                    if (!removedSeed && ItemStack.m_150942_((ItemStack)drop, (ItemStack)seed)) {
                        drop.m_41774_(1);
                        removedSeed = true;
                        if (drop.m_41619_()) continue;
                    }
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop);
                }
            }
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
            level.m_7731_(pos, cropBlock.m_52289_(0), 11);
            ToolHelper.damageItem(stack, (LivingEntity)player);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.gtceu.tool.behavior.crop_harvesting"));
    }
}

