/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssemblyLineMachine
extends WorkableElectricMultiblockMachine {
    @Persisted
    protected boolean allowCircuitSlots;

    public AssemblyLineMachine(IMachineBlockEntity holder, boolean allowCircuitSlots) {
        super(holder, new Object[0]);
        this.allowCircuitSlots = allowCircuitSlots;
    }

    public AssemblyLineMachine(IMachineBlockEntity holder) {
        this(holder, false);
    }

    @Override
    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        if (!super.beforeWorking(recipe)) {
            return false;
        }
        ConfigHolder.MachineConfigs config = ConfigHolder.INSTANCE.machines;
        if (!config.orderedAssemblyLineItems && !config.orderedAssemblyLineFluids) {
            return true;
        }
        if (!this.checkItemInputs(recipe)) {
            return false;
        }
        if (!config.orderedAssemblyLineFluids) {
            return true;
        }
        return this.checkFluidInputs(recipe);
    }

    public static Comparator<IMultiPart> partSorter(MultiblockControllerMachine mc) {
        return Comparator.comparing(p -> p.self().getPos(), RelativeDirection.RIGHT.getSorter(mc.getFrontFacing(), mc.getUpwardsFacing(), mc.isFlipped()));
    }

    private boolean checkItemInputs(@NotNull GTRecipe recipe) {
        List itemInputs = recipe.inputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList());
        if (itemInputs.isEmpty()) {
            return true;
        }
        int inputsSize = itemInputs.size();
        List itemHandlers = this.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP);
        if (itemHandlers.size() < inputsSize) {
            return false;
        }
        List<ItemStack> itemInventory = itemHandlers.stream().filter(IRecipeHandler::shouldSearchContent).map(container -> container.getContents().stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).filter(s -> !s.m_41619_()).findFirst()).dropWhile(Optional::isEmpty).limit(inputsSize).map(o -> o.orElse(ItemStack.f_41583_)).toList();
        if (itemInventory.size() < inputsSize) {
            return false;
        }
        for (int i = 0; i < inputsSize; ++i) {
            ItemStack itemStack = itemInventory.get(i);
            Ingredient recipeStack = (Ingredient)ItemRecipeCapability.CAP.of(((Content)itemInputs.get((int)i)).content);
            if (recipeStack.test(itemStack)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFluidInputs(@NotNull GTRecipe recipe) {
        List fluidInputs = recipe.inputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList());
        if (fluidInputs.isEmpty()) {
            return true;
        }
        int inputsSize = fluidInputs.size();
        List fluidHandlers = this.getCapabilitiesFlat(IO.IN, FluidRecipeCapability.CAP);
        if (fluidHandlers.size() < inputsSize) {
            return false;
        }
        List<FluidStack> fluidInventory = fluidHandlers.stream().filter(IRecipeHandler::shouldSearchContent).map(container -> container.getContents().stream().filter(FluidStack.class::isInstance).map(FluidStack.class::cast).filter(f -> !f.isEmpty()).findFirst()).dropWhile(Optional::isEmpty).limit(inputsSize).map(o -> o.orElse(FluidStack.EMPTY)).toList();
        if (fluidInventory.size() < inputsSize) {
            return false;
        }
        for (int i = 0; i < inputsSize; ++i) {
            FluidStack fluidStack = fluidInventory.get(i);
            FluidIngredient recipeStack = (FluidIngredient)FluidRecipeCapability.CAP.of(((Content)fluidInputs.get((int)i)).content);
            if (recipeStack.test(fluidStack) && recipeStack.getAmount() <= fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Generated
    public boolean allowCircuitSlots() {
        return this.allowCircuitSlots;
    }
}

