/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.FluidVeinWorldEntry;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FluidDrillMachine;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import lombok.Generated;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FluidDrillLogic
extends RecipeLogic {
    public static final int MAX_PROGRESS = 20;
    @Nullable
    private Fluid veinFluid;

    public FluidDrillLogic(FluidDrillMachine machine) {
        super(machine);
    }

    @Override
    public FluidDrillMachine getMachine() {
        return (FluidDrillMachine)super.getMachine();
    }

    @Override
    public void findAndHandleRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            GTRecipe match;
            ServerLevel serverLevel = (ServerLevel)level;
            this.lastRecipe = null;
            BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
            if (this.veinFluid == null) {
                this.veinFluid = data.getFluidInChunk(this.getChunkX(), this.getChunkZ());
                if (this.veinFluid == null) {
                    if (this.subscription != null) {
                        this.subscription.unsubscribe();
                        this.subscription = null;
                    }
                    return;
                }
            }
            if ((match = this.getFluidDrillRecipe()) != null && RecipeHelper.matchContents(this.machine, match).isSuccess()) {
                this.setupRecipe(match);
            }
        }
    }

    @Nullable
    private GTRecipe getFluidDrillRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.veinFluid != null) {
                BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
                GTRecipe recipe = GTRecipeBuilder.ofRaw().duration(20).EUt(GTValues.VA[this.getMachine().getEnergyTier()]).outputFluids(new FluidStack(this.veinFluid, this.getFluidToProduce(data.getFluidVeinWorldEntry(this.getChunkX(), this.getChunkZ())))).buildRawRecipe();
                if (RecipeHelper.matchContents(this.getMachine(), recipe).isSuccess()) {
                    return recipe;
                }
            }
        }
        return null;
    }

    public int getFluidToProduce() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.veinFluid != null) {
                BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
                return this.getFluidToProduce(data.getFluidVeinWorldEntry(this.getChunkX(), this.getChunkZ()));
            }
        }
        return 0;
    }

    private int getFluidToProduce(FluidVeinWorldEntry entry) {
        BedrockFluidDefinition definition = entry.getDefinition();
        if (definition != null) {
            int depletedYield = definition.getDepletedYield();
            int regularYield = entry.getFluidYield();
            int remainingOperations = entry.getOperationsRemaining();
            int produced = Math.max(depletedYield, regularYield * remainingOperations / 100000);
            produced *= FluidDrillMachine.getRigMultiplier(this.getMachine().getTier());
            if (this.isOverclocked()) {
                produced = produced * 3 / 2;
            }
            return produced;
        }
        return 0;
    }

    @Override
    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            RecipeHelper.handleRecipeIO(this.machine, this.lastRecipe, IO.OUT, this.chanceCaches);
        }
        this.depleteVein();
        GTRecipe match = this.getFluidDrillRecipe();
        if (match != null && RecipeHelper.matchContents(this.machine, match).isSuccess()) {
            this.setupRecipe(match);
            return;
        }
        if (this.suspendAfterFinish) {
            this.setStatus(RecipeLogic.Status.SUSPEND);
            this.suspendAfterFinish = false;
        } else {
            this.setStatus(RecipeLogic.Status.IDLE);
        }
        this.progress = 0;
        this.duration = 0;
    }

    protected void depleteVein() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int chance = FluidDrillMachine.getDepletionChance(this.getMachine().getTier());
            BedrockFluidVeinSavedData data = BedrockFluidVeinSavedData.getOrCreate(serverLevel);
            if (chance == 1 || GTValues.RNG.m_188503_(chance) == 0) {
                data.depleteVein(this.getChunkX(), this.getChunkZ(), 0, false);
            }
        }
    }

    protected boolean isOverclocked() {
        return this.getMachine().getEnergyTier() > this.getMachine().getTier();
    }

    private int getChunkX() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123341_());
    }

    private int getChunkZ() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123343_());
    }

    @Nullable
    @Generated
    public Fluid getVeinFluid() {
        return this.veinFluid;
    }
}

