/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.pipenet.IRoutePath;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRoutePath
implements IRoutePath<IItemHandler> {
    private final ItemPipeBlockEntity targetPipe;
    @NotNull
    private final Direction targetFacing;
    private final int distance;
    private final ItemPipeProperties properties;
    private final Predicate<ItemStack> filters;

    public ItemRoutePath(ItemPipeBlockEntity targetPipe, @NotNull Direction facing, int distance, ItemPipeProperties properties, List<Predicate<ItemStack>> filters) {
        this.targetPipe = targetPipe;
        this.targetFacing = facing;
        this.distance = distance;
        this.properties = properties;
        this.filters = stack -> {
            for (Predicate filter : filters) {
                if (filter.test(stack)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    @NotNull
    public BlockPos getTargetPipePos() {
        return this.targetPipe.getPipePos();
    }

    @Override
    @Nullable
    public IItemHandler getHandler(Level world) {
        return GTTransferUtils.getAdjacentItemHandler(world, this.getTargetPipePos(), this.targetFacing).resolve().orElse(null);
    }

    public boolean matchesFilters(ItemStack stack) {
        return this.filters.test(stack);
    }

    public FacingPos toFacingPos() {
        return new FacingPos(this.getTargetPipePos(), this.targetFacing);
    }

    @Generated
    public ItemPipeBlockEntity getTargetPipe() {
        return this.targetPipe;
    }

    @Override
    @NotNull
    @Generated
    public Direction getTargetFacing() {
        return this.targetFacing;
    }

    @Override
    @Generated
    public int getDistance() {
        return this.distance;
    }

    @Generated
    public ItemPipeProperties getProperties() {
        return this.properties;
    }
}

