/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.common.machine.owner.FTBOwner;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class FTBQuestCondition
extends RecipeCondition {
    private static final Long2ObjectMap<QuestObject> QUEST_CACHE = new Long2ObjectOpenHashMap();
    public static final Codec<FTBQuestCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)Codec.LONG.fieldOf("questId").forGetter(val -> val.parsedQuestId)).apply((Applicative)instance, FTBQuestCondition::new));
    public static final FTBQuestCondition INSTANCE = new FTBQuestCondition();
    private long parsedQuestId;

    public FTBQuestCondition(long questId) {
        this.parsedQuestId = questId;
    }

    public FTBQuestCondition(boolean isReverse, long questId) {
        super(isReverse);
        this.parsedQuestId = questId;
    }

    private QuestObject getQuest() {
        return (QuestObject)QUEST_CACHE.computeIfAbsent(this.parsedQuestId, id -> FTBQuestsAPI.api().getQuestFile(false).get(id));
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.FTB_QUEST;
    }

    @Override
    public Component getTooltips() {
        Component questTitle = this.getQuest().getTitle();
        if (this.isReverse) {
            return Component.m_237110_((String)"recipe.condition.quest.not_completed.tooltip", (Object[])new Object[]{questTitle});
        }
        return Component.m_237110_((String)"recipe.condition.quest.completed.tooltip", (Object[])new Object[]{questTitle});
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        MachineOwner owner = recipeLogic.machine.self().getOwner();
        if (!(owner instanceof FTBOwner)) {
            return false;
        }
        FTBOwner ftbOwner = (FTBOwner)owner;
        if (ftbOwner.getTeam() == null) {
            return false;
        }
        BaseQuestFile questFile = FTBQuestsAPI.api().getQuestFile(false);
        return questFile.getOrCreateTeamData(ftbOwner.getTeam()).isCompleted(this.getQuest());
    }

    @Override
    public RecipeCondition createTemplate() {
        return new FTBQuestCondition();
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject obj = super.serialize();
        obj.addProperty("questId", (Number)this.parsedQuestId);
        return obj;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.parsedQuestId = GsonHelper.m_13921_((JsonObject)config, (String)"questId");
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.parsedQuestId = buf.readLong();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeLong(this.parsedQuestId);
    }

    @Generated
    public FTBQuestCondition() {
    }
}

