/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.serialized.chemistry;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;

public class TitaniumRecipes {
    private TitaniumRecipes() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        TitaniumRecipes.titaniumProcess(provider);
        TitaniumRecipes.solvayProcess(provider);
        TitaniumRecipes.bauxiteProcess(provider);
        TitaniumRecipes.ilmeniteProcess(provider);
    }

    private static void titaniumProcess(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("rutile_from_ilmenite").inputItems(TagPrefix.dust, GTMaterials.Ilmenite, 5).inputItems(TagPrefix.dust, GTMaterials.Carbon).outputItems(TagPrefix.ingot, GTMaterials.WroughtIron).outputItems(TagPrefix.dust, GTMaterials.Rutile, 3).outputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).blastFurnaceTemp(1700).duration(1600).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.CHEMICAL_RECIPES.recipeBuilder("titanium_tetrachloride").inputItems(TagPrefix.dust, GTMaterials.Carbon, 2).inputItems(TagPrefix.dust, GTMaterials.Rutile).inputFluids(GTMaterials.Chlorine.getFluid(4000)).outputFluids(GTMaterials.CarbonMonoxide.getFluid(2000)).outputFluids(GTMaterials.TitaniumTetrachloride.getFluid(1000)).duration(400).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("titanium_from_tetrachloride").inputItems(TagPrefix.dust, GTMaterials.Magnesium, 2).inputFluids(GTMaterials.TitaniumTetrachloride.getFluid(1000)).outputItems(TagPrefix.ingotHot, GTMaterials.Titanium).outputItems(TagPrefix.dust, GTMaterials.MagnesiumChloride, 6).blastFurnaceTemp(GTMaterials.Titanium.getBlastTemperature() + 200).duration(800).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.CHEMICAL_RECIPES.recipeBuilder("salt_from_magnesium_chloride").inputItems(TagPrefix.dust, GTMaterials.MagnesiumChloride, 3).inputItems(TagPrefix.dust, GTMaterials.Sodium, 2).outputItems(TagPrefix.dust, GTMaterials.Magnesium, 1).outputItems(TagPrefix.dust, GTMaterials.Salt, 4).duration(200).EUt(GTValues.VA[3]).save(provider);
    }

    private static void solvayProcess(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.CHEMICAL_RECIPES.recipeBuilder("quicklime_from_calcite").circuitMeta(1).inputItems(TagPrefix.dust, GTMaterials.Calcite, 5).outputItems(TagPrefix.dust, GTMaterials.Quicklime, 2).outputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).duration(200).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.CHEMICAL_RECIPES.recipeBuilder("sodium_bicarbonate_from_salt").inputItems(TagPrefix.dust, GTMaterials.Salt, 4).inputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).inputFluids(GTMaterials.Ammonia.getFluid(1000)).inputFluids(GTMaterials.Water.getFluid(1000)).outputItems(TagPrefix.dust, GTMaterials.AmmoniumChloride, 2).outputItems(TagPrefix.dust, GTMaterials.SodiumBicarbonate, 6).duration(400).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.ELECTROLYZER_RECIPES.recipeBuilder("soda_ash_from_bicarbonate").inputItems(TagPrefix.dust, GTMaterials.SodiumBicarbonate, 12).outputItems(TagPrefix.dust, GTMaterials.SodaAsh, 6).outputFluids(GTMaterials.CarbonDioxide.getFluid(1000)).outputFluids(GTMaterials.Water.getFluid(1000)).duration(200).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.CHEMICAL_RECIPES.recipeBuilder("calcium_chloride_from_quicklime").inputItems(TagPrefix.dust, GTMaterials.AmmoniumChloride, 4).inputItems(TagPrefix.dust, GTMaterials.Quicklime, 2).outputItems(TagPrefix.dust, GTMaterials.CalciumChloride, 3).outputFluids(GTMaterials.Ammonia.getFluid(2000)).outputFluids(GTMaterials.Water.getFluid(1000)).duration(200).EUt(GTValues.VA[2]).save(provider);
    }

    private static void bauxiteProcess(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("bauxite_slurry_from_crushed_bauxite").inputItems(TagPrefix.crushed, GTMaterials.Bauxite, 32).inputItems(TagPrefix.dust, GTMaterials.SodaAsh, 12).inputItems(TagPrefix.dust, GTMaterials.CalciumChloride, 6).inputFluids(GTMaterials.Water.getFluid(1000)).outputFluids(GTMaterials.BauxiteSlurry.getFluid(4000)).duration(500).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("bauxite_slurry_from_washed_bauxite").inputItems(TagPrefix.crushedPurified, GTMaterials.Bauxite, 32).inputItems(TagPrefix.dust, GTMaterials.SodaAsh, 12).inputItems(TagPrefix.dust, GTMaterials.CalciumChloride, 6).inputFluids(GTMaterials.Water.getFluid(1000)).outputFluids(GTMaterials.BauxiteSlurry.getFluid(4000)).duration(500).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.CRACKING_RECIPES.recipeBuilder("cracked_bauxite_slurry").circuitMeta(1).inputFluids(GTMaterials.BauxiteSlurry.getFluid(16000)).inputFluids(GTMaterials.Steam.getFluid(1000)).outputFluids(GTMaterials.CrackedBauxiteSlurry.getFluid(16000)).duration(500).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.LARGE_CHEMICAL_RECIPES.recipeBuilder("bauxite_sludge_from_slurry").inputFluids(GTMaterials.CrackedBauxiteSlurry.getFluid(4000)).inputFluids(GTMaterials.SulfuricAcid.getFluid(1000)).outputItems(TagPrefix.dust, GTMaterials.Aluminium, 24).outputItems(TagPrefix.dust, GTMaterials.BauxiteSlag, 8).outputFluids(GTMaterials.BauxiteSludge.getFluid(2500)).outputFluids(GTMaterials.SulfurTrioxide.getFluid(1000)).duration(500).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("bauxite_slag_separation").inputItems(TagPrefix.dust, GTMaterials.BauxiteSlag).outputItems(TagPrefix.dust, GTMaterials.Salt).chancedOutput(TagPrefix.dust, GTMaterials.Neodymium, 2000, 250).chancedOutput(TagPrefix.dust, GTMaterials.Chromium, 1000, 250).duration(50).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.DISTILLERY_RECIPES.recipeBuilder("bauxite_sludge_decalcification").circuitMeta(1).inputFluids(GTMaterials.BauxiteSludge.getFluid(500)).outputItems(TagPrefix.dust, GTMaterials.Calcite, 2).outputFluids(GTMaterials.DecalcifiedBauxiteSludge.getFluid(500)).duration(100).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.CENTRIFUGE_RECIPES.recipeBuilder("bauxite_sludge_centrifuge").inputFluids(GTMaterials.DecalcifiedBauxiteSludge.getFluid(250)).outputItems(TagPrefix.dust, GTMaterials.Rutile, 2).chancedOutput(TagPrefix.dust, GTMaterials.Gallium, 5000, 550).chancedOutput(TagPrefix.dust, GTMaterials.Gallium, 3000, 800).chancedOutput(TagPrefix.dust, GTMaterials.Gallium, 1000, 1000).chancedOutput(TagPrefix.dust, GTMaterials.SiliconDioxide, 9000, 250).chancedOutput(TagPrefix.dust, GTMaterials.Iron, 8000, 250).outputFluids(GTMaterials.Water.getFluid(250)).duration(100).EUt(GTValues.VA[2]).save(provider);
    }

    private static void ilmeniteProcess(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES.recipeBuilder("ilmenite_separation").inputItems(TagPrefix.dust, GTMaterials.IlmeniteSlag).chancedOutput(TagPrefix.dust, GTMaterials.Iron, 8000, 0).chancedOutput(TagPrefix.dust, GTMaterials.Tantalum, 2000, 0).chancedOutput(TagPrefix.dust, GTMaterials.Niobium, 500, 0).duration(50).EUt(GTValues.VA[2]).save(provider);
    }
}

