/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.GTCEu;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RuntimeExistingFileHelper
extends ExistingFileHelper {
    public static final RuntimeExistingFileHelper INSTANCE = new RuntimeExistingFileHelper();
    protected final Multimap<PackType, ResourceLocation> generated = HashMultimap.create();

    protected RuntimeExistingFileHelper() {
        super(Collections.emptySet(), Collections.emptySet(), false, null, null);
    }

    @NotNull
    public static ResourceManager getManager(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return Minecraft.m_91087_().m_91098_();
        }
        if (packType == PackType.SERVER_DATA) {
            if (GTCEu.getMinecraftServer() == null) {
                throw new IllegalStateException("Cannot get server resources without a server or on a remote client.");
            }
            return GTCEu.getMinecraftServer().m_177941_();
        }
        throw new IllegalStateException("Invalid pack type " + String.valueOf(packType));
    }

    protected ResourceLocation getLocation(ResourceLocation base, String prefix, String suffix) {
        return base.m_247266_(path -> prefix + "/" + path + suffix);
    }

    public boolean exists(ResourceLocation loc, PackType packType) {
        return this.generated.get((Object)packType).contains(loc) || RuntimeExistingFileHelper.getManager(packType).m_213713_(loc).isPresent();
    }

    public void trackGenerated(ResourceLocation loc, ExistingFileHelper.IResourceType type) {
        this.trackGenerated(loc, type.getPackType(), type.getSuffix(), type.getPrefix());
    }

    public void trackGenerated(ResourceLocation loc, PackType packType, String suffix, String prefix) {
        this.generated.put((Object)packType, (Object)this.getLocation(loc, prefix, suffix));
    }

    public Resource getResource(ResourceLocation loc, PackType packType, String pathSuffix, String pathPrefix) throws FileNotFoundException {
        return this.getResource(this.getLocation(loc, pathPrefix, pathSuffix), packType);
    }

    public Resource getResource(ResourceLocation loc, PackType packType) throws FileNotFoundException {
        return RuntimeExistingFileHelper.getManager(packType).m_215593_(loc);
    }

    public List<Resource> getResourceStack(ResourceLocation loc, PackType packType) {
        return RuntimeExistingFileHelper.getManager(packType).m_213829_(loc);
    }
}

