/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.api.CauponaApi;
import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.api.events.FoodExchangeItemEvent;
import com.teammoeg.caupona.data.RecipeReloadListener;
import com.teammoeg.caupona.data.recipes.BowlContainingRecipe;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.util.ITickableContainer;
import com.teammoeg.caupona.util.StewInfo;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.patchouli.api.PatchouliAPI;

@Mod.EventBusSubscriber
public class CPCommonEvents {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RecipeReloadListener(event.getServerResources()));
    }

    @SubscribeEvent
    public static void isExtractAllowed(FoodExchangeItemEvent.Pre event) {
        if (!event.getOrigin().m_150930_(Items.f_42399_)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void isExchangeAllowed(FoodExchangeItemEvent.Post event) {
        if (!event.getOrigin().m_150930_(Items.f_42399_) && event.getTarget().m_150930_(Items.f_42399_)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AbstractContainerMenu abstractContainerMenu;
        if (event.phase == TickEvent.Phase.START && (abstractContainerMenu = event.player.f_36096_) instanceof ITickableContainer) {
            ITickableContainer container = (ITickableContainer)abstractContainerMenu;
            container.tick(event.side == LogicalSide.SERVER);
        }
    }

    @SubscribeEvent
    public static void bowlContainerFood(ContanerContainFoodEvent ev) {
        BowlContainingRecipe recipe;
        if (ev.origin.m_41720_() == Items.f_42399_ && (recipe = BowlContainingRecipe.recipes.get(ev.fs.getFluid())) != null) {
            ev.out = recipe.handle(ev.fs);
            ev.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void addManualToPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag persistent;
        if (!((Boolean)CPConfig.SERVER.addManual.get()).booleanValue()) {
            return;
        }
        if (!ModList.get().isLoaded("patchouli")) {
            return;
        }
        CompoundTag nbt = event.getEntity().getPersistentData();
        if (nbt.m_128441_("PlayerPersisted")) {
            persistent = nbt.m_128469_("PlayerPersisted");
        } else {
            persistent = new CompoundTag();
            nbt.m_128365_("PlayerPersisted", (Tag)persistent);
        }
        if (!persistent.m_128441_("caupona:book_given")) {
            persistent.m_128379_("caupona:book_given", true);
            ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)PatchouliAPI.get().getBookStack(new ResourceLocation("caupona", "book")));
        }
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockpos;
        ItemStack is = event.getItemStack();
        Player playerIn = event.getEntity();
        Level worldIn = event.getLevel();
        BlockEntity blockEntity = worldIn.m_7702_(blockpos = event.getPos());
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, event.getFace()).ifPresent(handler -> {
                Optional<ItemStack> out = CauponaApi.getFilledItemStack(handler, is);
                if (out.isPresent()) {
                    ItemStack ret = out.get();
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)worldIn.f_46443_));
                    if (is.m_41613_() > 1) {
                        is.m_41774_(1);
                        if (!playerIn.m_36356_(ret)) {
                            playerIn.m_36176_(ret, false);
                        }
                    } else {
                        playerIn.m_21008_(event.getHand(), ret);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        Optional<ItemStack> out;
        BlockPos blockpos;
        BlockState blockstate1;
        Fluid f;
        Player playerIn;
        ItemStack is = event.getItemStack();
        Level worldIn = event.getLevel();
        BlockHitResult ray = Item.m_41435_((Level)worldIn, (Player)(playerIn = event.getEntity()), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (ray.m_6662_() == HitResult.Type.BLOCK && (f = (blockstate1 = worldIn.m_8055_(blockpos = ray.m_82425_())).m_60819_().m_76152_()) != Fluids.f_76191_ && (out = CauponaApi.getBlockFilledItemStack(f, is)).isPresent()) {
            ItemStack ret = out.get();
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)worldIn.f_46443_));
            if (is.m_41613_() > 1) {
                is.m_41774_(1);
                if (!playerIn.m_36356_(ret)) {
                    playerIn.m_36176_(ret, false);
                }
            } else {
                playerIn.m_21008_(event.getHand(), ret);
            }
        }
    }

    @SubscribeEvent
    public static void onBowlUse(PlayerInteractEvent.RightClickItem event) {
        IFluidHandlerItem data;
        ItemStack stack;
        LazyOptional cap;
        if (event.getEntity() != null && !event.getEntity().m_9236_().f_46443_ && event.getEntity() instanceof ServerPlayer && (cap = (stack = event.getItemStack()).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent() && stack.m_204117_(CPTags.Items.CONTAINER) && (data = (IFluidHandlerItem)cap.resolve().get()).getFluidInTank(0).getFluid() instanceof SoupFluid) {
            StewInfo si = SoupFluid.getInfo(data.getFluidInTank(0));
            if (!event.getEntity().m_36391_(si.canAlwaysEat())) {
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        IFluidHandlerItem data;
        ItemStack stack;
        LazyOptional cap;
        if (event.getEntity() != null && !event.getEntity().m_9236_().f_46443_ && event.getEntity() instanceof ServerPlayer && (cap = (stack = event.getItem()).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).isPresent() && stack.m_204117_(CPTags.Items.CONTAINER) && (data = (IFluidHandlerItem)cap.resolve().get()).getFluidInTank(0).getFluid() instanceof SoupFluid) {
            CauponaApi.apply(event.getEntity().m_9236_(), event.getEntity(), SoupFluid.getInfo(data.getFluidInTank(0)));
        }
    }
}

