/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.api;

import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.item.StewItem;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.IFoodInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class CauponaHooks {
    public static final ResourceLocation stew = new ResourceLocation("caupona", "stews");
    private static final LinkedHashMap<String, Function<ItemStack, IFoodInfo>> foodInfoHooks = new LinkedHashMap();

    private CauponaHooks() {
    }

    public static void registerInfoProvider(String name, Function<ItemStack, IFoodInfo> funcs) {
        foodInfoHooks.put(name, funcs);
    }

    public static Optional<List<FloatemStack>> getItems(ItemStack stack) {
        return CauponaHooks.getInfo(stack).map(t -> t.getStacks());
    }

    public static ResourceLocation getBase(ItemStack stack) {
        LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (cap.isPresent()) {
            IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
            return SoupFluid.getBase(data.getFluidInTank(0));
        }
        if (Utils.getFluidType(stack) != Fluids.f_76191_) {
            return StewItem.getBase(stack);
        }
        return new ResourceLocation("water");
    }

    public static Optional<IFoodInfo> getInfo(ItemStack stack) {
        return foodInfoHooks.values().stream().map(t -> (IFoodInfo)t.apply(stack)).filter(t -> t != null).findFirst();
    }

    static {
        foodInfoHooks.put("caupona:stew_item", stack -> {
            if (stack.m_41720_() instanceof StewItem) {
                return StewItem.getInfo(stack);
            }
            return null;
        });
        foodInfoHooks.put("caupona:soup_fluid_handler", stack -> {
            LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (cap.isPresent()) {
                IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
                return SoupFluid.getInfoOrNull(data.getFluidInTank(0));
            }
            return null;
        });
        foodInfoHooks.put("caupona:dish_item", stack -> {
            if (stack.m_41720_() instanceof DishItem) {
                return DishItem.getInfo(stack);
            }
            return null;
        });
    }
}

