/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.fumarole;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.fumarole.FumaroleVentBlock;
import com.teammoeg.caupona.blocks.fumarole.PumiceBloomBlock;
import com.teammoeg.caupona.blocks.stove.IStove;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.LazyTickWorker;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FumaroleVentBlockEntity
extends CPBaseBlockEntity
implements IStove {
    private final int heat;
    LazyTickWorker update;
    LazyTickWorker check;

    public FumaroleVentBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CPBlockEntityTypes.FUMAROLE.get(), pWorldPosition, pBlockState);
        this.heat = (Integer)CPConfig.SERVER.fumarolePower.get();
        this.check = new LazyTickWorker((Integer)CPConfig.SERVER.fumaroleCheck.get(), () -> {
            BlockState bs = this.m_58900_();
            BlockState below = this.m_58904_().m_8055_(this.m_58899_().m_6625_(2));
            int cheat = (Integer)bs.m_61143_((Property)FumaroleVentBlock.HEAT);
            if (below.m_204336_(CPTags.Blocks.FUMAROLE_VERY_HOT_BLOCK)) {
                if (cheat != 2) {
                    this.m_58904_().m_46597_(this.m_58899_(), (BlockState)bs.m_61124_((Property)FumaroleVentBlock.HEAT, (Comparable)Integer.valueOf(2)));
                }
            } else if (below.m_204336_(CPTags.Blocks.FUMAROLE_HOT_BLOCK)) {
                if (cheat != 1) {
                    this.m_58904_().m_46597_(this.m_58899_(), (BlockState)bs.m_61124_((Property)FumaroleVentBlock.HEAT, (Comparable)Integer.valueOf(1)));
                }
            } else if (cheat != 0) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)bs.m_61124_((Property)FumaroleVentBlock.HEAT, (Comparable)Integer.valueOf(0)));
            }
            return true;
        });
        this.update = new LazyTickWorker((Integer)CPConfig.SERVER.fumaroleSpeed.get(), () -> {
            if (!((Boolean)this.m_58900_().m_61143_((Property)FumaroleVentBlock.WATERLOGGED)).booleanValue()) {
                FumaroleVentBlockEntity.placeFumarole(this.m_58904_(), this.m_58899_());
            }
            return true;
        });
    }

    @Override
    public void handleMessage(short type, int data) {
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        if (isClient) {
            return;
        }
        this.update.read(nbt, "update");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        if (isClient) {
            return;
        }
        this.update.write(nbt, "update");
    }

    @Override
    public void tick() {
        BlockState bs = this.m_58900_();
        if ((Integer)bs.m_61143_((Property)FumaroleVentBlock.HEAT) == 2 && !this.f_58857_.f_46443_) {
            this.update.tick();
            this.m_6596_();
        }
        this.check.tick();
    }

    public static void placeFumarole(Level pLevel, BlockPos pPos) {
        RandomSource pRandom = pLevel.m_213780_();
        int dx = (pRandom.m_188499_() ? 1 : -1) * pRandom.m_188503_(6);
        int dz = (pRandom.m_188499_() ? 1 : -1) * pRandom.m_188503_(6);
        if (dx == 0 && dz == 0) {
            return;
        }
        BlockPos pendPos = pPos.m_7918_(dx, 0, dz);
        for (int i = 0; i < 3; ++i) {
            BlockState b0 = pLevel.m_8055_(pendPos);
            BlockState b1 = pLevel.m_8055_(pendPos.m_7495_());
            if (b0.m_60795_() && b1.m_60819_().m_205070_(CPTags.Fluids.PUMICE_ON)) {
                if (FumaroleVentBlockEntity.shouldPlacePumice(pLevel, pendPos)) {
                    pLevel.m_46597_(pendPos, ((PumiceBloomBlock)((Object)CPBlocks.PUMICE_BLOOM.get())).m_49966_());
                }
                return;
            }
            pendPos = pendPos.m_7495_();
        }
    }

    public static boolean shouldPlacePumice(Level pLevel, BlockPos pPos) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return false;
        }
        int cnt = 0;
        AABB aabb = new AABB(pPos.m_7918_(-1, 0, -1), pPos.m_7918_(1, 0, 1));
        Iterator it = pLevel.m_45556_(aabb).iterator();
        while (it.hasNext()) {
            if (((BlockState)it.next()).m_60734_() == CPBlocks.PUMICE_BLOOM.get()) {
                ++cnt;
            }
            if (cnt < 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public int requestHeat() {
        if (((Boolean)this.m_58900_().m_61143_((Property)FumaroleVentBlock.WATERLOGGED)).booleanValue()) {
            return 0;
        }
        return this.heat;
    }

    @Override
    public boolean canEmitHeat() {
        if (this.heat == 0) {
            return false;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)FumaroleVentBlock.WATERLOGGED)).booleanValue()) {
            return false;
        }
        return (Integer)this.m_58900_().m_61143_((Property)FumaroleVentBlock.HEAT) != 0;
    }
}

