/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.hypocaust;

import com.teammoeg.caupona.CPConfig;
import com.teammoeg.caupona.network.CPBaseBlockEntity;
import com.teammoeg.caupona.util.LazyTickWorker;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BathHeatingBlockEntity
extends CPBaseBlockEntity {
    private double rate;
    private int val;
    protected LazyTickWorker process;
    protected int heat;
    private boolean water;

    public BathHeatingBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.rate = (Double)CPConfig.SERVER.bathChance.get();
        this.val = (Integer)CPConfig.SERVER.bathExp.get();
        this.process = new LazyTickWorker((Integer)CPConfig.SERVER.bathPath.get(), () -> {
            if (this.heat != 0) {
                this.heat = 0;
                return true;
            }
            return false;
        });
        this.water = (Boolean)CPConfig.SERVER.strictWater.get() == false;
    }

    public int getHeat() {
        return this.heat;
    }

    public void setHeat(int val) {
        if (this.heat > val) {
            return;
        }
        this.process.rewind();
        if (this.heat != val) {
            this.heat = val;
            this.syncData();
        } else {
            this.m_6596_();
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        this.heat = nbt.m_128451_("bathHeat");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        nbt.m_128405_("bathHeat", this.heat);
    }

    protected static boolean inRange(int pos, double d) {
        return d >= (double)pos && d < (double)(pos + 1);
    }

    protected static boolean inRange(double pos, double d, double dmax) {
        return d >= pos && d < pos + dmax;
    }

    protected boolean isInWater(Player p) {
        if (this.water) {
            return true;
        }
        if (p.m_20072_()) {
            return true;
        }
        Entity e = p.m_20202_();
        while (e != null) {
            if (e.m_20072_()) {
                return true;
            }
            e = p.m_20202_();
        }
        return false;
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        int heat = this.getHeat();
        if (this.val > 0 && heat > 0 && this.f_58857_.f_46441_.m_188500_() < this.rate && this.m_58904_().m_6425_(this.m_58899_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
            int posX = this.m_58899_().m_123341_();
            int posY = this.m_58899_().m_123342_();
            int posZ = this.m_58899_().m_123343_();
            int addExp = this.val * heat;
            for (Player p : this.m_58904_().m_6907_()) {
                if (!BathHeatingBlockEntity.inRange(posX, p.m_20185_()) || !BathHeatingBlockEntity.inRange(posZ, p.m_20189_()) || !BathHeatingBlockEntity.inRange(posY, p.m_20186_(), 2.0) || !this.isInWater(p)) continue;
                p.m_6756_(addExp);
            }
        }
        if (this.process.tick()) {
            this.syncData();
        }
    }
}

