/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teammoeg.caupona.blocks.pot.StewPot;
import com.teammoeg.caupona.blocks.pot.StewPotBlockEntity;
import com.teammoeg.caupona.client.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Vector3f;

public class StewPotRenderer
implements BlockEntityRenderer<StewPotBlockEntity> {
    public StewPotRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    private static Vector3f clr(int fromcol, int tocol, float proc) {
        float fcolr = (float)(fromcol >> 16 & 0xFF) / 255.0f;
        float fcolg = (float)(fromcol >> 8 & 0xFF) / 255.0f;
        float fcolb = (float)(fromcol & 0xFF) / 255.0f;
        float tcolr = (float)(tocol >> 16 & 0xFF) / 255.0f;
        float tcolg = (float)(tocol >> 8 & 0xFF) / 255.0f;
        float tcolb = (float)(tocol & 0xFF) / 255.0f;
        return new Vector3f(fcolr + (tcolr - fcolr) * proc, fcolg + (tcolg - fcolg) * proc, fcolb + (tcolb - fcolb) * proc);
    }

    private static Vector3f clr(int col) {
        return new Vector3f((float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f);
    }

    public void render(StewPotBlockEntity blockEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (!blockEntity.m_58904_().m_46805_(blockEntity.m_58899_())) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        if (!(state.m_60734_() instanceof StewPot)) {
            return;
        }
        matrixStack.m_85836_();
        FluidStack fs = blockEntity.getTank().getFluid();
        if (fs != null && !fs.isEmpty() && fs.getFluid() != null) {
            Vector3f clr;
            float rr = fs.getAmount();
            if (blockEntity.proctype == 2) {
                rr += 250.0f * (1.0f - (float)blockEntity.process * 1.0f / (float)blockEntity.processMax);
            }
            float yy = Math.min(1.0f, rr / (float)blockEntity.getTank().getCapacity()) * 0.5f + 0.1875f;
            matrixStack.m_252880_(0.0f, yy, 0.0f);
            matrixStack.m_252781_(GuiUtils.rotate90);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
            IClientFluidTypeExtensions attr0 = IClientFluidTypeExtensions.of((Fluid)fs.getFluid());
            TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
            TextureAtlasSprite sprite = atlas.m_118316_(attr0.getStillTexture(fs));
            int col = attr0.getTintColor(fs);
            float alp = 1.0f;
            if (blockEntity.become != null && blockEntity.processMax > 0) {
                IClientFluidTypeExtensions attr1 = IClientFluidTypeExtensions.of((Fluid)blockEntity.become);
                TextureAtlasSprite sprite2 = atlas.m_118316_(attr1.getStillTexture(fs));
                float proc = (float)blockEntity.process * 1.0f / (float)blockEntity.processMax;
                clr = StewPotRenderer.clr(col, attr1.getTintColor(fs), proc);
                alp = 1.0f - proc;
                GuiUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, clr.x(), clr.y(), clr.z(), proc, sprite2.m_118409_(), sprite2.m_118410_(), sprite2.m_118411_(), sprite2.m_118412_(), combinedLightIn, combinedOverlayIn);
            } else {
                clr = StewPotRenderer.clr(col);
            }
            GuiUtils.drawTexturedColoredRect(builder, matrixStack, 0.125f, 0.125f, 0.75f, 0.75f, clr.x(), clr.y(), clr.z(), alp, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), combinedLightIn, combinedOverlayIn);
        }
        matrixStack.m_85849_();
    }
}

