/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SerializeUtil {
    private SerializeUtil() {
    }

    public static <T> Optional<T> readOptional(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> func) {
        if (buffer.readBoolean()) {
            return Optional.ofNullable(func.apply(buffer));
        }
        return Optional.empty();
    }

    public static <T> void writeOptional2(FriendlyByteBuf buffer, T data, BiConsumer<FriendlyByteBuf, T> func) {
        SerializeUtil.writeOptional(buffer, data, (T a, FriendlyByteBuf b) -> func.accept((FriendlyByteBuf)b, (Object)a));
    }

    public static <T> void writeOptional(FriendlyByteBuf buffer, T data, BiConsumer<T, FriendlyByteBuf> func) {
        SerializeUtil.writeOptional(buffer, Optional.ofNullable(data), func);
    }

    public static <T> void writeOptional(FriendlyByteBuf buffer, Optional<T> data, BiConsumer<T, FriendlyByteBuf> func) {
        if (data.isPresent()) {
            buffer.writeBoolean(true);
            func.accept(data.get(), buffer);
            return;
        }
        buffer.writeBoolean(false);
    }

    public static <T> List<T> readList(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> func) {
        if (!buffer.readBoolean()) {
            return null;
        }
        int cnt = buffer.m_130242_();
        ArrayList<T> nums = new ArrayList<T>(cnt);
        for (int i = 0; i < cnt; ++i) {
            nums.add(func.apply(buffer));
        }
        return nums;
    }

    public static <T> void writeList(FriendlyByteBuf buffer, Collection<T> elms, BiConsumer<T, FriendlyByteBuf> func) {
        if (elms == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.m_130130_(elms.size());
        elms.forEach(e -> func.accept(e, buffer));
    }

    public static <T> void writeList2(FriendlyByteBuf buffer, Collection<T> elms, BiConsumer<FriendlyByteBuf, T> func) {
        if (elms == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.m_130130_(elms.size());
        elms.forEach(e -> func.accept(buffer, e));
    }

    public static <T> List<T> parseJsonList(JsonElement elm, Function<JsonObject, T> mapper) {
        if (elm == null) {
            return Lists.newArrayList();
        }
        if (elm.isJsonArray()) {
            return StreamSupport.stream(elm.getAsJsonArray().spliterator(), false).map(JsonElement::getAsJsonObject).map(mapper).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new Object[]{mapper.apply(elm.getAsJsonObject())});
    }

    public static <T> List<T> parseJsonElmList(JsonElement elm, Function<JsonElement, T> mapper) {
        if (elm == null) {
            return Lists.newArrayList();
        }
        if (elm.isJsonArray()) {
            return StreamSupport.stream(elm.getAsJsonArray().spliterator(), false).map(mapper).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new Object[]{mapper.apply((JsonElement)elm.getAsJsonObject())});
    }

    public static <T> JsonArray toJsonList(Collection<T> li, Function<T, JsonElement> mapper) {
        JsonArray ja = new JsonArray();
        li.stream().map(mapper).forEach(arg_0 -> ((JsonArray)ja).add(arg_0));
        return ja;
    }

    public static <T> ListTag toNBTList(Collection<T> stacks, Function<T, Tag> mapper) {
        ListTag nbt = new ListTag();
        stacks.stream().map(mapper).forEach(arg_0 -> nbt.add(arg_0));
        return nbt;
    }

    public static FluidStack readFluidStack(JsonElement jsonIn) {
        if (jsonIn == null) {
            return null;
        }
        return FluidStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonIn).result().map(Pair::getFirst).orElse(FluidStack.EMPTY);
    }

    public static FluidStack readFluidStack(FriendlyByteBuf in) {
        Fluid f = (Fluid)in.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        int amount = in.m_130242_();
        FluidStack fs = new FluidStack(f, amount);
        SerializeUtil.readOptional(in, d -> d.m_130260_()).ifPresent(e -> fs.setTag(e));
        return fs;
    }

    public static JsonElement writeFluidStack(FluidStack stack) {
        return FluidStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack).result().orElse(null);
    }

    public static void writeFluidStack(FriendlyByteBuf out, FluidStack stack) {
        out.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)stack.getFluid());
        out.m_130130_(stack.getAmount());
        SerializeUtil.writeOptional(out, stack.getTag(), (T s, FriendlyByteBuf d) -> d.m_130079_(s));
    }
}

