/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.util.Utils;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BowlContainingRecipe
extends IDataRecipe {
    public static Map<Fluid, BowlContainingRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public Item bowl;
    public Fluid fluid;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public BowlContainingRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        this.bowl = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jo.get("item").getAsString()));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("fluid").getAsString()));
        if (this.bowl == null || this.bowl == Items.f_41852_ || this.fluid == null || this.fluid == Fluids.f_76191_) {
            throw new InvalidRecipeException();
        }
    }

    public BowlContainingRecipe(ResourceLocation id, FriendlyByteBuf pb) {
        super(id);
        this.bowl = (Item)pb.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        this.fluid = (Fluid)pb.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
    }

    public BowlContainingRecipe(ResourceLocation id, Item bowl, Fluid fluid) {
        super(id);
        this.bowl = bowl;
        this.fluid = fluid;
    }

    public void write(FriendlyByteBuf pack) {
        pack.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)this.bowl);
        pack.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)this.fluid);
    }

    @Override
    public void serializeRecipeData(JsonObject jo) {
        jo.addProperty("item", Utils.getRegistryName(this.bowl).toString());
        jo.addProperty("fluid", Utils.getRegistryName(this.fluid).toString());
    }

    public ItemStack handle(Fluid f) {
        ItemStack is = new ItemStack((ItemLike)this.bowl);
        Utils.writeItemFluid(is, f);
        return is;
    }

    public boolean matches(Fluid f) {
        return this.fluid == f;
    }

    public ItemStack handle(FluidStack stack) {
        ItemStack is = new ItemStack((ItemLike)this.bowl);
        Utils.writeItemFluid(is, stack);
        return is;
    }
}

