/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.util.FloatemTagStack;
import com.teammoeg.caupona.util.ResultCachingMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class IPendingContext {
    protected List<FloatemTagStack> items;
    protected float totalItems;
    private ResultCachingMap<CookIngredients, Float> numbers = new ResultCachingMap<CookIngredients, Float>(e -> (Float)e.apply(this));
    private ResultCachingMap<IngredientCondition, Boolean> results = new ResultCachingMap<IngredientCondition, Boolean>(e -> e.test(this));

    public float compute(CookIngredients sn) {
        return this.numbers.compute(sn).floatValue();
    }

    public boolean compute(IngredientCondition sc) {
        return this.results.compute(sc);
    }

    public float getOfType(ResourceLocation rl) {
        return (float)this.items.stream().filter(e -> e.getTags().contains(rl)).mapToDouble(FloatemTagStack::getCount).sum();
    }

    public float getOfItem(Predicate<ItemStack> pred) {
        for (FloatemTagStack fs : this.items) {
            if (!pred.test(fs.getStack())) continue;
            return fs.getCount();
        }
        return 0.0f;
    }

    public float getTotalItems() {
        return this.totalItems;
    }

    public List<FloatemTagStack> getItems() {
        return this.items;
    }
}

