/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemIngredient
implements CookIngredients {
    Ingredient i;
    String translation = "";

    public ItemIngredient(JsonElement jo) {
        this.i = Ingredient.m_43917_((JsonElement)jo.getAsJsonObject().get("ingredient"));
        if (jo.getAsJsonObject().has("description")) {
            this.translation = jo.getAsJsonObject().get("description").getAsString();
        }
    }

    public ItemIngredient(Ingredient i) {
        this.i = i;
    }

    public ItemIngredient(Ingredient i, String translation) {
        this.i = i;
        this.translation = translation;
    }

    @Override
    public Float apply(IPendingContext t) {
        return Float.valueOf(t.getOfItem((Predicate<ItemStack>)this.i));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return this.i.test(stack.getStack());
    }

    @Override
    public JsonElement serialize() {
        JsonObject th = new JsonObject();
        th.add("ingredient", this.i.m_43942_());
        th.addProperty("description", this.translation);
        return th;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.i.m_43923_(buffer);
        buffer.m_130070_(this.translation);
    }

    public ItemIngredient(FriendlyByteBuf buffer) {
        this.i = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.translation = buffer.m_130277_();
    }

    @Override
    public String getType() {
        return "ingredient";
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.i == null ? 0 : this.i.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemIngredient)) {
            return false;
        }
        ItemIngredient other = (ItemIngredient)obj;
        return !(this.i == null ? other.i != null : !this.i.equals(other.i));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslationOrElse(this.translation, this.translation, new Object[0]);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return Arrays.stream(this.i.m_43908_());
    }
}

