/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.google.common.collect.Lists;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.item.EdibleBlock;
import com.teammoeg.caupona.util.CreativeTabItemHelper;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.FluidItemWrapper;
import com.teammoeg.caupona.util.StewInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class StewItem
extends EdibleBlock {
    ResourceLocation fluid;
    public static final FoodProperties fakefood = new FoodProperties.Builder().m_38760_(4).m_38758_(0.2f).m_38766_().m_38757_().m_38767_();

    public int m_8105_(ItemStack stack) {
        return 16;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceLocation base;
        ResourceLocation rl;
        StewInfo info = StewItem.getInfo(stack);
        FloatemStack fs = info.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
        if (fs != null) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.main_ingredient", fs.getStack().m_41611_()));
        }
        if ((rl = info.spiceName) != null) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.spice", Utils.translate("spice." + rl.m_135827_() + "." + rl.m_135815_())));
        }
        if ((base = info.base) != null && !info.stacks.isEmpty()) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.base", ((Fluid)ForgeRegistries.FLUIDS.getValue(base)).getFluidType().getDescription()));
        }
        Utils.addPotionTooltip(info.effects, tooltip, 1.0f);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static StewInfo getInfo(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag soupTag = Utils.extractDataElement(stack, "soup");
            return soupTag == null ? new StewInfo(Utils.getFluidTypeRL(stack)) : new StewInfo(soupTag);
        }
        return new StewInfo();
    }

    public static void setInfo(ItemStack stack, StewInfo si) {
        if (!si.isEmpty()) {
            Utils.setDataElement(stack, "soup", si.save());
        }
    }

    public static List<FloatemStack> getItems(ItemStack stack) {
        CompoundTag nbt = Utils.extractDataElement(stack, "soup");
        if (nbt != null) {
            return StewInfo.getStacks(nbt);
        }
        return Lists.newArrayList();
    }

    public static ResourceLocation getBase(ItemStack stack) {
        CompoundTag nbt = Utils.extractDataElement(stack, "soup");
        if (nbt != null) {
            return new ResourceLocation(StewInfo.getRegName(nbt));
        }
        return Utils.getRegistryName(Utils.getFluidType(stack));
    }

    @Override
    public void fillItemCategory(CreativeTabItemHelper helper) {
        if (helper.isFoodTab()) {
            ItemStack is = new ItemStack((ItemLike)this);
            Utils.writeItemFluid(is, this.fluid);
            super.addCreativeHints(is);
            helper.m_246342_(is);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public StewItem(ResourceLocation fluid, Item.Properties properties) {
        super((Block)CPBlocks.BOWL.get(), properties.m_41489_(fakefood));
        CPItems.stews.add((Item)this);
        this.fluid = fluid;
    }

    public FoodProperties getFoodProperties(ItemStack stack, LivingEntity entity) {
        return StewItem.getInfo(stack).getFood();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidItemWrapper(stack);
    }
}

