/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class FloatemStack {
    ItemStack stack;
    float count;

    public FloatemStack(ItemStack stack, float count) {
        this.stack = stack.m_41777_();
        this.stack.m_41764_(1);
        this.count = count;
    }

    public FloatemStack(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public FloatemStack(ItemStack is) {
        this(is, is.m_41613_());
    }

    public ItemStack getStack() {
        return this.stack.m_41777_();
    }

    public ItemStack getCraftingRemainingItem() {
        return this.stack.getCraftingRemainingItem();
    }

    public boolean hasContainerItem() {
        return this.stack.hasCraftingRemainingItem();
    }

    public CompoundTag serializeNBT() {
        CompoundTag cnbt = this.stack.serializeNBT();
        cnbt.m_128350_("th_countf", this.count);
        return cnbt;
    }

    public boolean isEmpty() {
        return (double)this.count <= 0.001;
    }

    public Item getItem() {
        return this.stack.m_41720_();
    }

    public int getEntityLifespan(Level world) {
        return this.stack.getEntityLifespan(world);
    }

    public CompoundTag write(CompoundTag nbt) {
        CompoundTag cnbt = this.stack.m_41739_(nbt);
        cnbt.m_128350_("th_countf", this.count);
        return cnbt;
    }

    public int getMaxStackSize() {
        return this.stack.m_41741_();
    }

    public boolean isStackable() {
        return this.stack.m_41753_();
    }

    public boolean isDamageable() {
        return this.stack.m_41763_();
    }

    public boolean isDamaged() {
        return this.stack.m_41768_();
    }

    public int getDamage() {
        return this.stack.m_41773_();
    }

    public void setDamage(int damage) {
        this.stack.m_41721_(damage);
    }

    public int getMaxDamage() {
        return this.stack.m_41776_();
    }

    public CompoundTag getShareTag() {
        return this.stack.getShareTag();
    }

    public void readShareTag(CompoundTag nbt) {
        this.stack.readShareTag(nbt);
    }

    public boolean areShareTagsEqual(ItemStack other) {
        return this.stack.areShareTagsEqual(other);
    }

    public FloatemStack copy() {
        return new FloatemStack(this.stack.m_41777_(), this.count);
    }

    public boolean isItemEqual(ItemStack other) {
        return ItemStack.m_41656_((ItemStack)this.stack, (ItemStack)other);
    }

    public String getTranslationKey() {
        return this.stack.m_41778_();
    }

    public boolean hasTag() {
        return this.stack.m_41782_();
    }

    public CompoundTag getTag() {
        return this.stack.m_41783_();
    }

    public Stream<ResourceLocation> getTags() {
        return this.stack.m_204131_().map(TagKey::f_203868_);
    }

    public CompoundTag getOrCreateTag() {
        return this.stack.m_41784_();
    }

    public CompoundTag getOrCreateChildTag(String key) {
        return this.stack.m_41698_(key);
    }

    public CompoundTag getChildTag(String key) {
        return this.stack.m_41737_(key);
    }

    public void removeChildTag(String p_196083_1_) {
        this.stack.m_41749_(p_196083_1_);
    }

    public void setTag(CompoundTag nbt) {
        this.stack.m_41751_(nbt);
    }

    public Component getDisplayName() {
        return this.stack.m_41786_();
    }

    public ItemStack setDisplayName(Component name) {
        return this.stack.m_41714_(name);
    }

    public void clearCustomName() {
        this.stack.m_41787_();
    }

    public boolean hasDisplayName() {
        return this.stack.m_41788_();
    }

    public boolean hasEffect() {
        return this.stack.m_41790_();
    }

    public Rarity getRarity() {
        return this.stack.m_41791_();
    }

    public void setTagInfo(String key, Tag value) {
        this.stack.m_41700_(key, value);
    }

    public Component getTextComponent() {
        return this.stack.m_41611_();
    }

    public float getCount() {
        return this.count;
    }

    public void setCount(float count) {
        this.count = count;
    }

    public void grow(float count) {
        this.count += count;
    }

    public void shrink(float count) {
        this.count -= count;
        if (this.count < 0.0f) {
            this.count = 0.0f;
        }
    }

    public boolean isFood() {
        return this.stack.m_41614_();
    }

    public boolean equals(ItemStack other) {
        return ItemStack.m_150942_((ItemStack)this.getStack(), (ItemStack)other);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt);
        this.count = nbt.m_128457_("th_countf");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.count);
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatemStack other = (FloatemStack)obj;
        if (Float.floatToIntBits(this.count) != Float.floatToIntBits(other.count)) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !this.equals(other.stack));
    }
}

