/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;

public class LazyTickWorker {
    public int tMax;
    public int tCur = 0;
    private boolean isStaticMax;
    public Supplier<Boolean> work;

    public LazyTickWorker(int tMax, Supplier<Boolean> work) {
        this.tMax = tMax;
        this.work = work;
        this.isStaticMax = true;
    }

    public LazyTickWorker(Supplier<Boolean> work) {
        this.work = work;
        this.isStaticMax = false;
    }

    public boolean tick() {
        if (this.tMax != 0) {
            ++this.tCur;
            if (this.tCur >= this.tMax) {
                this.tCur = 0;
                return this.work.get();
            }
        }
        return false;
    }

    public void rewind() {
        this.tCur = 0;
    }

    public void enqueue() {
        this.tCur = this.tMax;
    }

    public void read(CompoundTag cnbt) {
        if (!this.isStaticMax) {
            this.tMax = cnbt.m_128451_("max");
        }
        this.tCur = cnbt.m_128451_("cur");
    }

    public void read(CompoundTag cnbt, String key) {
        if (!this.isStaticMax) {
            this.tMax = cnbt.m_128451_(key + "max");
        }
        this.tCur = cnbt.m_128451_(key);
    }

    public CompoundTag write(CompoundTag cnbt) {
        if (!this.isStaticMax) {
            cnbt.m_128405_("max", this.tMax);
        }
        cnbt.m_128405_("cur", this.tCur);
        return cnbt;
    }

    public CompoundTag write(CompoundTag cnbt, String key) {
        if (!this.isStaticMax) {
            cnbt.m_128405_(key + "max", this.tMax);
        }
        cnbt.m_128405_(key, this.tCur);
        return cnbt;
    }
}

