/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.apiimpl.storage.externalstorage.ItemExternalStorage;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ProxyItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class TieredInterfaceNetworkNode
extends TieredNetworkNode<TieredInterfaceNetworkNode>
implements IComparable {
    private static final String NBT_COMPARE = "Compare";
    private static final int BASE_SPEED = 9;
    private final BaseItemHandler importItems = new BaseItemHandler(this.getSlotAmount()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final BaseItemHandler exportFilterItems = new BaseItemHandler(this.getSlotAmount()){

        public int getSlotLimit(int slot) {
            return TieredInterfaceNetworkNode.this.getTieredStackInteractCount();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return TieredInterfaceNetworkNode.this.getTieredStackInteractCount();
        }
    }.addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final BaseItemHandler exportItems = new BaseItemHandler(this.getSlotAmount()){

        public int getSlotLimit(int slot) {
            return TieredInterfaceNetworkNode.this.getTieredStackInteractCount();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return TieredInterfaceNetworkNode.this.getTieredStackInteractCount();
        }
    }.addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final IItemHandler items = new ProxyItemHandler((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.getTierUpgrades()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int currentSlot = 0;
    private final double speedMultiplier = this.getSpeedMultiplier(5);

    public TieredInterfaceNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.INTERFACE, tier);
    }

    private UpgradeItem.Type[] getTierUpgrades() {
        UpgradeItem.Type[] typeArray;
        switch (this.getTier()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ELITE: {
                UpgradeItem.Type[] typeArray2 = new UpgradeItem.Type[3];
                typeArray2[0] = UpgradeItem.Type.SPEED;
                typeArray2[1] = UpgradeItem.Type.STACK;
                typeArray = typeArray2;
                typeArray2[2] = UpgradeItem.Type.CRAFTING;
                break;
            }
            case ULTRA: 
            case MEGA: {
                UpgradeItem.Type[] typeArray3 = new UpgradeItem.Type[2];
                typeArray3[0] = UpgradeItem.Type.SPEED;
                typeArray = typeArray3;
                typeArray3[1] = UpgradeItem.Type.CRAFTING;
            }
        }
        return typeArray;
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getDiskManipulator().getUsage() + this.upgrades.getEnergyUsage()) * this.getAdditionalEnergyCost();
    }

    private int getSlotAmount() {
        return switch (this.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case CableTier.ELITE -> 18;
            case CableTier.ULTRA -> 22;
            case CableTier.MEGA -> 26;
        };
    }

    public void update() {
        ItemStack slot;
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        int speed = Math.max(0, this.upgrades.getSpeed((int)(9.0 / this.speedMultiplier), 2));
        if (speed != 0 && this.ticks % speed != 0) {
            return;
        }
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)).m_41619_()) {
            ++this.currentSlot;
        } else {
            int size = Math.min(slot.m_41613_(), this.getTieredStackInteractCount(this.upgrades));
            ItemStack remainder = this.network.insertItemTracked(slot, size);
            this.importItems.extractItem(this.currentSlot, size - remainder.m_41613_(), false);
        }
        for (int i = 0; i < this.getSlotAmount(); ++i) {
            int delta;
            ItemStack wanted = this.exportFilterItems.getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted.m_41619_()) {
                if (got.m_41619_()) continue;
                this.exportItems.setStackInSlot(i, this.network.insertItemTracked(got, got.m_41613_()));
                continue;
            }
            if (!got.m_41619_() && !API.instance().getComparer().isEqual(wanted, got, this.getCompare())) {
                this.exportItems.setStackInSlot(i, this.network.insertItemTracked(got, got.m_41613_()));
                continue;
            }
            int n = delta = got.m_41619_() ? wanted.m_41613_() : wanted.m_41613_() - got.m_41613_();
            if (delta > 0) {
                boolean actingAsStorage = this.isActingAsStorage();
                ItemStack result = this.network.extractItem(wanted, delta, this.compare, Action.PERFORM, s -> {
                    if (!actingAsStorage) {
                        return true;
                    }
                    return !(s instanceof ItemExternalStorage) || !((ItemExternalStorage)s).isConnectedToInterface();
                });
                if (!result.m_41619_()) {
                    if (this.exportItems.getStackInSlot(i).m_41619_()) {
                        this.exportItems.setStackInSlot(i, result);
                    } else {
                        this.exportItems.getStackInSlot(i).m_41769_(result.m_41613_());
                    }
                }
                if ((delta -= result.m_41613_()) <= 0 || !this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) continue;
                this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, i), wanted, delta);
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItemTracked(got, Math.abs(delta));
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.m_41613_(), false);
        }
    }

    private boolean isActingAsStorage() {
        for (Direction facing : Direction.values()) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager((ServerLevel)this.level).getNode(this.pos.m_121945_(facing));
            if (!(facingNode instanceof ExternalStorageNetworkNode) || !facingNode.isActive() || ((ExternalStorageNetworkNode)facingNode).getDirection() != facing.m_122424_() || ((ExternalStorageNetworkNode)facingNode).getType() != 0) continue;
            return true;
        }
        return false;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.importItems, (int)0, (CompoundTag)tag);
        StackUtils.readItems((BaseItemHandler)this.exportItems, (int)2, (CompoundTag)tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)3, (CompoundTag)tag);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.importItems, (int)0, (CompoundTag)tag);
        StackUtils.writeItems((IItemHandler)this.exportItems, (int)2, (CompoundTag)tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)3, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.exportFilterItems, (int)1, (CompoundTag)tag);
        for (int i = 0; i < this.exportFilterItems.getSlots(); ++i) {
            if (this.exportFilterItems.getStackInSlot(i).m_41619_()) continue;
            tag.m_128405_("SlotItemAmount" + i, this.exportFilterItems.getStackInSlot(i).m_41613_());
        }
        tag.m_128405_(NBT_COMPARE, this.compare);
        return tag;
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((BaseItemHandler)this.exportFilterItems, (int)1, (CompoundTag)tag);
        for (int i = 0; i < this.exportFilterItems.getSlots(); ++i) {
            this.exportFilterItems.getStackInSlot(i).m_41764_(tag.m_128451_("SlotItemAmount" + i));
        }
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportFilterItems() {
        return this.exportFilterItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getItems() {
        return this.items;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }
}

