/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.builder.client.GuiChamberDetails;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record PacketChamberInfoReady(Map<BlockState, Integer> blocks, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities, Map<String, String> playerNames) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsbuilder", "chamberinfoready");
    private static final byte ENTITY_NONE = 0;
    private static final byte ENTITY_NORMAL = 1;
    private static final byte ENTITY_PLAYER = 2;

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<BlockState, Integer> entry : this.blocks.entrySet()) {
            BlockState bm = entry.getKey();
            buf.writeInt(Block.m_49956_((BlockState)bm));
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.costs.get(bm).intValue());
            if (this.stacks.containsKey(bm)) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)this.stacks.get(bm));
                continue;
            }
            buf.writeBoolean(false);
        }
        buf.writeInt(this.entities.size());
        for (Map.Entry<Object, Integer> entry : this.entities.entrySet()) {
            String name = (String)entry.getKey();
            buf.m_130070_(name);
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.entityCosts.get(name).intValue());
            if (this.realEntities.containsKey(name)) {
                Entity entity = this.realEntities.get(name);
                if (entity instanceof Player) {
                    buf.writeByte(2);
                    int entityId = entity.m_19879_();
                    buf.writeInt(entityId);
                    buf.m_130070_(entity.m_5446_().getString());
                    continue;
                }
                buf.writeByte(1);
                CompoundTag nbt = entity.serializeNBT();
                PacketChamberInfoReady.writeNBT(buf, nbt);
                continue;
            }
            buf.writeByte(0);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    private static void writeNBT(FriendlyByteBuf dataOut, CompoundTag nbt) {
        FriendlyByteBuf buf = new FriendlyByteBuf((ByteBuf)dataOut);
        try {
            buf.m_130079_(nbt);
        }
        catch (Exception e) {
            Logging.logError((String)"Error writing packet chamber info", (Throwable)e);
        }
    }

    public static PacketChamberInfoReady create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<BlockState, Integer> blocks = new HashMap<BlockState, Integer>(size);
        HashMap<BlockState, Integer> costs = new HashMap<BlockState, Integer>(size);
        HashMap<BlockState, ItemStack> stacks = new HashMap<BlockState, ItemStack>();
        for (int i = 0; i < size; ++i) {
            BlockState bm = Block.m_49803_((int)buf.readInt());
            int count = buf.readInt();
            int cost = buf.readInt();
            blocks.put(bm, count);
            costs.put(bm, cost);
            if (!buf.readBoolean()) continue;
            ItemStack stack = NetworkTools.readItemStack((FriendlyByteBuf)buf);
            stacks.put(bm, stack);
        }
        size = buf.readInt();
        HashMap<String, Integer> entities = new HashMap<String, Integer>(size);
        HashMap<String, Integer> entityCosts = new HashMap<String, Integer>(size);
        HashMap<String, Entity> realEntities = new HashMap<String, Entity>();
        HashMap<String, String> playerNames = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String className = buf.m_130136_(Short.MAX_VALUE);
            int count = buf.readInt();
            int cost = buf.readInt();
            entities.put(className, count);
            entityCosts.put(className, cost);
            byte how = buf.readByte();
            if (how == 1) {
                CompoundTag compoundTag = buf.m_130260_();
                continue;
            }
            if (how != 2) continue;
            int entityId = buf.readInt();
            String entityName = buf.m_130136_(Short.MAX_VALUE);
            Entity entity = SafeClientTools.getClientWorld().m_6815_(entityId);
            if (entity != null) {
                realEntities.put(className, entity);
            }
            playerNames.put(className, entityName);
        }
        return new PacketChamberInfoReady(blocks, costs, stacks, entities, entityCosts, realEntities, playerNames);
    }

    public static PacketChamberInfoReady create(Map<BlockState, Integer> blocks, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities) {
        return new PacketChamberInfoReady(new HashMap<BlockState, Integer>(blocks), new HashMap<BlockState, Integer>(costs), new HashMap<BlockState, ItemStack>(stacks), new HashMap<String, Integer>(entities), new HashMap<String, Integer>(entityCosts), new HashMap<String, Entity>(realEntities), new HashMap<String, String>());
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> GuiChamberDetails.setItemsWithCount(this.blocks, this.costs, this.stacks, this.entities, this.entityCosts, this.realEntities, this.playerNames));
    }
}

