/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block.entity;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.UtilityBlockModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidHopperBlockEntity
extends BlockEntity {
    int tick = 0;
    public LazyOptional<IFluidHandler> internalTank = LazyOptional.of(() -> new FluidTank(1000, p -> true));

    public FluidHopperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)UtilityBlockModule.FLUID_HOPPER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.FLUID_HANDLER)) {
            return this.internalTank.cast();
        }
        return super.getCapability(cap, side);
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, FluidHopperBlockEntity blockEntity) {
        if (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue() && ++blockEntity.tick >= (Integer)Config.SERVER.FLUID_HOPPER_TICK_RATE.get()) {
            blockEntity.internalTank.ifPresent(internalTank -> {
                LazyOptional handler;
                blockEntity.tick = 0;
                boolean hasInserted = false;
                FluidStack internalFluid = internalTank.getFluidInTank(0);
                boolean hasSpaceForBucket = internalFluid.getAmount() == 0;
                BlockState blockStateAbove = level.m_8055_(blockPos.m_7494_());
                if (hasSpaceForBucket && blockStateAbove.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockStateAbove.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    level.m_46597_(blockPos.m_7494_(), (BlockState)blockStateAbove.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                    internalTank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    hasInserted = true;
                }
                if (!hasInserted) {
                    FluidState fluidStateAbove = level.m_6425_(blockPos.m_7494_());
                    if (hasSpaceForBucket && !fluidStateAbove.m_192917_(Fluids.f_76191_) && fluidStateAbove.m_76170_() && (internalFluid.isEmpty() || fluidStateAbove.m_164512_(internalFluid.getFluid()))) {
                        level.m_46597_(blockPos.m_7494_(), Blocks.f_50016_.m_49966_());
                        internalTank.fill(new FluidStack(fluidStateAbove.m_76152_(), 1000), IFluidHandler.FluidAction.EXECUTE);
                        hasInserted = true;
                    }
                }
                if (!hasInserted && (handler = FluidUtil.getFluidHandler((Level)level, (BlockPos)blockPos.m_7494_(), (Direction)Direction.DOWN)).isPresent()) {
                    handler.ifPresent(iFluidHandler -> {
                        if (internalFluid.isEmpty() || internalFluid.equals((Object)iFluidHandler.getFluidInTank(0))) {
                            FluidUtil.tryFluidTransfer((IFluidHandler)internalTank, (IFluidHandler)iFluidHandler, (int)1000, (boolean)true);
                        }
                    });
                    hasInserted = true;
                }
                if (!hasInserted && blockStateAbove.m_204336_(BlockTags.f_144269_)) {
                    FlowingFluid cauldronFluid;
                    Object object = blockStateAbove.m_60713_(Blocks.f_152476_) ? Fluids.f_76193_ : (cauldronFluid = blockStateAbove.m_60713_(Blocks.f_152477_) ? Fluids.f_76195_ : Fluids.f_76191_);
                    if (!cauldronFluid.m_6212_(Fluids.f_76191_) && hasSpaceForBucket) {
                        level.m_46597_(blockPos.m_7494_(), Blocks.f_50256_.m_49966_());
                        internalTank.fill(new FluidStack((Fluid)cauldronFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                Direction direction = (Direction)blockState.m_61143_((Property)HopperBlock.f_54021_);
                LazyOptional facingHandler = FluidUtil.getFluidHandler((Level)level, (BlockPos)blockPos.m_121945_(direction), (Direction)direction.m_122424_());
                facingHandler.ifPresent(iFluidHandler -> FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)internalTank, (int)Math.min(internalTank.getFluidInTank(0).getAmount(), 1000), (boolean)true));
            });
        }
    }
}

