/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;

public class AddWaypointPacket
extends BaseS2CMessage {
    private final String name;
    private final GlobalPos position;
    private final int color;
    private final boolean useGui;

    public AddWaypointPacket(String name, GlobalPos position, int color, boolean useGui) {
        this.name = name;
        this.position = position;
        this.color = color;
        this.useGui = useGui;
    }

    public AddWaypointPacket(FriendlyByteBuf buf) {
        this.name = buf.m_130277_();
        this.position = buf.m_236872_();
        this.color = buf.readInt();
        this.useGui = buf.readBoolean();
    }

    public MessageType getType() {
        return FTBChunksNet.ADD_WAYPOINT;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_236814_(this.position);
        buf.writeInt(this.color);
        buf.writeBoolean(this.useGui);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (this.useGui) {
                StringConfig configName = new StringConfig();
                configName.setValue((Object)this.name);
                new FTBChunksClient.WaypointAddScreen(configName, this.position).openGui();
            } else {
                FTBChunksClient.addWaypoint(this.name, this.position, this.color);
            }
        });
    }
}

