/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import owmii.powah.forge.compat.curios.CurioTagsProvider;
import owmii.powah.forge.data.LootTableGenerator;
import owmii.powah.forge.data.TagsProvider;
import owmii.powah.world.gen.Features;

public class DataEvents {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator.PackGenerator pack = generator.m_253147_(true);
        RegistryAccess.Frozen registryAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        CompletableFuture<HolderLookup.Provider> registries = DataEvents.createPowahProvider((RegistryAccess)registryAccess);
        TagsProvider.Blocks blockTagsProvider = (TagsProvider.Blocks)pack.m_253108_(packOutput -> new TagsProvider.Blocks(packOutput, registries, existingFileHelper));
        pack.m_253108_(packOutput -> new TagsProvider.Items(packOutput, registries, blockTagsProvider.m_274426_(), existingFileHelper));
        pack.m_253108_(packOutput -> new CurioTagsProvider(packOutput, registries, blockTagsProvider.m_274426_(), event.getExistingFileHelper()));
        pack.m_253108_(DataEvents::createLoot);
        pack.m_253108_(output -> new DatapackBuiltinEntriesProvider(output, registries, Set.of("powah")));
    }

    public static LootTableProvider createLoot(PackOutput output) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(LootTableGenerator::new, LootContextParamSets.f_81421_)));
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> factory, CompletableFuture<HolderLookup.Provider> factories) {
        return packOutput -> (DataProvider)factory.apply(packOutput, factories);
    }

    private static CompletableFuture<HolderLookup.Provider> createPowahProvider(RegistryAccess registryAccess) {
        CompletableFuture<HolderLookup.Provider> vanillaLookup = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());
        return vanillaLookup.thenApply(provider -> {
            RegistrySetBuilder builder = new RegistrySetBuilder().m_254916_(Registries.f_256911_, Features::initConfiguredFeatures).m_254916_(Registries.f_256988_, Features::initPlacedFeatures);
            return builder.m_254929_(registryAccess, provider);
        });
    }
}

