/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import reliquary.data.ChestLootEnabledCondition;
import reliquary.data.ChestLootInjectSubProvider;
import reliquary.data.EntityLootEnabledCondition;
import reliquary.data.EntityLootInjectSubProvider;
import reliquary.init.ModItems;

public class ReliquaryLootModifierProvider
extends GlobalLootModifierProvider {
    ReliquaryLootModifierProvider(PackOutput packOutput) {
        super(packOutput, "reliquary");
    }

    protected void start() {
        ChestLootInjectSubProvider.LOOT_INJECTS.forEach((vanillaLootTable, injectLootTable) -> this.add(vanillaLootTable.m_135815_(), (IGlobalLootModifier)InjectLootModifier.chest(injectLootTable, vanillaLootTable)));
        EntityLootInjectSubProvider.LOOT_INJECTS.forEach((vanillaLootTable, injectLootTable) -> this.add(vanillaLootTable.m_135815_(), (IGlobalLootModifier)InjectLootModifier.entity(injectLootTable, vanillaLootTable)));
    }

    public static class InjectLootModifier
    extends LootModifier {
        public static final Codec<InjectLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(m -> m.lootTable), (App)ResourceLocation.f_135803_.fieldOf("loot_table_to_inject_into").forGetter(m -> m.lootTableToInjectInto))).apply((Applicative)inst, InjectLootModifier::new));
        private final ResourceLocation lootTable;
        private final ResourceLocation lootTableToInjectInto;

        protected InjectLootModifier(LootItemCondition[] conditions, ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            super(conditions);
            this.lootTable = lootTable;
            this.lootTableToInjectInto = lootTableToInjectInto;
        }

        protected static InjectLootModifier chest(ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            return new InjectLootModifier(new LootItemCondition[]{ChestLootEnabledCondition.builder().m_6409_(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto).m_6409_()}, lootTable, lootTableToInjectInto);
        }

        protected static InjectLootModifier entity(ResourceLocation lootTable, ResourceLocation lootTableToInjectInto) {
            return new InjectLootModifier(new LootItemCondition[]{EntityLootEnabledCondition.builder().m_6409_(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto).m_6409_()}, lootTable, lootTableToInjectInto);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            LootTable table = context.m_278643_().m_278676_(this.lootTable);
            table.m_79131_(context, arg_0 -> generatedLoot.add(arg_0));
            return generatedLoot;
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return (Codec)ModItems.INJECT_LOOT.get();
        }
    }
}

