/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.blocks;

import commoble.hyperbox.Hyperbox;
import commoble.hyperbox.blocks.ApertureBlockEntity;
import commoble.hyperbox.blocks.HyperboxBlock;
import commoble.hyperbox.blocks.HyperboxBlockEntity;
import commoble.hyperbox.dimension.DelayedTeleportData;
import commoble.hyperbox.dimension.HyperboxWorldData;
import commoble.hyperbox.dimension.SpawnPointHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ApertureBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public ApertureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)Hyperbox.INSTANCE.apertureBlockEntityType.get()).m_155264_(pos, state);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                BlockPos parentPos;
                ServerLevel serverLevel = (ServerLevel)level;
                MinecraftServer server = serverPlayer.f_8924_;
                HyperboxWorldData data = HyperboxWorldData.getOrCreate(serverLevel);
                ResourceKey<Level> parentKey = data.getParentWorld();
                BlockPos targetPos = parentPos = data.getParentPos();
                ServerLevel destinationLevel = server.m_129880_(parentKey);
                if (destinationLevel == null) {
                    destinationLevel = server.m_129880_(Level.f_46428_);
                }
                Direction apertureFacing = (Direction)state.m_61143_((Property)FACING);
                BlockState parentState = destinationLevel.m_8055_(parentPos);
                Block parentBlock = parentState.m_60734_();
                if (parentBlock instanceof HyperboxBlock) {
                    HyperboxBlock hyperboxBlock = (HyperboxBlock)parentBlock;
                    Direction hyperboxFacing = hyperboxBlock.getCurrentFacing(parentState, apertureFacing.m_122424_());
                    targetPos = parentPos.m_121945_(hyperboxFacing);
                    if (destinationLevel.m_8055_(targetPos).m_60800_((BlockGetter)destinationLevel, targetPos) < 0.0f) {
                        targetPos = parentPos;
                    }
                    targetPos = SpawnPointHelper.getBestSpawnPosition((BlockGetter)destinationLevel, targetPos, targetPos.m_7918_(-3, -3, -3), targetPos.m_7918_(3, 3, 3));
                }
                DelayedTeleportData.getOrCreate(serverPlayer.m_284548_()).schedulePlayerTeleport((Player)serverPlayer, (ResourceKey<Level>)destinationLevel.m_46472_(), Vec3.m_82512_((Vec3i)targetPos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_6861_(BlockState thisState, Level level, BlockPos thisPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.m_8055_(fromPos), fromPos);
        super.m_6861_(thisState, level, thisPos, fromBlock, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState thisState, LevelReader level, BlockPos thisPos, BlockPos neighborPos) {
        this.onNeighborUpdated(thisState, (BlockGetter)level, thisPos, level.m_8055_(neighborPos), neighborPos);
        super.onNeighborChange(thisState, level, thisPos, neighborPos);
    }

    protected void onNeighborUpdated(BlockState thisState, BlockGetter level, BlockPos thisPos, BlockState neighborState, BlockPos neighborPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction directionToNeighbor = (Direction)thisState.m_61143_((Property)FACING);
            int weakPower = neighborState.m_60746_(level, neighborPos, directionToNeighbor);
            int strongPower = neighborState.m_60775_(level, neighborPos, directionToNeighbor);
            ApertureBlock.getLinkedHyperbox(serverLevel, thisPos).ifPresent(hyperbox -> {
                hyperbox.updatePower(weakPower, strongPower, directionToNeighbor.m_122424_());
                hyperbox.m_6596_();
            });
        }
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ApertureBlockEntity) {
            ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
            n = aperture.getPower(false);
        } else {
            n = 0;
        }
        return n;
    }

    @Deprecated
    public int m_6376_(BlockState blockState, BlockGetter level, BlockPos pos, Direction sideOfAdjacentBlock) {
        int n;
        BlockEntity blockEntity;
        if (sideOfAdjacentBlock.m_122424_() == blockState.m_61143_((Property)FACING) && (blockEntity = level.m_7702_(pos)) instanceof ApertureBlockEntity) {
            ApertureBlockEntity aperture = (ApertureBlockEntity)blockEntity;
            n = aperture.getPower(true);
        } else {
            n = 0;
        }
        return n;
    }

    public static Optional<HyperboxBlockEntity> getLinkedHyperbox(ServerLevel level, BlockPos thisPos) {
        Optional<HyperboxBlockEntity> optional;
        MinecraftServer server = level.m_7654_();
        HyperboxWorldData data = HyperboxWorldData.getOrCreate(level);
        BlockPos parentPos = data.getParentPos();
        ResourceKey<Level> parentLevelKey = data.getParentWorld();
        ServerLevel parentLevel = server.m_129880_(parentLevelKey);
        BlockEntity blockEntity = parentLevel.m_7702_(parentPos);
        if (blockEntity instanceof HyperboxBlockEntity) {
            HyperboxBlockEntity hyperbox = (HyperboxBlockEntity)blockEntity;
            optional = Optional.of(hyperbox);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

