/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.dimension;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;

public class SpawnPointHelper {
    public static BlockPos getBestSpawnPosition(BlockGetter world, BlockPos target, BlockPos minSpawnCorner, BlockPos maxSpawnCorner) {
        BlockPos clampedTarget;
        BlockPos bestPos = clampedTarget = SpawnPointHelper.clamp(target, minSpawnCorner, maxSpawnCorner);
        int bestPosViability = -1;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> remaining = new LinkedList<BlockPos>();
        remaining.add(clampedTarget);
        while (remaining.size() > 0) {
            BlockPos nextPos = (BlockPos)remaining.removeFirst();
            visited.add(nextPos);
            int viability = SpawnPointHelper.getViability(world, nextPos);
            if (viability == 3) {
                return nextPos;
            }
            if (viability > bestPosViability) {
                bestPos = nextPos;
                bestPosViability = viability;
            }
            for (Direction dir : Direction.values()) {
                BlockPos nextPosToVisit = nextPos.m_121945_(dir);
                if (visited.contains(nextPosToVisit) || !SpawnPointHelper.isPosAllowed(world, nextPosToVisit, minSpawnCorner, maxSpawnCorner)) continue;
                remaining.add(nextPosToVisit);
            }
        }
        return bestPos;
    }

    public static BlockPos clamp(BlockPos pos, BlockPos min, BlockPos max) {
        int x = Mth.m_14045_((int)pos.m_123341_(), (int)min.m_123341_(), (int)max.m_123341_());
        int y = Mth.m_14045_((int)pos.m_123342_(), (int)min.m_123342_(), (int)max.m_123342_());
        int z = Mth.m_14045_((int)pos.m_123343_(), (int)min.m_123343_(), (int)max.m_123343_());
        return new BlockPos(x, y, z);
    }

    public static boolean isPosAllowed(BlockGetter world, BlockPos pos, BlockPos min, BlockPos max) {
        return SpawnPointHelper.isPosWithinBounds(pos, min, max) && world.m_8055_(pos).m_60800_(world, pos) >= 0.0f;
    }

    public static boolean isPosWithinBounds(BlockPos pos, BlockPos min, BlockPos max) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        return x >= min.m_123341_() && x <= max.m_123341_() && y >= min.m_123342_() && y <= max.m_123342_() && z >= min.m_123343_() && z <= max.m_123343_();
    }

    public static int getViability(BlockGetter world, BlockPos target) {
        return SpawnPointHelper.doesBlockBlockHead(world, target.m_7494_()) ? 0 : (SpawnPointHelper.doesBlockBlockFeet(world, target) ? 1 : (SpawnPointHelper.doesBlockBlockFeet(world, target.m_7495_()) ? 3 : 2));
    }

    public static boolean doesBlockBlockHead(BlockGetter world, BlockPos pos) {
        return !world.m_8055_(pos).m_60808_(world, pos).m_83281_();
    }

    public static boolean doesBlockBlockFeet(BlockGetter world, BlockPos pos) {
        return !world.m_8055_(pos).m_60812_(world, pos).m_83281_();
    }
}

