/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.datagen;

import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.ChemicalBlockType;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.registry.BlockRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(@Nonnull Consumer<FinishedRecipe> pConsumer) {
        BlockRegistry.getChemicalBlocksByType(ChemicalBlockType.LAMP).forEach(block -> {
            Chemical chemical = block.getChemical();
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('E'), (ItemLike)chemical).m_126130_("GEG").m_126130_("EEE").m_126130_("GEG").m_126132_(String.format("has_%s", chemical), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemical}).m_45077_()})).m_176498_(pConsumer);
        });
        BlockRegistry.getChemicalBlocksByType(ChemicalBlockType.METAL).forEach(block -> {
            Chemical chemical = block.getChemical();
            ItemRegistry.getChemicalItemByNameAndType(chemical.getChemicalName(), ChemicalItemType.INGOT).ifPresent(ingot -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).m_126127_(Character.valueOf('I'), (ItemLike)ingot).m_126130_("III").m_126130_("III").m_126130_("III").m_126132_(String.format("has_%s", chemical), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemical}).m_45077_()})).m_176500_(pConsumer, String.format("%s:%s_ingot_to_block", "chemlib", chemical.getChemicalName())));
        });
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.INGOT).forEach(ingot -> {
            Chemical chemical = ingot.getChemical();
            ItemRegistry.getChemicalItemByNameAndType(chemical.getChemicalName(), ChemicalItemType.NUGGET).ifPresent(nugget -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot).m_126127_(Character.valueOf('N'), (ItemLike)nugget).m_126130_("NNN").m_126130_("NNN").m_126130_("NNN").m_126132_(String.format("has_%s", chemical), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemical}).m_45077_()})).m_176500_(pConsumer, String.format("%s:%s_nugget_to_ingot", "chemlib", chemical.getChemicalName())));
        });
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.INGOT).forEach(ingot -> {
            Chemical chemical = ingot.getChemical();
            BlockRegistry.getChemicalBlockByNameAndType(chemical.getChemicalName(), ChemicalBlockType.METAL).ifPresent(block -> ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot, (int)9).m_126209_((ItemLike)block).m_126132_(String.format("has_%s", chemical), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemical}).m_45077_()})).m_176500_(pConsumer, String.format("%s:%s_block_to_ingot", "chemlib", chemical.getChemicalName())));
        });
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.INGOT).forEach(ingot -> {
            Chemical chemical = ingot.getChemical();
            ItemRegistry.getChemicalItemByNameAndType(chemical.getChemicalName(), ChemicalItemType.NUGGET).ifPresent(nugget -> ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (int)9).m_126209_((ItemLike)ingot).m_126132_(String.format("has_%s", chemical), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemical}).m_45077_()})).m_176500_(pConsumer, String.format("%s:%s_ingot_to_nugget", "chemlib", chemical.getChemicalName())));
        });
        ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.DUST).forEach(dust -> ItemRegistry.getElementByName(dust.getChemicalName()).flatMap(elementItem -> ItemRegistry.getChemicalItemByNameAndType(elementItem.getChemicalName(), ChemicalItemType.INGOT)).ifPresent(chemicalItem -> {
            String chemicalName = chemicalItem.getChemicalName();
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)chemicalItem, (float)0.7f, (int)200).m_126132_(String.format("has_%s", chemicalItem.getChemical()), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemicalItem.getChemical()}).m_45077_()})).m_176500_(pConsumer, String.format("%s:%s_ingot_from_smelting_%s_dust", "chemlib", chemicalName, chemicalName));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)chemicalItem, (float)0.7f, (int)100).m_126132_(String.format("has_%s", chemicalItem.getChemical()), (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{chemicalItem.getChemical()}).m_45077_()})).m_176500_(pConsumer, String.format("%s:%s_ingot_from_blasting_%s_dust", "chemlib", chemicalName, chemicalName));
        }));
        ItemRegistry.getChemicalItemByNameAndType("copper", ChemicalItemType.DUST).ifPresent(dust -> {
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_, (float)0.7f, (int)200).m_126132_("has_copper", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{dust}).m_45077_()})).m_176500_(pConsumer, String.format("%s:copper_ingot_from_smelting_copper_dust", "chemlib"));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_, (float)0.7f, (int)100).m_126132_("has_copper", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{dust}).m_45077_()})).m_176500_(pConsumer, String.format("%s:copper_ingot_from_blasting_copper_dust", "chemlib"));
        });
        ItemRegistry.getChemicalItemByNameAndType("iron", ChemicalItemType.DUST).ifPresent(dust -> {
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42416_, (float)0.7f, (int)200).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{dust}).m_45077_()})).m_176500_(pConsumer, String.format("%s:iron_ingot_from_smelting_iron_dust", "chemlib"));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42416_, (float)0.7f, (int)100).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{dust}).m_45077_()})).m_176500_(pConsumer, String.format("%s:iron_ingot_from_blasting_iron_dust", "chemlib"));
        });
        ItemRegistry.getChemicalItemByNameAndType("gold", ChemicalItemType.DUST).ifPresent(dust -> {
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42417_, (float)0.7f, (int)200).m_126132_("has_gold", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{dust}).m_45077_()})).m_176500_(pConsumer, String.format("%s:gold_ingot_from_smelting_gold_dust", "chemlib"));
            SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{dust}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42417_, (float)0.7f, (int)100).m_126132_("has_gold", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{dust}).m_45077_()})).m_176500_(pConsumer, String.format("%s:gold_ingot_from_blasting_gold_dust", "chemlib"));
        });
        Item periodicTable = (Item)ItemRegistry.getRegistryObject(ItemRegistry.REGISTRY_MISC_ITEMS, "periodic_table").get();
        Item hydrogen = ItemRegistry.getElementByName("hydrogen").get();
        Item paper = Items.f_42516_;
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)periodicTable).m_126127_(Character.valueOf('H'), (ItemLike)hydrogen).m_126127_(Character.valueOf('P'), (ItemLike)paper).m_126130_("HHH").m_126130_("HPH").m_126130_("HHH").m_126132_("has_hydrogen", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{hydrogen}).m_45077_()})).m_176498_(pConsumer);
    }
}

