/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure;

import com.google.common.collect.ImmutableSet;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureEvents;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingTableTile;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingTableTile;
import dev.shadowsoffire.apotheosis.adventure.boss.BossEvents;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.boss.BossSpawnerBlock;
import dev.shadowsoffire.apotheosis.adventure.boss.Exclusion;
import dev.shadowsoffire.apotheosis.adventure.boss.MinibossRegistry;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureModuleClient;
import dev.shadowsoffire.apotheosis.adventure.compat.AdventureTOPPlugin;
import dev.shadowsoffire.apotheosis.adventure.compat.AdventureTwilightCompat;
import dev.shadowsoffire.apotheosis.adventure.compat.GatewaysCompat;
import dev.shadowsoffire.apotheosis.adventure.gen.BlacklistModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixConvertLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixHookLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootModifier;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.AddSocketsRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.SocketingRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.UnnamingRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.WithdrawalRecipe;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.spawner.RogueSpawnerRegistry;
import dev.shadowsoffire.apotheosis.util.AffixItemIngredient;
import dev.shadowsoffire.apotheosis.util.GemIngredient;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntityType;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.loot.LootSystem;
import dev.shadowsoffire.placebo.registry.RegistryEvent;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdventureModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Adventure");
    public static final boolean STAGES_LOADED = ModList.get().isLoaded("gamestages");
    static final Map<ResourceLocation, LootCategory> IMC_TYPE_OVERRIDES = new HashMap<ResourceLocation, LootCategory>();
    public static final boolean DEBUG = false;

    public AdventureModule() {
        Adventure.bootstrap();
    }

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22284_), (Object)200.0, (String)"f_22308_");
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22285_), (Object)100.0, (String)"f_22308_");
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        MinecraftForge.EVENT_BUS.register((Object)new AdventureEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BossEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        RarityRegistry.INSTANCE.registerToBus();
        AffixRegistry.INSTANCE.registerToBus();
        GemRegistry.INSTANCE.registerToBus();
        AffixLootRegistry.INSTANCE.registerToBus();
        BossRegistry.INSTANCE.registerToBus();
        RogueSpawnerRegistry.INSTANCE.registerToBus();
        MinibossRegistry.INSTANCE.registerToBus();
        Apotheosis.HELPER.registerProvider(f -> {
            f.addRecipe((Recipe)new SocketingRecipe());
            f.addRecipe((Recipe)new WithdrawalRecipe());
            f.addRecipe((Recipe)new UnnamingRecipe());
        });
        e.enqueueWork(() -> {
            if (ModList.get().isLoaded("gateways")) {
                GatewaysCompat.register();
            }
            if (ModList.get().isLoaded("theoneprobe")) {
                AdventureTOPPlugin.register();
            }
            if (ModList.get().isLoaded("twilightforest")) {
                AdventureTwilightCompat.register();
            }
            LootSystem.defaultBlockTable((Block)((Block)Adventure.Blocks.SIMPLE_REFORGING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Adventure.Blocks.REFORGING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Adventure.Blocks.SALVAGING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Adventure.Blocks.GEM_CUTTING_TABLE.get()));
            LootSystem.defaultBlockTable((Block)((Block)Adventure.Blocks.AUGMENTING_TABLE.get()));
            Registry.m_122965_((Registry)BuiltInRegistries.f_257035_, (ResourceLocation)new ResourceLocation("apotheosis", "random_affix_item"), (Object)AffixLootPoolEntry.TYPE);
            Registry.m_122965_((Registry)BuiltInRegistries.f_257035_, (ResourceLocation)new ResourceLocation("apotheosis", "random_gem"), (Object)GemLootPoolEntry.TYPE);
            Exclusion.initSerializers();
            GemBonus.initCodecs();
            CraftingHelper.register((ResourceLocation)Apotheosis.loc("affix_item"), (IIngredientSerializer)AffixItemIngredient.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)Apotheosis.loc("gem"), (IIngredientSerializer)GemIngredient.Serializer.INSTANCE);
            TabFillingRegistry.register((ResourceKey)Adventure.Tabs.ADVENTURE.getKey(), (Supplier[])new Supplier[]{Adventure.Items.COMMON_MATERIAL, Adventure.Items.UNCOMMON_MATERIAL, Adventure.Items.RARE_MATERIAL, Adventure.Items.EPIC_MATERIAL, Adventure.Items.MYTHIC_MATERIAL, Adventure.Items.GEM_DUST, Adventure.Items.GEM_FUSED_SLATE, Adventure.Items.SIGIL_OF_SOCKETING, Adventure.Items.SIGIL_OF_WITHDRAWAL, Adventure.Items.SIGIL_OF_REBIRTH, Adventure.Items.SIGIL_OF_ENHANCEMENT, Adventure.Items.SIGIL_OF_UNNAMING, Adventure.Items.BOSS_SUMMONER, Adventure.Items.SALVAGING_TABLE, Adventure.Items.GEM_CUTTING_TABLE, Adventure.Items.SIMPLE_REFORGING_TABLE, Adventure.Items.REFORGING_TABLE, Adventure.Items.AUGMENTING_TABLE});
            TabFillingRegistry.register((ResourceKey)Adventure.Tabs.ADVENTURE.getKey(), (Supplier[])new Supplier[]{Adventure.Items.GEM});
        });
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((Object)new TickingBlockEntityType(BossSpawnerBlock.BossSpawnerTile::new, (Set)ImmutableSet.of((Object)((Block)Adventure.Blocks.BOSS_SPAWNER.get())), false, true), "boss_spawner");
        e.getRegistry().register((Object)new TickingBlockEntityType(ReforgingTableTile::new, (Set)ImmutableSet.of((Object)((Block)Adventure.Blocks.SIMPLE_REFORGING_TABLE.get()), (Object)((Block)Adventure.Blocks.REFORGING_TABLE.get())), true, false), "reforging_table");
        e.getRegistry().register((Object)new BlockEntityType(SalvagingTableTile::new, (Set)ImmutableSet.of((Object)((Block)Adventure.Blocks.SALVAGING_TABLE.get())), null), "salvaging_table");
        e.getRegistry().register((Object)new TickingBlockEntityType(AugmentingTableTile::new, (Set)ImmutableSet.of((Object)((Block)Adventure.Blocks.AUGMENTING_TABLE.get())), true, false), "augmenting_table");
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((Object)SocketingRecipe.Serializer.INSTANCE, "socketing");
        e.getRegistry().register((Object)WithdrawalRecipe.Serializer.INSTANCE, "widthdrawal");
        e.getRegistry().register((Object)UnnamingRecipe.Serializer.INSTANCE, "unnaming");
        e.getRegistry().register((Object)AddSocketsRecipe.Serializer.INSTANCE, "add_sockets");
        e.getRegistry().register((Object)SalvagingRecipe.Serializer.INSTANCE, "salvaging");
        e.getRegistry().register((Object)ReforgingRecipe.Serializer.INSTANCE, "reforging");
    }

    @SubscribeEvent
    public void miscRegistration(RegisterEvent e) {
        if (e.getForgeRegistry() == ForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.get()) {
            e.getForgeRegistry().register("gems", GemLootModifier.CODEC);
            e.getForgeRegistry().register("affix_loot", AffixLootModifier.CODEC);
            e.getForgeRegistry().register("affix_conversion", AffixConvertLootModifier.CODEC);
            e.getForgeRegistry().register("affix_hook", AffixHookLootModifier.CODEC);
        }
        if (e.getForgeRegistry() == ForgeRegistries.BIOME_MODIFIER_SERIALIZERS.get()) {
            e.getForgeRegistry().register("blacklist", BlacklistModifier.CODEC);
        }
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(AdventureModuleClient::init);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new AdventureModuleClient());
    }

    @SubscribeEvent
    public void imc(InterModProcessEvent e) {
        e.getIMCStream().forEach(msg -> {
            switch (msg.method().toLowerCase(Locale.ROOT)) {
                case "loot_category_override": {
                    try {
                        Map.Entry categoryOverride = (Map.Entry)msg.messageSupplier().get();
                        ResourceLocation item = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)categoryOverride.getKey()));
                        LootCategory cat = LootCategory.byId((String)categoryOverride.getValue());
                        if (cat == null) {
                            throw new NullPointerException("Invalid loot category ID: " + (String)categoryOverride.getValue());
                        }
                        IMC_TYPE_OVERRIDES.put(item, cat);
                        LOGGER.info("Mod {} has overriden the loot category of {} to {}.", (Object)msg.senderModId(), (Object)item, (Object)cat.getName());
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage());
                        ex.printStackTrace();
                    }
                    break;
                }
                default: {
                    LOGGER.error("Unknown or invalid IMC Message: {}", msg);
                }
            }
        });
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration mainConfig = new Configuration(new File(Apotheosis.configDir, "adventure.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        AdventureConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (e == null && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }

    public static class ApothSmithingRecipe
    extends SmithingTransformRecipe {
        public static final int TEMPLATE = 0;
        public static final int BASE = 1;
        public static final int ADDITION = 2;

        public ApothSmithingRecipe(ResourceLocation pId, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
            super(pId, Ingredient.f_43901_, pBase, pAddition, pResult);
        }

        public boolean m_266343_(ItemStack pStack) {
            return !LootCategory.forItem(pStack).isNone();
        }
    }
}

