/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fluids.FluidType;

public class OmneticAffix
extends Affix {
    public static final Codec<OmneticAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(OmneticData.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, OmneticAffix::new));
    protected final Map<LootRarity, OmneticData> values;

    public OmneticAffix(Map<LootRarity, OmneticData> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        return Component.m_237110_((String)("affix." + String.valueOf(this.getId()) + ".desc"), (Object[])new Object[]{Component.m_237115_((String)("misc.apotheosis." + this.values.get((Object)rarity).name))});
    }

    public void harvest(PlayerEvent.HarvestCheck e) {
        AffixInstance inst;
        ItemStack stack = e.getEntity().m_21205_();
        if (!stack.m_41619_() && (inst = AffixHelper.getAffixes(stack).get(Apoth.Affixes.OMNETIC)) != null && inst.isValid()) {
            OmneticData data = this.values.get(inst.rarity().get());
            for (ItemStack item : data.items()) {
                if (!item.m_41735_(e.getTargetBlock())) continue;
                e.setCanHarvest(true);
                return;
            }
        }
    }

    public void speed(PlayerEvent.BreakSpeed e) {
        AffixInstance inst;
        ItemStack stack = e.getEntity().m_21205_();
        if (!stack.m_41619_() && (inst = AffixHelper.getAffixes(stack).get(Apoth.Affixes.OMNETIC)) != null && inst.isValid()) {
            float speed = e.getOriginalSpeed();
            OmneticData data = this.values.get(inst.rarity().get());
            for (ItemStack item : data.items()) {
                speed = Math.max(OmneticAffix.getBaseSpeed(e.getEntity(), item, e.getState(), e.getPosition().orElse(BlockPos.f_121853_)), speed);
            }
            e.setNewSpeed(speed);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    static float getBaseSpeed(Player player, ItemStack tool, BlockState state, BlockPos pos) {
        float f = tool.m_41691_(state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.m_44926_((LivingEntity)player);
            ItemStack itemstack = player.m_21205_();
            if (i > 0 && !itemstack.m_41619_()) {
                f += (float)(i * i + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            float f1 = switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                case 3 -> 8.1E-4f;
                default -> 8.1E-4f;
            };
            f *= f1;
        }
        if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            f /= 5.0f;
        }
        if (!player.m_20096_()) {
            f /= 5.0f;
        }
        return f;
    }

    record OmneticData(String name, ItemStack[] items) {
        public static Codec<OmneticData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("name").forGetter(OmneticData::name), (App)Codec.list((Codec)ItemAdapter.CODEC).xmap(l -> l.toArray(new ItemStack[0]), Arrays::asList).fieldOf("items").forGetter(OmneticData::items)).apply((Applicative)inst, OmneticData::new));
    }
}

